/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.state.DefaultISMLocking;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalActivity;
import org.apache.jackrabbit.core.version.InternalActivityImpl;
import org.apache.jackrabbit.core.version.InternalBaseline;
import org.apache.jackrabbit.core.version.InternalFrozenNodeImpl;
import org.apache.jackrabbit.core.version.InternalFrozenVHImpl;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class InternalVersionManagerBase
implements InternalVersionManager {
    private static Logger log = LoggerFactory.getLogger(InternalVersionManagerBase.class);
    protected LocalItemStateManager stateMgr;
    protected final NodeTypeRegistry ntReg;
    protected final NodeId historiesId;
    protected final NodeId activitiesId;
    private final DefaultISMLocking rwLock = new DefaultISMLocking();

    protected InternalVersionManagerBase(NodeTypeRegistry ntReg, NodeId historiesId, NodeId activitiesId) {
        this.ntReg = ntReg;
        this.historiesId = historiesId;
        this.activitiesId = activitiesId;
    }

    public InternalVersion getVersion(NodeId id) throws RepositoryException {
        InternalVersion v = (InternalVersion)this.getItem(id);
        if (v == null) {
            log.warn("Versioning item not found: " + id);
        }
        return v;
    }

    public InternalBaseline getBaseline(NodeId id) throws RepositoryException {
        InternalVersionItem item = this.getItem(id);
        if (item == null) {
            log.warn("Versioning item not found: " + id);
        } else if (!(item instanceof InternalBaseline)) {
            log.warn("Versioning item is not a baseline: " + id);
            item = null;
        }
        return (InternalBaseline)item;
    }

    public InternalActivity getActivity(NodeId id) throws RepositoryException {
        InternalActivity v = (InternalActivity)this.getItem(id);
        if (v == null) {
            log.warn("Versioning item not found: " + id);
        }
        return v;
    }

    public InternalVersionHistory getVersionHistory(NodeId id) throws RepositoryException {
        return (InternalVersionHistory)this.getItem(id);
    }

    public InternalVersionHistory getVersionHistoryOfNode(NodeId id) throws RepositoryException {
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            String uuid = id.toString();
            Name name = InternalVersionManagerBase.getName(uuid);
            NodeStateEx parent = InternalVersionManagerBase.getParentNode(this.getHistoryRoot(), uuid, null);
            if (parent != null && parent.hasNode(name)) {
                NodeStateEx history = parent.getNode(name, 1);
                InternalVersionHistory internalVersionHistory = this.getVersionHistory(history.getNodeId());
                return internalVersionHistory;
            }
            throw new ItemNotFoundException("Version history of node " + id + " not found.");
        }
        finally {
            lock.release();
        }
    }

    public InternalVersion getHeadVersionOfNode(NodeId id) throws RepositoryException {
        InternalVersionHistory vh = this.getVersionHistoryOfNode(id);
        Name[] names = vh.getVersionNames();
        InternalVersion last = vh.getVersion(names[names.length - 1]);
        return this.getVersion(last.getId());
    }

    protected ISMLocking.WriteLock acquireWriteLock() {
        while (true) {
            try {
                return this.rwLock.acquireWriteLock(null);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected ISMLocking.ReadLock acquireReadLock() {
        while (true) {
            try {
                return this.rwLock.acquireReadLock(null);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected abstract NodeStateEx getHistoryRoot();

    protected abstract NodeStateEx getActivitiesRoot();

    private WriteOperation startWriteOperation() throws RepositoryException {
        boolean success = false;
        ISMLocking.WriteLock lock = this.acquireWriteLock();
        try {
            this.stateMgr.edit();
            success = true;
            WriteOperation writeOperation = new WriteOperation(lock);
            return writeOperation;
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("Unable to start edit operation.", e);
        }
        finally {
            if (!success) {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionHistoryInfo getVersionHistory(Session session, NodeState node, NodeId copiedFrom) throws RepositoryException {
        VersionHistoryInfo info = null;
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            String uuid = node.getNodeId().toString();
            Name name = InternalVersionManagerBase.getName(uuid);
            NodeStateEx parent = InternalVersionManagerBase.getParentNode(this.getHistoryRoot(), uuid, null);
            if (parent != null && parent.hasNode(name)) {
                NodeStateEx history = parent.getNode(name, 1);
                Name root = NameConstants.JCR_ROOTVERSION;
                info = new VersionHistoryInfo(history.getNodeId(), history.getState().getChildNodeEntry(root, 1).getId());
            }
        }
        finally {
            lock.release();
        }
        if (info == null) {
            info = this.createVersionHistory(session, node, copiedFrom);
        }
        return info;
    }

    protected abstract VersionHistoryInfo createVersionHistory(Session var1, NodeState var2, NodeId var3) throws RepositoryException;

    protected abstract InternalVersionItem getItem(NodeId var1) throws RepositoryException;

    protected abstract boolean hasItem(NodeId var1);

    protected abstract boolean hasItemReferences(NodeId var1) throws RepositoryException;

    protected abstract NodeStateEx getNodeStateEx(NodeId var1) throws RepositoryException;

    NodeStateEx internalCreateVersionHistory(NodeState node, NodeId copiedFrom) throws RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            String uuid = node.getNodeId().toString();
            NodeStateEx parent = InternalVersionManagerBase.getParentNode(this.getHistoryRoot(), uuid, NameConstants.REP_VERSIONSTORAGE);
            Name name = InternalVersionManagerBase.getName(uuid);
            if (parent.hasNode(name)) {
                NodeStateEx nodeStateEx = null;
                return nodeStateEx;
            }
            NodeStateEx history = InternalVersionHistoryImpl.create(this, parent, name, node, copiedFrom);
            operation.save();
            log.debug("Created new version history " + history.getNodeId() + " for " + node + ".");
            NodeStateEx nodeStateEx = history;
            return nodeStateEx;
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
        finally {
            operation.close();
        }
    }

    NodeStateEx internalCreateActivity(String title) throws RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            NodeId activityId = new NodeId();
            NodeStateEx parent = InternalVersionManagerBase.getParentNode(this.getActivitiesRoot(), activityId.toString(), NameConstants.REP_ACTIVITIES);
            Name name = InternalVersionManagerBase.getName(activityId.toString());
            NodeStateEx pNode = InternalActivityImpl.create(parent, name, activityId, title);
            operation.save();
            log.debug("Created new activity " + activityId + " with title " + title + ".");
            NodeStateEx nodeStateEx = pNode;
            return nodeStateEx;
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
        finally {
            operation.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRemoveActivity(InternalActivityImpl activity) throws RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            NodeReferences refs;
            NodeId nodeId = activity.getId();
            if (this.stateMgr.hasNodeReferences(nodeId) && (refs = this.stateMgr.getNodeReferences(nodeId)).hasReferences()) {
                throw new ReferentialIntegrityException("Unable to delete activity. still referenced.");
            }
            NodeStateEx act = this.getNodeStateEx(nodeId);
            NodeId parentId = act.getParentId();
            Name name = act.getName();
            while (parentId != null) {
                NodeStateEx parent = this.getNodeStateEx(parentId);
                parent.removeNode(name);
                parent.store();
                if (parent.getChildNodes().length == 0 && !parentId.equals(this.activitiesId)) {
                    name = parent.getName();
                    parentId = parent.getParentId();
                    continue;
                }
                parentId = null;
            }
            operation.save();
        }
        catch (ItemStateException e) {
            log.error("Error while storing: " + e.toString());
        }
        finally {
            operation.close();
        }
    }

    protected static Name getName(String name) {
        return NameFactoryImpl.getInstance().create("", name);
    }

    protected static NodeStateEx getParentNode(NodeStateEx parent, String uuid, Name interNT) throws RepositoryException {
        NodeStateEx n = parent;
        for (int i = 0; i < 3; ++i) {
            Name name = InternalVersionManagerBase.getName(uuid.substring(i * 2, i * 2 + 2));
            if (n.hasNode(name)) {
                n = n.getNode(name, 1);
                continue;
            }
            if (interNT != null) {
                n.addNode(name, interNT, null, false);
                n.store();
                n = n.getNode(name, 1);
                continue;
            }
            return null;
        }
        return n;
    }

    protected InternalVersion internalCheckin(InternalVersionHistoryImpl history, NodeStateEx node, boolean simple, Calendar created) throws RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            String versionName = this.calculateCheckinVersionName(history, node, simple);
            InternalVersionImpl v = history.checkin(NameFactoryImpl.getInstance().create("", versionName), node, created);
            if (node.hasProperty(NameConstants.JCR_ACTIVITY)) {
                NodeId actId = node.getPropertyValue(NameConstants.JCR_ACTIVITY).getNodeId();
                InternalActivityImpl act = (InternalActivityImpl)this.getItem(actId);
                act.addVersion(v);
            }
            operation.save();
            InternalVersionImpl internalVersionImpl = v;
            return internalVersionImpl;
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
        finally {
            operation.close();
        }
    }

    protected String calculateCheckinVersionName(InternalVersionHistoryImpl history, NodeStateEx node, boolean simple) throws RepositoryException {
        InternalVersion best = null;
        if (simple) {
            Name[] names = history.getVersionNames();
            best = history.getVersion(names[names.length - 1]);
        } else {
            InternalValue[] values;
            for (InternalValue value : values = node.getPropertyValues(NameConstants.JCR_PREDECESSORS)) {
                InternalVersion pred = history.getVersion(value.getNodeId());
                if (best != null && pred.getName().getLocalName().length() >= best.getName().getLocalName().length()) continue;
                best = pred;
            }
        }
        String versionName = best.getName().getLocalName();
        int pos = versionName.lastIndexOf(46);
        if (pos > 0) {
            String newVersionName = versionName.substring(0, pos + 1) + (Integer.parseInt(versionName.substring(pos + 1)) + 1);
            while (history.hasVersion(NameFactoryImpl.getInstance().create("", newVersionName))) {
                newVersionName = versionName = versionName + ".0";
            }
            return newVersionName;
        }
        return String.valueOf(best.getSuccessors().length + 1) + ".0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRemoveVersion(InternalVersionHistoryImpl history, Name name) throws VersionException, RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            history.removeVersion(name);
            operation.save();
        }
        catch (ItemStateException e) {
            log.error("Error while storing: " + e.toString());
        }
        finally {
            operation.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalVersion setVersionLabel(InternalVersionHistoryImpl history, Name version, Name label, boolean move) throws RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            InternalVersion v = history.setVersionLabel(version, label, move);
            operation.save();
            InternalVersion internalVersion = v;
            return internalVersion;
        }
        catch (ItemStateException e) {
            log.error("Error while storing: " + e.toString());
            InternalVersion internalVersion = null;
            return internalVersion;
        }
        finally {
            operation.close();
        }
    }

    protected void versionCreated(InternalVersion version) {
    }

    protected void versionDestroyed(InternalVersion version) {
    }

    protected void itemDiscarded(InternalVersionItem item) {
    }

    protected InternalVersionItem createInternalVersionItem(NodeId id) throws RepositoryException {
        try {
            if (this.stateMgr.hasItemState(id)) {
                NodeState state = (NodeState)this.stateMgr.getItemState(id);
                NodeStateEx pNode = new NodeStateEx(this.stateMgr, this.ntReg, state, null);
                NodeId parentId = pNode.getParentId();
                InternalVersionItem parent = this.getItem(parentId);
                Name ntName = state.getNodeTypeName();
                if (ntName.equals(NameConstants.NT_FROZENNODE)) {
                    return new InternalFrozenNodeImpl(this, pNode, parent);
                }
                if (ntName.equals(NameConstants.NT_VERSIONEDCHILD)) {
                    return new InternalFrozenVHImpl(this, pNode, parent);
                }
                if (ntName.equals(NameConstants.NT_VERSION)) {
                    return ((InternalVersionHistory)parent).getVersion(id);
                }
                if (ntName.equals(NameConstants.NT_VERSIONHISTORY)) {
                    return new InternalVersionHistoryImpl(this, pNode);
                }
                if (ntName.equals(NameConstants.NT_ACTIVITY)) {
                    return new InternalActivityImpl(this, pNode);
                }
                return null;
            }
            return null;
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
    }

    private class WriteOperation {
        private boolean success = false;
        private final ISMLocking.WriteLock lock;

        public WriteOperation(ISMLocking.WriteLock lock) {
            this.lock = lock;
        }

        public void save() throws ItemStateException, RepositoryException {
            InternalVersionManagerBase.this.stateMgr.update();
            this.success = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                if (!this.success) {
                    InternalVersionManagerBase.this.stateMgr.cancel();
                }
            }
            finally {
                this.lock.release();
            }
        }
    }
}

