/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.ProtectedItemModifier;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.GroupImpl;
import org.apache.jackrabbit.core.security.user.IndexNodeResolver;
import org.apache.jackrabbit.core.security.user.NodeResolver;
import org.apache.jackrabbit.core.security.user.TraversingNodeResolver;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagerImpl
extends ProtectedItemModifier
implements UserManager,
UserConstants,
SessionListener {
    public static final String PARAM_COMPATIBILE_JR16 = "compatibleJR16";
    public static final String PARAM_DEFAULT_DEPTH = "defaultDepth";
    public static final String PARAM_AUTO_EXPAND_TREE = "autoExpandTree";
    public static final String PARAM_AUTO_EXPAND_SIZE = "autoExpandSize";
    private static final Logger log = LoggerFactory.getLogger(UserManagerImpl.class);
    private final SessionImpl session;
    private final String adminId;
    private final NodeResolver authResolver;
    private final IdResolver idResolver;
    private final boolean compatibleJR16;

    public UserManagerImpl(SessionImpl session, String adminId) throws RepositoryException {
        this(session, adminId, null);
    }

    public UserManagerImpl(SessionImpl session, String adminId, Properties config) throws RepositoryException {
        NodeResolver nr;
        this.session = session;
        this.adminId = adminId;
        try {
            nr = new IndexNodeResolver(session, session);
        }
        catch (RepositoryException e) {
            log.debug("UserManager: no QueryManager available for workspace '" + session.getWorkspace().getName() + "' -> Use traversing node resolver.");
            nr = new TraversingNodeResolver(session, session);
        }
        this.authResolver = nr;
        this.idResolver = new IdResolver(config);
        boolean compatMode = false;
        if (config != null && config.containsKey(PARAM_COMPATIBILE_JR16)) {
            compatMode = Boolean.parseBoolean(config.get(PARAM_COMPATIBILE_JR16).toString());
        }
        this.compatibleJR16 = compatMode;
    }

    public Authorizable getAuthorizable(String id) throws RepositoryException {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Invalid authorizable name '" + id + "'");
        }
        Authorizable authorz = null;
        NodeImpl n = this.getUserNode(id);
        if (n != null) {
            authorz = this.createUser(n);
        } else {
            n = this.getGroupNode(id);
            if (n != null) {
                authorz = this.createGroup(n);
            }
        }
        return authorz;
    }

    public Authorizable getAuthorizable(Principal principal) throws RepositoryException {
        NodeImpl n = null;
        if (principal instanceof ItemBasedPrincipal) {
            Item authItem;
            String authPath = ((ItemBasedPrincipal)principal).getPath();
            if (this.session.itemExists(authPath) && (authItem = this.session.getItem(authPath)).isNode()) {
                n = (NodeImpl)authItem;
            }
        } else {
            String name = principal.getName();
            n = (NodeImpl)this.authResolver.findNode(P_PRINCIPAL_NAME, name, NT_REP_AUTHORIZABLE);
        }
        if (n != null) {
            if (n.isNodeType(NT_REP_USER)) {
                return this.createUser(n);
            }
            if (n.isNodeType(NT_REP_GROUP)) {
                return this.createGroup(n);
            }
            log.debug("Unexpected user nodetype " + n.getPrimaryNodeType().getName());
        }
        return null;
    }

    public Iterator findAuthorizables(String propertyName, String value) throws RepositoryException {
        return this.findAuthorizables(propertyName, value, 3);
    }

    public Iterator findAuthorizables(String propertyName, String value, int searchType) throws RepositoryException {
        Name ntName;
        Name name = this.session.getQName(propertyName);
        switch (searchType) {
            case 3: {
                ntName = NT_REP_AUTHORIZABLE;
                break;
            }
            case 2: {
                ntName = NT_REP_GROUP;
                break;
            }
            case 1: {
                ntName = NT_REP_USER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid search type " + searchType);
            }
        }
        NodeIterator nodes = this.authResolver.findNodes(name, value, ntName, true);
        return new AuthorizableIterator(nodes);
    }

    public User createUser(String userID, String password) throws RepositoryException {
        return this.createUser(userID, password, new PrincipalImpl(userID), null);
    }

    public User createUser(String userID, String password, Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        if (userID == null || userID.length() == 0) {
            throw new IllegalArgumentException("Cannot create user: UserID can neither be null nor empty String.");
        }
        if (password == null) {
            throw new IllegalArgumentException("Cannot create user: null password.");
        }
        if (!UserManagerImpl.isValidPrincipal(principal)) {
            throw new IllegalArgumentException("Cannot create user: Principal may not be null and must have a valid name.");
        }
        if (this.getAuthorizable(userID) != null) {
            throw new AuthorizableExistsException("User for '" + userID + "' already exists");
        }
        if (this.hasAuthorizableOrReferee(principal)) {
            throw new AuthorizableExistsException("Authorizable for '" + principal.getName() + "' already exists");
        }
        if (intermediatePath != null) {
            log.debug("Intermediate path param " + intermediatePath + " is ignored.");
        }
        Object parent = null;
        try {
            NodeImpl userNode = (NodeImpl)this.idResolver.createUserNode(userID);
            this.setProperty(userNode, P_USERID, this.getValue(userID), true);
            this.setProperty(userNode, P_PASSWORD, this.getValue(UserImpl.buildPasswordValue(password)), true);
            this.setProperty(userNode, P_PRINCIPAL_NAME, this.getValue(principal.getName()), true);
            this.session.save();
            log.debug("User created: " + userID + "; " + userNode.getPath());
            return this.createUser(userNode);
        }
        catch (RepositoryException e) {
            this.session.refresh(false);
            log.debug("Failed to create new User, reverting changes.");
            throw e;
        }
    }

    public Group createGroup(Principal principal) throws RepositoryException {
        return this.createGroup(principal, null);
    }

    public Group createGroup(Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        if (!UserManagerImpl.isValidPrincipal(principal)) {
            throw new IllegalArgumentException("Cannot create Group: Principal may not be null and must have a valid name.");
        }
        if (this.hasAuthorizableOrReferee(principal)) {
            throw new AuthorizableExistsException("Authorizable for '" + principal.getName() + "' already exists: ");
        }
        if (intermediatePath != null) {
            log.debug("Intermediate path param " + intermediatePath + " is ignored.");
        }
        Object parent = null;
        try {
            String groupID = this.getGroupId(principal.getName());
            NodeImpl groupNode = (NodeImpl)this.idResolver.createGroupNode(groupID);
            this.setProperty(groupNode, P_PRINCIPAL_NAME, this.getValue(principal.getName()));
            this.session.save();
            log.debug("Group created: " + groupID + "; " + groupNode.getPath());
            return this.createGroup(groupNode);
        }
        catch (RepositoryException e) {
            this.session.refresh(false);
            log.debug("newInstance new Group failed, revert changes on parent");
            throw e;
        }
    }

    boolean hasAuthorizableOrReferee(Principal principal) throws RepositoryException {
        HashSet<Name> s = new HashSet<Name>(2);
        s.add(P_PRINCIPAL_NAME);
        s.add(P_REFEREES);
        NodeIterator res = this.authResolver.findNodes(s, principal.getName(), NT_REP_AUTHORIZABLE, true, 1L);
        return res.hasNext();
    }

    void setProtectedProperty(NodeImpl node, Name propName, Value value) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        this.setProperty(node, propName, value);
        node.save();
    }

    void setProtectedProperty(NodeImpl node, Name propName, Value[] values) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        this.setProperty(node, propName, values);
        node.save();
    }

    void setProtectedProperty(NodeImpl node, Name propName, Value[] values, int type) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        this.setProperty(node, propName, values, type);
        node.save();
    }

    void removeProtectedItem(ItemImpl item, Node parent) throws RepositoryException, AccessDeniedException, VersionException {
        this.removeItem(item);
        parent.save();
    }

    private String getGroupId(String principalName) throws RepositoryException {
        String escHint;
        String groupID = escHint = principalName;
        int i = 0;
        while (this.getAuthorizable(groupID) != null) {
            groupID = escHint + "_" + i;
            ++i;
        }
        return groupID;
    }

    private Value getValue(String strValue) throws RepositoryException {
        return this.session.getValueFactory().createValue(strValue);
    }

    boolean isAdminId(String userID) {
        return this.adminId != null && this.adminId.equals(userID);
    }

    User createUser(NodeImpl userNode) throws RepositoryException {
        if (userNode == null || !userNode.isNodeType(NT_REP_USER)) {
            throw new IllegalArgumentException();
        }
        if (!Text.isDescendant("/rep:security/rep:authorizables/rep:users", userNode.getPath())) {
            throw new IllegalArgumentException("User has to be within the User Path");
        }
        User user = this.doCreateUser(userNode);
        return user;
    }

    protected User doCreateUser(NodeImpl node) throws RepositoryException {
        return new UserImpl(node, this);
    }

    Group createGroup(NodeImpl groupNode) throws RepositoryException {
        Group group = GroupImpl.create(groupNode, this);
        return group;
    }

    private NodeImpl getUserNode(String userID) throws RepositoryException {
        NodeImpl n = (NodeImpl)this.idResolver.findNode(userID, false);
        if (n == null && this.compatibleJR16) {
            n = (NodeImpl)this.authResolver.findNode(P_USERID, userID, NT_REP_USER);
        }
        return n;
    }

    private NodeImpl getGroupNode(String groupID) throws RepositoryException {
        NodeImpl n = (NodeImpl)this.idResolver.findNode(groupID, true);
        if (n == null && this.compatibleJR16) {
            Name nodeName = this.session.getQName(Text.escapeIllegalJcrChars(groupID));
            n = (NodeImpl)this.authResolver.findNode(nodeName, NT_REP_GROUP);
        }
        return n;
    }

    private static boolean isValidPrincipal(Principal principal) {
        return principal != null && principal.getName() != null && principal.getName().length() > 0;
    }

    public void loggingOut(SessionImpl session) {
    }

    public void loggedOut(SessionImpl session) {
        if (session != this.session) {
            this.session.logout();
        }
    }

    private class IdResolver {
        private static final String DELIMITER = "/";
        private static final int DEFAULT_DEPTH = 2;
        private static final long DEFAULT_SIZE = 1000L;
        private final int defaultDepth;
        private final boolean autoExpandTree;
        private final long autoExpandSize;

        private IdResolver(Properties config) {
            int d = 2;
            boolean expand = false;
            long size = 1000L;
            if (config != null) {
                if (config.containsKey(UserManagerImpl.PARAM_DEFAULT_DEPTH)) {
                    try {
                        d = Integer.parseInt(config.get(UserManagerImpl.PARAM_DEFAULT_DEPTH).toString());
                        if (d <= 0) {
                            log.warn("Invalid defaultDepth '" + d + "' -> using default.");
                            d = 2;
                        }
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to parse defaultDepth config parameter -> using default.", e);
                    }
                }
                if (config.containsKey(UserManagerImpl.PARAM_AUTO_EXPAND_TREE)) {
                    expand = Boolean.parseBoolean(config.get(UserManagerImpl.PARAM_AUTO_EXPAND_TREE).toString());
                }
                if (config.containsKey(UserManagerImpl.PARAM_AUTO_EXPAND_SIZE)) {
                    try {
                        size = Integer.parseInt(config.get(UserManagerImpl.PARAM_AUTO_EXPAND_SIZE).toString());
                        if (expand && size <= 0L) {
                            log.warn("Invalid autoExpandSize '" + size + "' -> using default.");
                            size = 1000L;
                        }
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to parse autoExpandSize config parameter -> using default.", e);
                    }
                }
            }
            this.defaultDepth = d;
            this.autoExpandTree = expand;
            this.autoExpandSize = size;
        }

        public Node createUserNode(String userID) throws RepositoryException {
            return this.createAuthorizableNode(userID, false);
        }

        public Node createGroupNode(String groupID) throws RepositoryException {
            return this.createAuthorizableNode(groupID, true);
        }

        public Node findNode(String id, boolean isGroup) throws RepositoryException {
            String defaultFolderPath = this.getDefaultFolderPath(id, isGroup);
            String escapedId = Text.escapeIllegalJcrChars(id);
            if (UserManagerImpl.this.session.nodeExists(defaultFolderPath)) {
                Node folder = UserManagerImpl.this.session.getNode(defaultFolderPath);
                Name expectedNt = isGroup ? UserConstants.NT_REP_GROUP : UserConstants.NT_REP_USER;
                int segmLength = this.defaultDepth + 1;
                while (folder != null) {
                    if (folder.hasNode(escapedId)) {
                        NodeImpl aNode = (NodeImpl)folder.getNode(escapedId);
                        if (aNode.isNodeType(expectedNt)) {
                            return aNode;
                        }
                        folder = aNode;
                    } else {
                        NodeImpl f;
                        String folderName;
                        Node parent = folder;
                        folder = null;
                        if (id.length() >= segmLength && parent.hasNode(folderName = Text.escapeIllegalJcrChars(id.substring(0, segmLength))) && (f = (NodeImpl)parent.getNode(folderName)).isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) {
                            folder = f;
                        }
                    }
                    ++segmLength;
                }
            }
            return null;
        }

        private Node createAuthorizableNode(String id, boolean isGroup) throws RepositoryException {
            String escapedId = Text.escapeIllegalJcrChars(id);
            Node folder = this.createDefaultFolderNodes(id, escapedId, isGroup);
            folder = this.createIntermediateFolderNodes(id, escapedId, folder);
            Name nodeName = UserManagerImpl.this.session.getQName(escapedId);
            Name ntName = isGroup ? UserConstants.NT_REP_GROUP : UserConstants.NT_REP_USER;
            NodeImpl authNode = UserManagerImpl.this.addNode((NodeImpl)folder, nodeName, ntName);
            return authNode;
        }

        private Node createDefaultFolderNodes(String id, String escapedId, boolean isGroup) throws RepositoryException {
            NodeImpl folder;
            String defaultPath = this.getDefaultFolderPath(id, isGroup);
            if (UserManagerImpl.this.session.nodeExists(defaultPath)) {
                folder = (NodeImpl)UserManagerImpl.this.session.getNode(defaultPath);
            } else {
                String[] segmts = defaultPath.split(DELIMITER);
                folder = (NodeImpl)UserManagerImpl.this.session.getRootNode();
                String repSecurity = "/rep:security".substring(1);
                for (String segment : segmts) {
                    NodeImpl added;
                    if (segment.length() < 1) continue;
                    if (folder.hasNode(segment)) {
                        folder = (NodeImpl)folder.getNode(segment);
                        continue;
                    }
                    Name ntName = repSecurity.equals(segment) ? NameConstants.NT_UNSTRUCTURED : UserConstants.NT_REP_AUTHORIZABLE_FOLDER;
                    folder = added = UserManagerImpl.this.addNode(folder, UserManagerImpl.this.session.getQName(segment), ntName);
                }
            }
            this.checkAuthorizableNodeExists(escapedId, folder);
            return folder;
        }

        private String getDefaultFolderPath(String id, boolean isGroup) {
            StringBuilder bld = new StringBuilder();
            if (isGroup) {
                bld.append("/rep:security/rep:authorizables/rep:groups");
            } else {
                bld.append("/rep:security/rep:authorizables/rep:users");
            }
            StringBuilder lastSegment = new StringBuilder(this.defaultDepth);
            int idLength = id.length();
            for (int i = 0; i < this.defaultDepth; ++i) {
                if (idLength > i) {
                    lastSegment.append(id.charAt(i));
                } else {
                    lastSegment.append(id.charAt(idLength - 1));
                }
                bld.append(DELIMITER).append(Text.escapeIllegalJcrChars(lastSegment.toString()));
            }
            return bld.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        private Node createIntermediateFolderNodes(String id, String escapedId, Node folder) throws RepositoryException {
            if (!this.autoExpandTree) {
                return folder;
            }
            int segmLength = this.defaultDepth + 1;
            int idLength = id.length();
            while (this.intermediateFolderNeeded(escapedId, folder)) {
                block6: {
                    String folderName = Text.escapeIllegalJcrChars(id.substring(0, segmLength));
                    if (folder.hasNode(folderName)) {
                        NodeImpl n = (NodeImpl)folder.getNode(folderName);
                        if (n.isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) {
                            folder = n;
                            break block6;
                        } else {
                            if (!n.isNodeType(UserConstants.NT_REP_AUTHORIZABLE)) {
                                String msg = "Failed to create authorizable node: Detected conflict with node of unexpected nodetype '" + n.getPrimaryNodeType().getName() + "'.";
                                log.error(msg);
                                throw new RepositoryException(msg);
                            }
                            log.warn("Auto-expanding aborted. An existing authorizable node '" + n.getName() + "'conflicts with intermediate folder to be created.");
                            break;
                        }
                    }
                    folder = UserManagerImpl.this.addNode((NodeImpl)folder, UserManagerImpl.this.session.getQName(folderName), UserConstants.NT_REP_AUTHORIZABLE_FOLDER);
                }
                ++segmLength;
            }
            this.checkAuthorizableNodeExists(escapedId, folder);
            return folder;
        }

        private void checkAuthorizableNodeExists(String nodeName, Node folder) throws AuthorizableExistsException, RepositoryException {
            if (folder.hasNode(nodeName) && ((NodeImpl)folder.getNode(nodeName)).isNodeType(UserConstants.NT_REP_AUTHORIZABLE)) {
                throw new AuthorizableExistsException("Unable to create Group/User: Collision with existing authorizable.");
            }
        }

        private boolean intermediateFolderNeeded(String nodeName, Node folder) throws RepositoryException {
            if (nodeName.length() <= folder.getName().length()) {
                return false;
            }
            if (nodeName.length() == folder.getName().length() + 1) {
                return true;
            }
            return folder.getNodes().getSize() >= this.autoExpandSize;
        }
    }

    private final class AuthorizableIterator
    implements Iterator {
        private final Set<String> served = new HashSet<String>();
        private Authorizable next;
        private NodeIterator authNodeIter;

        private AuthorizableIterator(NodeIterator authNodeIter) {
            this.authNodeIter = authNodeIter;
            this.next = this.seekNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Authorizable authr = this.next;
            if (authr == null) {
                throw new NoSuchElementException();
            }
            this.next = this.seekNext();
            return authr;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Authorizable seekNext() {
            while (this.authNodeIter.hasNext()) {
                NodeImpl node = (NodeImpl)this.authNodeIter.nextNode();
                try {
                    Authorizable authr;
                    if (this.served.contains(node.getUUID())) continue;
                    if (node.isNodeType(UserConstants.NT_REP_USER)) {
                        authr = UserManagerImpl.this.createUser(node);
                    } else if (node.isNodeType(UserConstants.NT_REP_GROUP)) {
                        authr = UserManagerImpl.this.createGroup(node);
                    } else {
                        log.warn("Ignoring unexpected nodetype: " + node.getPrimaryNodeType().getName());
                        continue;
                    }
                    this.served.add(node.getUUID());
                    return authr;
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            return null;
        }
    }
}

