/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.NamedAccessControlPolicyImpl;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAccessControlProvider
extends AbstractAccessControlProvider
implements UserConstants {
    private static Logger log = LoggerFactory.getLogger(UserAccessControlProvider.class);
    private final AccessControlPolicy policy = new NamedAccessControlPolicyImpl("userPolicy");
    private Path groupsPath;
    private Path usersPath;
    private String userAdminGroup;
    private String groupAdminGroup;

    @Override
    public boolean isAcItem(Path absPath) throws RepositoryException {
        return false;
    }

    @Override
    public boolean isAcItem(ItemImpl item) throws RepositoryException {
        return false;
    }

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        SessionImpl sImpl;
        super.init(systemSession, configuration);
        if (systemSession instanceof SessionImpl) {
            sImpl = (SessionImpl)systemSession;
            this.userAdminGroup = configuration.containsKey("UserAdmin") ? configuration.get("UserAdmin").toString() : "UserAdmin";
            this.groupAdminGroup = configuration.containsKey("GroupAdmin") ? configuration.get("GroupAdmin").toString() : "GroupAdmin";
            UserManager uMgr = sImpl.getUserManager();
            if (!UserAccessControlProvider.initGroup(uMgr, this.userAdminGroup)) {
                log.warn("Unable to initialize User admininistrator group -> no user admins.");
                this.userAdminGroup = null;
            }
            if (!UserAccessControlProvider.initGroup(uMgr, this.groupAdminGroup)) {
                log.warn("Unable to initialize Group admininistrator group -> no group admins.");
                this.groupAdminGroup = null;
            }
        } else {
            throw new RepositoryException("SessionImpl (system session) expected.");
        }
        this.usersPath = sImpl.getQPath("/rep:security/rep:authorizables/rep:users");
        this.groupsPath = sImpl.getQPath("/rep:security/rep:authorizables/rep:groups");
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Path absPath) throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        return new AccessControlPolicy[]{this.policy};
    }

    @Override
    public AccessControlEditor getEditor(Session session) {
        this.checkInitialized();
        return null;
    }

    @Override
    public CompiledPermissions compilePermissions(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return this.getAdminPermissions();
        }
        ItemBasedPrincipal userPrincipal = this.getUserPrincipal(principals);
        NodeImpl userNode = this.getUserNode(userPrincipal);
        if (userNode == null) {
            return this.getReadOnlyPermissions();
        }
        return new CompiledPermissionsImpl(principals, userNode.getPath());
    }

    public boolean canAccessRoot(Set principals) throws RepositoryException {
        this.checkInitialized();
        return true;
    }

    private ItemBasedPrincipal getUserPrincipal(Set<Principal> principals) {
        try {
            UserManager uMgr = this.session.getUserManager();
            for (Principal p : principals) {
                if (p instanceof Group || !(p instanceof ItemBasedPrincipal) || uMgr.getAuthorizable(p) == null) continue;
                return (ItemBasedPrincipal)p;
            }
        }
        catch (RepositoryException e) {
            log.error("Internal error while retrieving user principal", (Object)e.getMessage());
        }
        return null;
    }

    private NodeImpl getUserNode(ItemBasedPrincipal principal) {
        NodeImpl userNode = null;
        if (principal != null) {
            try {
                String path = principal.getPath();
                userNode = (NodeImpl)this.session.getNode(path);
            }
            catch (RepositoryException e) {
                log.warn("Error while retrieving user node.", (Object)e.getMessage());
            }
        }
        return userNode;
    }

    private Node getExistingNode(Path path) throws RepositoryException {
        String absPath = this.resolver.getJCRPath(path.getNormalizedPath());
        if (this.session.nodeExists(absPath)) {
            return this.session.getNode(absPath);
        }
        if (this.session.propertyExists(absPath)) {
            return this.session.getProperty(absPath).getParent();
        }
        String pPath = Text.getRelativeParent(absPath, 1);
        if (this.session.nodeExists(pPath)) {
            return this.session.getNode(pPath);
        }
        throw new ItemNotFoundException("Unable to determine permissions: No item and no existing parent for target path " + absPath);
    }

    private int getPrivilegeBits(String privName) throws RepositoryException {
        Privilege[] privs = new Privilege[]{this.session.getAccessControlManager().privilegeFromName(privName)};
        return PrivilegeRegistry.getBits(privs);
    }

    private static boolean containsGroup(Set<Principal> principals, String groupName) {
        Iterator<Principal> it = principals.iterator();
        while (it.hasNext() && groupName != null) {
            Principal p = it.next();
            if (!p.getName().equals(groupName)) continue;
            return true;
        }
        return false;
    }

    private static boolean initGroup(UserManager uMgr, String principalName) {
        boolean success;
        PrincipalImpl prnc = new PrincipalImpl(principalName);
        try {
            Authorizable auth = uMgr.getAuthorizable(prnc);
            if (auth == null) {
                success = uMgr.createGroup(prnc) != null;
            } else {
                success = auth.isGroup();
                if (!success) {
                    log.warn("Cannot create group '" + principalName + "'; User with that principal already exists.");
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Error while initializing user/group administrators", (Object)e.getMessage());
            success = false;
        }
        return success;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompiledPermissionsImpl
    extends AbstractCompiledPermissions
    implements SynchronousEventListener {
        private final String userNodePath;
        private boolean isUserAdmin;
        private boolean isGroupAdmin;

        protected CompiledPermissionsImpl(Set<Principal> principals, String userNodePath) throws RepositoryException {
            this.userNodePath = userNodePath;
            this.isUserAdmin = UserAccessControlProvider.containsGroup(principals, UserAccessControlProvider.this.userAdminGroup);
            this.isGroupAdmin = UserAccessControlProvider.containsGroup(principals, UserAccessControlProvider.this.groupAdminGroup);
            int events = 28;
            UserAccessControlProvider.this.observationMgr.addEventListener(this, events, "/rep:security/rep:authorizables/rep:users", true, null, null, false);
        }

        @Override
        protected AbstractCompiledPermissions.Result buildResult(Path path) throws RepositoryException {
            Path abs2Path;
            NodeImpl userNode = null;
            try {
                if (UserAccessControlProvider.this.session.nodeExists(this.userNodePath)) {
                    userNode = (NodeImpl)UserAccessControlProvider.this.session.getNode(this.userNodePath);
                }
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            if (userNode == null) {
                log.debug("No node at " + this.userNodePath);
                return new AbstractCompiledPermissions.Result(0, 0, 0, 0);
            }
            int denies = 0;
            int allows = 1;
            boolean calcPrivs = UserAccessControlProvider.this.session.nodeExists(UserAccessControlProvider.this.resolver.getJCRPath(path.getNormalizedPath()));
            int privs = calcPrivs ? UserAccessControlProvider.this.getPrivilegeBits("{http://www.jcp.org/jcr/1.0}read") : 0;
            Path path2 = abs2Path = 4 > path.getLength() ? null : path.subPath(0, 4);
            if (UserAccessControlProvider.this.usersPath.equals(abs2Path)) {
                NodeImpl node = (NodeImpl)UserAccessControlProvider.this.getExistingNode(path);
                if (node.isNodeType(UserConstants.NT_REP_AUTHORIZABLE) || node.isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) {
                    boolean editingHimSelf = node.isSame(userNode);
                    boolean isGroupProp = UserConstants.P_GROUPS.equals(path.getNameElement().getName());
                    boolean memberOfRequiredGroups = this.isUserAdmin;
                    if (memberOfRequiredGroups && isGroupProp) {
                        memberOfRequiredGroups = this.isGroupAdmin;
                    }
                    if (editingHimSelf) {
                        Path aPath = UserAccessControlProvider.this.session.getQPath(node.getPath());
                        if (memberOfRequiredGroups) {
                            allows = path.equals(aPath) ? (allows |= 0x16) : (allows |= 0xFFF);
                            if (calcPrivs) {
                                privs |= UserAccessControlProvider.this.getPrivilegeBits("{internal}write");
                                if (!path.equals(aPath)) {
                                    privs |= UserAccessControlProvider.this.getPrivilegeBits("{http://www.jcp.org/jcr/1.0}removeNode");
                                }
                            }
                        } else if (userNode.isSame(node) && (!isGroupProp || this.isGroupAdmin)) {
                            allows |= 0x12;
                            if (calcPrivs) {
                                privs |= UserAccessControlProvider.this.getPrivilegeBits("{http://www.jcp.org/jcr/1.0}modifyProperties");
                            }
                        }
                    } else if (memberOfRequiredGroups) {
                        allows = 4095;
                        if (calcPrivs) {
                            privs |= UserAccessControlProvider.this.getPrivilegeBits("{internal}write");
                        }
                    }
                }
            } else if (UserAccessControlProvider.this.groupsPath.equals(abs2Path) && this.isGroupAdmin) {
                allows = 4095;
                if (calcPrivs) {
                    privs |= UserAccessControlProvider.this.getPrivilegeBits("{internal}write");
                }
            }
            return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
        }

        @Override
        public void close() {
            try {
                UserAccessControlProvider.this.observationMgr.removeEventListener(this);
            }
            catch (RepositoryException e) {
                log.error("Internal error: ", (Object)e.getMessage());
            }
            super.close();
        }

        @Override
        public boolean grants(Path absPath, int permissions) throws RepositoryException {
            if (permissions == 1) {
                return true;
            }
            return super.grants(absPath, permissions);
        }

        @Override
        public boolean canReadAll() throws RepositoryException {
            return true;
        }

        @Override
        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                Event ev = events.nextEvent();
                try {
                    String evPath = ev.getPath();
                    String repGroups = UserAccessControlProvider.this.session.getJCRName(UserConstants.P_GROUPS);
                    if (!repGroups.equals(Text.getName(evPath)) || !this.userNodePath.equals(Text.getRelativeParent(evPath, 1))) continue;
                    switch (ev.getType()) {
                        case 8: {
                            this.isUserAdmin = false;
                            this.isGroupAdmin = false;
                            break;
                        }
                        case 4: 
                        case 16: {
                            if (!UserAccessControlProvider.this.session.propertyExists(evPath)) break;
                            Value[] vs = UserAccessControlProvider.this.session.getProperty(evPath).getValues();
                            String princName = UserAccessControlProvider.this.session.getJCRName(UserConstants.P_PRINCIPAL_NAME);
                            for (Value v : vs) {
                                Node groupNode = UserAccessControlProvider.this.session.getNodeByUUID(v.getString());
                                String pName = groupNode.getProperty(princName).getString();
                                if (UserAccessControlProvider.this.userAdminGroup.equals(pName)) {
                                    this.isUserAdmin = true;
                                    continue;
                                }
                                if (!UserAccessControlProvider.this.groupAdminGroup.equals(pName)) continue;
                                this.isGroupAdmin = true;
                            }
                            break;
                        }
                    }
                    this.clearCache();
                    break;
                }
                catch (RepositoryException e) {
                    log.error("Internal error ", (Object)e.getMessage());
                }
            }
        }
    }
}

