/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.principal;

import java.security.Principal;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.principal.AbstractPrincipalIterator;
import org.apache.jackrabbit.core.security.principal.AbstractPrincipalProvider;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPrincipalProvider
extends AbstractPrincipalProvider
implements EventListener {
    private static Logger log = LoggerFactory.getLogger(DefaultPrincipalProvider.class);
    private final Map<String, Set<Principal>> membershipCache;
    private final UserManagerImpl userManager;
    private final EveryonePrincipal everyonePrincipal;
    private final String pGroupName;
    private final String pPrincipalName;

    public DefaultPrincipalProvider(Session securitySession, UserManagerImpl userManager) throws RepositoryException {
        this.userManager = userManager;
        this.everyonePrincipal = EveryonePrincipal.getInstance();
        this.membershipCache = new LRUMap();
        String[] ntNames = new String[1];
        if (securitySession instanceof SessionImpl) {
            SessionImpl resolver = (SessionImpl)securitySession;
            ntNames[0] = resolver.getJCRName(UserManagerImpl.NT_REP_USER);
            this.pGroupName = resolver.getJCRName(UserManagerImpl.P_GROUPS);
            this.pPrincipalName = resolver.getJCRName(UserManagerImpl.P_PRINCIPAL_NAME);
        } else {
            ntNames[0] = "rep:User";
            this.pGroupName = "rep:groups";
            this.pPrincipalName = "rep:principalName";
        }
        securitySession.getWorkspace().getObservationManager().addEventListener(this, 30, "/rep:security", true, null, ntNames, false);
    }

    @Override
    protected Principal providePrincipal(String principalName) {
        if (this.everyonePrincipal.getName().equals(principalName)) {
            return this.everyonePrincipal;
        }
        try {
            PrincipalImpl principal = new PrincipalImpl(principalName);
            Authorizable ath = this.userManager.getAuthorizable(principal);
            if (ath != null) {
                return ath.getPrincipal();
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to access Authorizable for Principal " + principalName, e);
        }
        return null;
    }

    @Override
    public PrincipalIterator findPrincipals(String simpleFilter) {
        return this.findPrincipals(simpleFilter, 3);
    }

    @Override
    public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
        this.checkInitialized();
        switch (searchType) {
            case 2: {
                return this.findGroupPrincipals(simpleFilter);
            }
            case 1: {
                return this.findUserPrincipals(simpleFilter);
            }
            case 3: {
                Iterator[] its = new PrincipalIterator[]{this.findUserPrincipals(simpleFilter), this.findGroupPrincipals(simpleFilter)};
                return new PrincipalIteratorAdapter(new IteratorChain(its));
            }
        }
        throw new IllegalArgumentException("Invalid searchType");
    }

    @Override
    public PrincipalIterator getPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalIterator getGroupMembership(Principal userPrincipal) {
        Set<Principal> mship;
        this.checkInitialized();
        Map<String, Set<Principal>> map = this.membershipCache;
        synchronized (map) {
            mship = this.membershipCache.get(userPrincipal.getName());
            if (mship == null) {
                mship = this.collectGroupMembership(userPrincipal);
                if (!mship.contains(this.everyonePrincipal) && this.everyonePrincipal.isMember(userPrincipal)) {
                    mship.add((Principal)((Object)this.everyonePrincipal));
                }
                this.membershipCache.put(userPrincipal.getName(), mship);
            }
        }
        return new PrincipalIteratorAdapter(mship);
    }

    @Override
    public synchronized void close() {
        super.close();
        this.membershipCache.clear();
    }

    @Override
    public boolean canReadPrincipal(Session session, Principal principal) {
        this.checkInitialized();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(EventIterator eventIterator) {
        this.clearCache();
        while (eventIterator.hasNext()) {
            Event ev = eventIterator.nextEvent();
            int type = ev.getType();
            if (type != 4 && type != 16 && type != 8) continue;
            try {
                if (!this.pGroupName.equals(Text.getName(ev.getPath()))) continue;
                Map<String, Set<Principal>> map = this.membershipCache;
                synchronized (map) {
                    this.membershipCache.clear();
                    break;
                }
            }
            catch (RepositoryException e) {
                log.warn(e.getMessage());
            }
        }
    }

    private Set<Principal> collectGroupMembership(Principal princ) {
        LinkedHashSet<Principal> membership = new LinkedHashSet<Principal>();
        try {
            Authorizable auth = this.userManager.getAuthorizable(princ);
            if (auth != null) {
                this.addToCache(princ);
                Iterator<Group> itr = auth.memberOf();
                while (itr.hasNext()) {
                    Group group = itr.next();
                    Principal gp = group.getPrincipal();
                    this.addToCache(gp);
                    membership.add(gp);
                }
            } else {
                log.debug("Cannot find authorizable for principal " + princ.getName());
            }
        }
        catch (RepositoryException e) {
            log.warn("Failed to determine membership for " + princ.getName(), (Object)e.getMessage());
        }
        return membership;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrincipalIterator findUserPrincipals(String simpleFilter) {
        UserManagerImpl userManagerImpl = this.userManager;
        synchronized (userManagerImpl) {
            try {
                Iterator itr = this.userManager.findAuthorizables(this.pPrincipalName, simpleFilter, 1);
                return new PrincipalIteratorImpl(itr, false);
            }
            catch (RepositoryException e) {
                log.error("Error while searching user principals.", e);
                return PrincipalIteratorAdapter.EMPTY;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrincipalIterator findGroupPrincipals(String simpleFilter) {
        UserManagerImpl userManagerImpl = this.userManager;
        synchronized (userManagerImpl) {
            try {
                Iterator itr = this.userManager.findAuthorizables(this.pPrincipalName, simpleFilter, 2);
                boolean addEveryone = this.everyonePrincipal.getName().matches(".*" + simpleFilter + ".*");
                return new PrincipalIteratorImpl(itr, addEveryone);
            }
            catch (RepositoryException e) {
                log.error("Error while searching group principals.", e);
                return PrincipalIteratorAdapter.EMPTY;
            }
        }
    }

    private class PrincipalIteratorImpl
    extends AbstractPrincipalIterator {
        private final Iterator authorizableItr;
        private boolean addEveryone;

        private PrincipalIteratorImpl(Iterator authorizableItr, boolean addEveryone) {
            this.authorizableItr = authorizableItr;
            this.addEveryone = addEveryone;
            this.next = this.seekNext();
        }

        protected Principal seekNext() {
            while (this.authorizableItr.hasNext()) {
                try {
                    Principal p = ((Authorizable)this.authorizableItr.next()).getPrincipal();
                    DefaultPrincipalProvider.this.addToCache(p);
                    return p;
                }
                catch (RepositoryException e) {
                    log.warn("Error while retrieving principal from group -> skip.");
                }
            }
            if (this.addEveryone) {
                this.addEveryone = false;
                return DefaultPrincipalProvider.this.everyonePrincipal;
            }
            return null;
        }
    }
}

