/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryIterator;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.UnmodifiableAccessControlList;
import org.apache.jackrabbit.core.security.authorization.acl.ACLEditor;
import org.apache.jackrabbit.core.security.authorization.acl.ACLTemplate;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLProvider
extends AbstractAccessControlProvider
implements AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(ACLProvider.class);
    private ACLEditor systemEditor;
    private NodeId rootNodeId;
    private boolean initializedWithDefaults;

    @Override
    public boolean isAcItem(Path absPath) throws RepositoryException {
        Path.Element[] elems;
        for (Path.Element elem : elems = absPath.getElements()) {
            if (!N_POLICY.equals(elem.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcItem(ItemImpl item) throws RepositoryException {
        NodeImpl n = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        return n.isNodeType(NT_REP_ACL) || n.isNodeType(NT_REP_ACE);
    }

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        super.init(systemSession, configuration);
        NodeImpl root = (NodeImpl)this.session.getRootNode();
        this.rootNodeId = root.getNodeId();
        this.systemEditor = new ACLEditor(systemSession, this);
        boolean bl = this.initializedWithDefaults = !configuration.containsKey("omit-default-permission");
        if (this.initializedWithDefaults && !ACLProvider.isAccessControlled(root)) {
            ACLProvider.initRootACL(this.session, this.systemEditor);
        }
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Path absPath) throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        NodeImpl targetNode = (NodeImpl)this.session.getNode(this.session.getJCRPath(absPath));
        NodeImpl node = this.getNode(targetNode);
        ArrayList<AccessControlList> acls = new ArrayList<AccessControlList>();
        this.collectAcls(node, acls);
        if (acls.isEmpty()) {
            log.warn("No access controlled node present in item hierarchy starting from " + targetNode.getPath());
        }
        return acls.toArray(new AccessControlList[acls.size()]);
    }

    @Override
    public AccessControlEditor getEditor(Session session) {
        this.checkInitialized();
        return new ACLEditor(session, this);
    }

    @Override
    public CompiledPermissions compilePermissions(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return this.getAdminPermissions();
        }
        if (this.isReadOnly(principals)) {
            return this.getReadOnlyPermissions();
        }
        return new AclPermissions(principals);
    }

    @Override
    public boolean canAccessRoot(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return true;
        }
        AclPermissions cp = new AclPermissions(principals, false);
        return cp.grants(PathFactoryImpl.getInstance().getRootPath(), 1);
    }

    private NodeImpl getNode(NodeImpl targetNode) throws RepositoryException {
        NodeImpl node = this.isAcItem(targetNode) ? (targetNode.isNodeType(NT_REP_ACL) ? (NodeImpl)targetNode.getParent() : (NodeImpl)targetNode.getParent().getParent()) : targetNode;
        return node;
    }

    private void collectAcls(NodeImpl node, List<AccessControlList> acls) throws RepositoryException {
        if (ACLProvider.isAccessControlled(node)) {
            NodeImpl aclNode = node.getNode(N_POLICY);
            AccessControlList acl = this.systemEditor.getACL(aclNode);
            acls.add(new UnmodifiableAccessControlList(acl));
        }
        if (!this.rootNodeId.equals(node.getId())) {
            NodeImpl parentNode = (NodeImpl)node.getParent();
            this.collectAcls(parentNode, acls);
        }
    }

    private static void initRootACL(SessionImpl session, AccessControlEditor editor) throws RepositoryException {
        try {
            log.debug("Install initial ACL:...");
            String rootPath = session.getRootNode().getPath();
            AccessControlPolicy[] acls = editor.editAccessControlPolicies(rootPath);
            if (acls.length > 0) {
                Principal administrators;
                ACLTemplate acl = (ACLTemplate)acls[0];
                PrincipalManager pMgr = session.getPrincipalManager();
                AccessControlManager acMgr = session.getAccessControlManager();
                log.debug("... Privilege.ALL for administrators.");
                String pName = "administrators";
                if (pMgr.hasPrincipal(pName)) {
                    administrators = pMgr.getPrincipal(pName);
                } else {
                    log.warn("Administrators principal group is missing.");
                    administrators = new PrincipalImpl(pName);
                }
                Privilege[] privs = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")};
                acl.addAccessControlEntry(administrators, privs);
                Principal everyone = pMgr.getEveryone();
                log.debug("... Privilege.READ for everyone.");
                privs = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")};
                acl.addAccessControlEntry(everyone, privs);
                editor.setPolicy(rootPath, acl);
                session.save();
            } else {
                log.warn("No applicable ACL available for the root node -> skip initialization of the root node's ACL.");
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to set-up minimal access control for root node of workspace " + session.getWorkspace().getName());
            session.getRootNode().refresh(false);
        }
    }

    static boolean isAccessControlled(NodeImpl node) throws RepositoryException {
        return node.isNodeType(NT_REP_ACCESS_CONTROLLABLE) && node.hasNode(N_POLICY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entries {
        private final Map<String, List<AccessControlEntry>> principalNamesToEntries = new LinkedHashMap<String, List<AccessControlEntry>>();

        private Entries(NodeImpl node, Collection<String> principalNames) throws RepositoryException {
            for (String name : principalNames) {
                this.principalNamesToEntries.put(name, new ArrayList());
            }
            this.collectEntries(node);
        }

        private void collectEntries(NodeImpl node) throws RepositoryException {
            if (ACLProvider.isAccessControlled(node)) {
                NodeImpl aclNode = node.getNode(AccessControlConstants.N_POLICY);
                ACLTemplate.collectEntries(aclNode, this.principalNamesToEntries);
            }
            if (!ACLProvider.this.rootNodeId.equals(node.getId())) {
                NodeImpl parentNode = (NodeImpl)node.getParent();
                this.collectEntries(parentNode);
            }
        }

        private AccessControlEntryIterator iterator() {
            ArrayList<AccessControlEntry> entries = new ArrayList<AccessControlEntry>();
            for (List<AccessControlEntry> list : this.principalNamesToEntries.values()) {
                entries.addAll(list);
            }
            return new AccessControlEntryIterator(entries);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AclPermissions
    extends AbstractCompiledPermissions
    implements SynchronousEventListener {
        private final List<String> principalNames;
        private final String jcrReadPrivilegeName;
        private boolean readAllowed;

        private AclPermissions(Set<Principal> principals) throws RepositoryException {
            this(principals, true);
        }

        private AclPermissions(Set<Principal> principals, boolean listenToEvents) throws RepositoryException {
            this.principalNames = new ArrayList<String>(principals.size());
            for (Principal princ : principals) {
                this.principalNames.add(princ.getName());
            }
            this.jcrReadPrivilegeName = ACLProvider.this.session.getAccessControlManager().privilegeFromName("{http://www.jcp.org/jcr/1.0}read").getName();
            if (listenToEvents) {
                this.readAllowed = this.isReadAllowed(this.principalNames);
                int events = 19;
                String[] ntNames = new String[]{ACLProvider.this.resolver.getJCRName(AccessControlConstants.NT_REP_ACE), ACLProvider.this.resolver.getJCRName(AccessControlConstants.NT_REP_ACL)};
                ACLProvider.this.observationMgr.addEventListener(this, events, ACLProvider.this.session.getRootNode().getPath(), true, null, ntNames, true);
            }
        }

        private boolean isReadAllowed(Collection<String> principalnames) {
            boolean isReadAllowed = false;
            if (ACLProvider.this.initializedWithDefaults) {
                try {
                    QueryManager qm = ACLProvider.this.session.getWorkspace().getQueryManager();
                    StringBuffer stmt = new StringBuffer("/jcr:root");
                    stmt.append("//element(*,");
                    stmt.append(ACLProvider.this.resolver.getJCRName(AccessControlConstants.NT_REP_DENY_ACE));
                    stmt.append(")[(");
                    int i = 0;
                    for (String principalname : principalnames) {
                        stmt.append("@").append(ACLProvider.this.resolver.getJCRName(AccessControlConstants.P_PRINCIPAL_NAME)).append(" eq ");
                        stmt.append("'").append(principalname).append("'");
                        if (++i >= principalnames.size()) continue;
                        stmt.append(" or ");
                    }
                    stmt.append(") and @");
                    stmt.append(ACLProvider.this.resolver.getJCRName(AccessControlConstants.P_PRIVILEGES));
                    stmt.append(" = '").append(this.jcrReadPrivilegeName).append("']");
                    Query q = qm.createQuery(stmt.toString(), "xpath");
                    NodeIterator it = q.execute().getNodes();
                    isReadAllowed = !it.hasNext();
                }
                catch (RepositoryException e) {
                    log.error(e.toString());
                }
            }
            return isReadAllowed;
        }

        @Override
        protected AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
            List<AccessControlEntry> localACEs;
            boolean existingNode = false;
            NodeImpl node = null;
            String jcrPath = ACLProvider.this.resolver.getJCRPath(absPath);
            if (ACLProvider.this.session.nodeExists(jcrPath)) {
                node = (NodeImpl)ACLProvider.this.session.getNode(jcrPath);
                existingNode = true;
            } else {
                String parentPath = Text.getRelativeParent(jcrPath, 1);
                while (parentPath.length() > 0) {
                    if (ACLProvider.this.session.nodeExists(parentPath)) {
                        node = (NodeImpl)ACLProvider.this.session.getNode(parentPath);
                        break;
                    }
                    parentPath = Text.getRelativeParent(parentPath, 1);
                }
            }
            if (node == null) {
                throw new ItemNotFoundException("Item out of hierarchy.");
            }
            boolean isAcItem = ACLProvider.this.isAcItem(absPath);
            AccessControlEntryIterator entries = new Entries(ACLProvider.this.getNode(node), this.principalNames).iterator();
            if (existingNode && ACLProvider.isAccessControlled(node)) {
                NodeImpl aclNode = node.getNode(AccessControlConstants.N_POLICY);
                localACEs = Arrays.asList(ACLProvider.this.systemEditor.getACL(aclNode).getAccessControlEntries());
            } else {
                localACEs = Collections.EMPTY_LIST;
            }
            int allows = 0;
            int denies = 0;
            int allowPrivileges = 0;
            int denyPrivileges = 0;
            int parentAllows = 0;
            int parentDenies = 0;
            while (entries.hasNext()) {
                int permissions;
                ACLTemplate.Entry ace = (ACLTemplate.Entry)entries.next();
                int entryBits = ace.getPrivilegeBits();
                boolean isLocal = localACEs.contains(ace);
                if (!isLocal) {
                    if (ace.isAllow()) {
                        parentAllows |= Permission.diff(entryBits, parentDenies);
                    } else {
                        parentDenies |= Permission.diff(entryBits, parentAllows);
                    }
                }
                if (ace.isAllow()) {
                    permissions = PrivilegeRegistry.calculatePermissions(allowPrivileges |= Permission.diff(entryBits, denyPrivileges), parentAllows, true, isAcItem);
                    allows |= Permission.diff(permissions, denies);
                    continue;
                }
                permissions = PrivilegeRegistry.calculatePermissions(denyPrivileges |= Permission.diff(entryBits, allowPrivileges), parentDenies, false, isAcItem);
                denies |= Permission.diff(permissions, allows);
            }
            return new AbstractCompiledPermissions.Result(allows, denies, allowPrivileges, denyPrivileges);
        }

        @Override
        public void close() {
            try {
                ACLProvider.this.observationMgr.removeEventListener(this);
            }
            catch (RepositoryException e) {
                log.debug("Unable to unregister listener: ", (Object)e.getMessage());
            }
            super.close();
        }

        @Override
        public boolean grants(Path absPath, int permissions) throws RepositoryException {
            if (permissions == 1 && this.readAllowed && !ACLProvider.this.isAcItem(absPath)) {
                return true;
            }
            return super.grants(absPath, permissions);
        }

        @Override
        public synchronized void onEvent(EventIterator events) {
            boolean clearCache = false;
            block8: while (events.hasNext() && !clearCache) {
                try {
                    Event ev = events.nextEvent();
                    String path = ev.getPath();
                    switch (ev.getType()) {
                        case 1: {
                            NodeImpl n = (NodeImpl)ACLProvider.this.session.getNode(path);
                            if (!n.isNodeType(AccessControlConstants.NT_REP_ACE) || !this.principalNames.contains(n.getProperty(AccessControlConstants.P_PRINCIPAL_NAME).getString())) break;
                            if (this.readAllowed && n.isNodeType(AccessControlConstants.NT_REP_DENY_ACE)) {
                                Value[] vs;
                                for (Value v : vs = n.getProperty(AccessControlConstants.P_PRIVILEGES).getValues()) {
                                    if (!this.jcrReadPrivilegeName.equals(v.getString())) continue;
                                    this.readAllowed = false;
                                }
                            }
                            clearCache = true;
                            break;
                        }
                        case 2: 
                        case 8: {
                            this.readAllowed = this.isReadAllowed(this.principalNames);
                            clearCache = true;
                            break;
                        }
                        case 4: 
                        case 16: {
                            PropertyImpl p = (PropertyImpl)ACLProvider.this.session.getProperty(path);
                            NodeImpl parent = (NodeImpl)p.getParent();
                            if (!parent.isNodeType(AccessControlConstants.NT_REP_ACE)) break;
                            String principalName = null;
                            if (AccessControlConstants.P_PRIVILEGES.equals(p.getQName())) {
                                principalName = parent.getProperty(AccessControlConstants.P_PRINCIPAL_NAME).getString();
                            } else if (AccessControlConstants.P_PRINCIPAL_NAME.equals(p.getQName())) {
                                principalName = p.getString();
                            }
                            if (principalName == null || !this.principalNames.contains(principalName)) continue block8;
                            this.readAllowed = this.isReadAllowed(this.principalNames);
                            clearCache = true;
                            break;
                        }
                        case 32: {
                            break;
                        }
                    }
                }
                catch (RepositoryException e) {
                    log.warn("Internal error: ", (Object)e.getMessage());
                }
            }
            if (clearCache) {
                this.clearCache();
            }
        }
    }
}

