/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import org.apache.jackrabbit.core.security.authorization.UnmodifiableAccessControlList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlEntryIterator
implements Iterator<AccessControlEntry> {
    private static Logger log = LoggerFactory.getLogger(AccessControlEntryIterator.class);
    private final List<AccessControlList> acls = new ArrayList<AccessControlList>();
    private Iterator<AccessControlEntry> currentEntries;
    private AccessControlEntry next;

    public AccessControlEntryIterator(List<AccessControlEntry> aces) {
        this(new AccessControlList[]{new UnmodifiableAccessControlList(aces)});
    }

    public AccessControlEntryIterator(AccessControlList[] acls) {
        this.acls.addAll(Arrays.asList(acls));
        this.next = this.seekNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public AccessControlEntry next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        AccessControlEntry ret = this.next;
        this.next = this.seekNext();
        return ret;
    }

    private AccessControlEntry seekNext() {
        while (this.currentEntries == null || !this.currentEntries.hasNext()) {
            if (this.acls.isEmpty()) {
                this.currentEntries = null;
                break;
            }
            AccessControlEntry[] entries = new AccessControlEntry[]{};
            try {
                entries = this.acls.remove(0).getAccessControlEntries();
            }
            catch (RepositoryException e) {
                log.error("Unable to retrieve ACEs: " + e.getMessage() + " -> try next.");
            }
            this.currentEntries = Arrays.asList(entries).iterator();
        }
        return this.currentEntries == null ? null : this.currentEntries.next();
    }
}

