/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.directory;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.directory.DirectoryManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;

public class FSDirectoryManager
implements DirectoryManager {
    private File baseDir;

    public void init(SearchIndex handler) throws IOException {
        this.baseDir = new File(handler.getPath());
    }

    public boolean hasDirectory(String name) throws IOException {
        return new File(this.baseDir, name).exists();
    }

    public Directory getDirectory(String name) throws IOException {
        File dir = name.equals(".") ? this.baseDir : new File(this.baseDir, name);
        return new FSDir(dir);
    }

    public String[] getDirectoryNames() throws IOException {
        File[] dirs = this.baseDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (dirs != null) {
            String[] names = new String[dirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                names[i] = dirs[i].getName();
            }
            return names;
        }
        throw new IOException("listFiles for " + this.baseDir.getPath() + " returned null");
    }

    public boolean delete(String name) {
        File directory = new File(this.baseDir, name);
        if (!directory.exists()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.delete()) continue;
                return false;
            }
        } else {
            return false;
        }
        return directory.delete();
    }

    public boolean rename(String from, String to) {
        File src = new File(this.baseDir, from);
        File dest = new File(this.baseDir, to);
        return src.renameTo(dest);
    }

    public void dispose() {
    }

    private static final class FSDir
    extends Directory {
        private static final FileFilter FILTER = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        };
        private final FSDirectory directory;

        public FSDir(File dir) throws IOException {
            this.directory = FSDirectory.getDirectory(dir, (LockFactory)new NativeFSLockFactory(dir));
        }

        public String[] list() throws IOException {
            File[] files = this.directory.getFile().listFiles(FILTER);
            if (files == null) {
                return null;
            }
            String[] names = new String[files.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = files[i].getName();
            }
            return names;
        }

        public boolean fileExists(String name) throws IOException {
            return this.directory.fileExists(name);
        }

        public long fileModified(String name) throws IOException {
            return this.directory.fileModified(name);
        }

        public void touchFile(String name) throws IOException {
            this.directory.touchFile(name);
        }

        public void deleteFile(String name) throws IOException {
            this.directory.deleteFile(name);
        }

        public void renameFile(String from, String to) throws IOException {
            this.directory.renameFile(from, to);
        }

        public long fileLength(String name) throws IOException {
            return this.directory.fileLength(name);
        }

        public IndexOutput createOutput(String name) throws IOException {
            return this.directory.createOutput(name);
        }

        public IndexInput openInput(String name) throws IOException {
            return this.directory.openInput(name);
        }

        public void close() throws IOException {
            this.directory.close();
        }

        public IndexInput openInput(String name, int bufferSize) throws IOException {
            return this.directory.openInput(name, bufferSize);
        }

        public Lock makeLock(String name) {
            return this.directory.makeLock(name);
        }

        public void clearLock(String name) throws IOException {
            this.directory.clearLock(name);
        }

        public void setLockFactory(LockFactory lockFactory) {
            this.directory.setLockFactory(lockFactory);
        }

        public LockFactory getLockFactory() {
            return this.directory.getLockFactory();
        }

        public String getLockID() {
            return this.directory.getLockID();
        }

        public String toString() {
            return this.getClass().getName() + "@" + this.directory;
        }
    }
}

