/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jackrabbit.core.query.lucene.TextExtractorJob;

class TextExtractorReader
extends Reader {
    private Reader extractedText;
    private TextExtractorJob job;
    private final long timeout;

    TextExtractorReader(TextExtractorJob job, long timeout) {
        this.job = job;
        this.timeout = timeout;
    }

    public void close() throws IOException {
        if (this.extractedText != null) {
            this.extractedText.close();
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.extractedText == null) {
            String text = this.job.getExtractedText(this.timeout);
            if (text == null) {
                text = "";
            }
            this.extractedText = new StringReader(text);
        }
        return this.extractedText.read(cbuf, off, len);
    }

    public boolean isExtractorFinished() {
        return this.job.hasExtractedText();
    }
}

