/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.extractor.TextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextExtractorJob
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TextExtractorJob.class);
    private final TextExtractor extractor;
    private final InputStream stream;
    private final String type;
    private final String encoding;
    private volatile String text = null;

    public TextExtractorJob(TextExtractor extractor, InputStream stream, String type, String encoding) {
        this.extractor = extractor;
        this.stream = stream;
        this.type = type;
        this.encoding = encoding;
    }

    public boolean hasExtractedText() {
        return this.text != null;
    }

    public synchronized String getExtractedText(long timeout) {
        block3: {
            if (this.text == null) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    if (this.text != null) break block3;
                    log.debug("Text extraction for {} timed out (> {}ms)", (Object)this.type, (Object)timeout);
                }
            }
        }
        return this.text;
    }

    public String toString() {
        return "TextExtractorJob for " + this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                Reader reader = this.extractor.extractText(this.stream, this.type, this.encoding);
                this.text = IOUtils.toString(reader);
            }
            finally {
                this.stream.close();
            }
        }
        catch (Throwable e) {
            log.warn("Text extraction failed for type " + this.type, e);
            this.text = "";
        }
        TextExtractorJob textExtractorJob = this;
        synchronized (textExtractorJob) {
            this.notifyAll();
        }
    }
}

