/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.FilterMultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactoryImpl;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryResult;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.constraint.Constraint;
import org.apache.jackrabbit.core.query.lucene.constraint.ConstraintBuilder;
import org.apache.jackrabbit.spi.commons.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ColumnImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DefaultTraversingQOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.OrderingImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;

public class QueryObjectModelImpl
extends AbstractQueryImpl {
    private final QueryObjectModelTree qomTree;

    public QueryObjectModelImpl(SessionImpl session, ItemManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg, QueryObjectModelTree qomTree) throws InvalidQueryException {
        super(session, itemMgr, index, propReg);
        this.qomTree = qomTree;
        this.checkNodeTypes();
        this.extractBindVariableNames();
    }

    public boolean needsSystemTree() {
        return true;
    }

    public QueryResult execute(long offset, long limit) throws RepositoryException {
        LuceneQueryFactoryImpl factory = new LuceneQueryFactoryImpl(this.session, this.index.getSortComparatorSource(), this.index.getContext().getHierarchyManager(), this.index.getNamespaceMappings(), this.index.getTextAnalyzer(), this.index.getSynonymProvider(), this.index.getIndexFormatVersion());
        MultiColumnQuery query = factory.create(this.qomTree.getSource());
        if (this.qomTree.getConstraint() != null) {
            Constraint c = ConstraintBuilder.create(this.qomTree.getConstraint(), this.getBindVariableValues(), this.qomTree.getSource().getSelectors(), factory, this.session.getValueFactory());
            query = new FilterMultiColumnQuery(query, c);
        }
        ArrayList<ColumnImpl> columns = new ArrayList<ColumnImpl>();
        for (ColumnImpl column : this.qomTree.getColumns()) {
            if (column.getColumnName() == null) {
                QueryObjectModelFactory qomFactory = this.getQOMFactory();
                NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
                SelectorImpl selector = this.qomTree.getSelector(column.getSelectorQName());
                NodeTypeImpl nt = ntMgr.getNodeType(selector.getNodeTypeQName());
                for (PropertyDefinition pd : nt.getPropertyDefinitions()) {
                    PropertyDefinitionImpl propDef = (PropertyDefinitionImpl)pd;
                    if (propDef.definesResidual() || propDef.isMultiple()) continue;
                    String sn = selector.getSelectorName();
                    String pn = propDef.getName();
                    columns.add((ColumnImpl)qomFactory.column(sn, pn, sn + "." + pn));
                }
                continue;
            }
            columns.add(column);
        }
        OrderingImpl[] orderings = this.qomTree.getOrderings();
        return new MultiColumnQueryResult(this.index, this.itemMgr, this.session, this.session.getAccessManager(), this, query, null, columns.toArray(new ColumnImpl[columns.size()]), orderings, orderings.length == 0 && this.getRespectDocumentOrder(), offset, limit);
    }

    private void extractBindVariableNames() {
        try {
            this.qomTree.accept(new DefaultTraversingQOMTreeVisitor(){

                public Object visit(BindVariableValueImpl node, Object data) {
                    QueryObjectModelImpl.this.addVariableName(node.getBindVariableQName());
                    return data;
                }
            }, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkNodeTypes() throws InvalidQueryException {
        try {
            this.qomTree.accept(new DefaultTraversingQOMTreeVisitor(){

                public Object visit(SelectorImpl node, Object data) throws Exception {
                    String ntName = node.getNodeTypeName();
                    if (!QueryObjectModelImpl.this.session.getNodeTypeManager().hasNodeType(ntName)) {
                        throw new Exception(ntName + " is not a known node type");
                    }
                    return super.visit(node, data);
                }
            }, null);
        }
        catch (Exception e) {
            throw new InvalidQueryException(e.getMessage());
        }
    }
}

