/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronousChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jackrabbit.core.query.lucene.TextExtractorJob;
import org.apache.jackrabbit.core.query.lucene.TextExtractorReader;
import org.apache.jackrabbit.extractor.TextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledTextExtractor
implements TextExtractor {
    private static final Logger log = LoggerFactory.getLogger(PooledTextExtractor.class);
    private final TextExtractor extractor;
    private final PooledExecutor executor;
    private final long timout;

    public PooledTextExtractor(TextExtractor extractor, int poolSize, int backLog, long timeout) {
        this.extractor = extractor;
        this.timout = timeout;
        BoundedChannel c = backLog <= 0 ? new SynchronousChannel() : new BoundedLinkedQueue(backLog);
        this.executor = new PooledExecutor(c, poolSize);
        this.executor.setMinimumPoolSize(poolSize);
        this.executor.setBlockedExecutionHandler(new PooledExecutor.BlockedExecutionHandler(){

            public boolean blockedAction(Runnable command) {
                log.info("Extractor pool busy, running command with current thread: {}", (Object)command.toString());
                command.run();
                return true;
            }
        });
    }

    public String[] getContentTypes() {
        return this.extractor.getContentTypes();
    }

    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        TextExtractorJob job = new TextExtractorJob(this.extractor, stream, type, encoding);
        try {
            this.executor.execute(job);
        }
        catch (InterruptedException e) {
            log.warn("Failed to start a background text extraction task", e);
            stream.close();
        }
        return new TextExtractorReader(job, this.timout);
    }

    public void shutdown() {
        boolean interrupted;
        this.executor.shutdownNow();
        do {
            try {
                this.executor.awaitTerminationAfterShutdown();
                interrupted = false;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (interrupted);
        this.executor.drain();
    }
}

