/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;

public class LuceneQueryHits
implements QueryHits {
    private final IndexReader reader;
    private final Scorer scorer;

    public LuceneQueryHits(IndexReader reader, IndexSearcher searcher, Query query) throws IOException {
        this.reader = reader;
        this.scorer = query.weight(searcher).scorer(reader);
    }

    public ScoreNode nextScoreNode() throws IOException {
        if (!this.scorer.next()) {
            return null;
        }
        int doc = this.scorer.doc();
        NodeId id = new NodeId(this.reader.document(doc).get(FieldNames.UUID));
        return new ScoreNode(id, this.scorer.score(), doc);
    }

    public void close() throws IOException {
        this.scorer.skipTo(Integer.MAX_VALUE);
    }

    public int getSize() {
        return -1;
    }

    public void skip(int n) throws IOException {
        while (n-- > 0) {
            if (this.nextScoreNode() != null) continue;
            return;
        }
    }
}

