/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.apache.jackrabbit.core.query.lucene.IndexListener;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.PersistentIndex;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexMerger
implements IndexListener {
    private static final Logger log = LoggerFactory.getLogger(IndexMerger.class);
    private static final Merge QUIT = new Merge(new Index[0]);
    private int minMergeDocs = 100;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    private final BlockingQueue<Merge> mergeTasks = new LinkedBlockingQueue<Merge>();
    private final List<IndexBucket> indexBuckets = new ArrayList<IndexBucket>();
    private final MultiIndex multiIndex;
    private final Object lock = new Object();
    private final Semaphore indexReplacement;
    private final List<Worker> busyMergers = new ArrayList<Worker>();
    private final List<Worker> workers = new ArrayList<Worker>();

    IndexMerger(MultiIndex multiIndex, int numWorkers) {
        this.multiIndex = multiIndex;
        for (int i = 0; i < numWorkers; ++i) {
            Worker w = new Worker();
            this.workers.add(w);
            this.busyMergers.add(w);
        }
        this.indexReplacement = new Semaphore(this.workers.size());
    }

    void start() {
        for (Worker t : this.workers) {
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexAdded(String name, int numDocs) {
        if (numDocs < 0) {
            throw new IllegalArgumentException("numDocs must be positive");
        }
        Object object = this.lock;
        synchronized (object) {
            IndexBucket indexBucket;
            if (this.indexBuckets.size() == 0) {
                long lower = 0L;
                for (long upper = (long)this.minMergeDocs; upper < (long)this.maxMergeDocs; upper *= (long)this.mergeFactor) {
                    this.indexBuckets.add(new IndexBucket(lower, upper, true));
                    lower = upper + 1L;
                }
                this.indexBuckets.add(new IndexBucket(lower, this.maxMergeDocs, false));
                this.indexBuckets.add(new IndexBucket(this.maxMergeDocs + 1, Long.MAX_VALUE, false));
            }
            IndexBucket bucket = this.indexBuckets.get(this.indexBuckets.size() - 1);
            Iterator<IndexBucket> i$ = this.indexBuckets.iterator();
            while (i$.hasNext() && !(bucket = (indexBucket = i$.next())).fits(numDocs)) {
            }
            bucket.add(new Index(name, numDocs));
            if (log.isDebugEnabled()) {
                log.debug("index added: name=" + name + ", numDocs=" + numDocs);
            }
            if (!bucket.allowsMerge()) {
                return;
            }
            if (bucket.size() >= this.mergeFactor) {
                long targetMergeDocs = bucket.upper;
                targetMergeDocs = Math.min(targetMergeDocs * (long)this.mergeFactor, (long)this.maxMergeDocs);
                ArrayList indexesToMerge = new ArrayList();
                int mergeDocs = 0;
                Iterator it = bucket.iterator();
                while (it.hasNext() && (long)mergeDocs <= targetMergeDocs) {
                    indexesToMerge.add(it.next());
                }
                if (indexesToMerge.size() > 2) {
                    Index[] idxs = indexesToMerge.toArray(new Index[indexesToMerge.size()]);
                    bucket.removeAll(indexesToMerge);
                    if (log.isDebugEnabled()) {
                        log.debug("requesting merge for " + indexesToMerge);
                    }
                    this.addMergeTask(new Merge(idxs));
                    if (log.isDebugEnabled()) {
                        int numBusy;
                        log.debug("merge queue now contains " + this.mergeTasks.size() + " tasks.");
                        List<Worker> list = this.busyMergers;
                        synchronized (list) {
                            numBusy = this.busyMergers.size();
                        }
                        log.debug("# of busy merge workers: " + numBusy);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentDeleted(Term id) {
        log.debug("document deleted: " + id.text());
        List<Worker> list = this.busyMergers;
        synchronized (list) {
            for (Worker w : this.busyMergers) {
                w.documentDeleted(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilIdle() throws InterruptedException {
        List<Worker> list = this.busyMergers;
        synchronized (list) {
            while (!this.busyMergers.isEmpty()) {
                this.busyMergers.wait();
            }
        }
    }

    void dispose() {
        log.debug("dispose IndexMerger");
        try {
            this.indexReplacement.acquire(this.workers.size());
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while acquiring index replacement permits: " + e);
        }
        log.debug("merge queue size: " + this.mergeTasks.size());
        this.mergeTasks.clear();
        this.addMergeTask(QUIT);
        log.debug("quit sent");
        try {
            for (Worker t : this.workers) {
                t.join(500L);
                if (t.isAlive()) {
                    log.info("Unable to stop IndexMerger.Worker. Daemon is busy.");
                    continue;
                }
                log.debug("IndexMerger.Worker thread stopped");
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for IndexMerger threads to terminate.");
        }
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    private void addMergeTask(Merge task) {
        while (true) {
            try {
                this.mergeTasks.put(task);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                continue;
            }
            break;
        }
    }

    private class Worker
    extends Thread
    implements IndexListener {
        private final List<Term> deletedDocuments = Collections.synchronizedList(new ArrayList());

        public Worker() {
            this.setName("IndexMerger.Worker");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                List e2;
                Merge task;
                boolean isIdle = false;
                if (IndexMerger.this.mergeTasks.size() == 0) {
                    List list = IndexMerger.this.busyMergers;
                    synchronized (list) {
                        IndexMerger.this.busyMergers.remove(this);
                        IndexMerger.this.busyMergers.notifyAll();
                    }
                    isIdle = true;
                }
                while (true) {
                    try {
                        task = (Merge)IndexMerger.this.mergeTasks.take();
                    }
                    catch (InterruptedException e2) {
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
                if (task == QUIT) {
                    e2 = IndexMerger.this.busyMergers;
                    synchronized (e2) {
                        IndexMerger.this.busyMergers.remove(this);
                    }
                    IndexMerger.this.addMergeTask(task);
                    break;
                }
                if (isIdle) {
                    e2 = IndexMerger.this.busyMergers;
                    synchronized (e2) {
                        IndexMerger.this.busyMergers.add(this);
                    }
                }
                log.debug("accepted merge request");
                this.deletedDocuments.clear();
                String[] names = new String[task.indexes.length];
                for (int i = 0; i < task.indexes.length; ++i) {
                    names[i] = task.indexes[i].name;
                }
                try {
                    log.debug("create new index");
                    PersistentIndex index = IndexMerger.this.multiIndex.getOrCreateIndex(null);
                    boolean success = false;
                    try {
                        log.debug("get index readers from MultiIndex");
                        IndexReader[] readers = IndexMerger.this.multiIndex.getIndexReaders(names, IndexMerger.this);
                        try {
                            long time = System.currentTimeMillis();
                            index.addIndexes(readers);
                            time = System.currentTimeMillis() - time;
                            int docCount = 0;
                            for (IndexReader reader : readers) {
                                docCount += reader.numDocs();
                            }
                            log.info("merged " + docCount + " documents in " + time + " ms into " + index.getName() + ".");
                        }
                        finally {
                            for (IndexReader reader : readers) {
                                try {
                                    Util.closeOrRelease(reader);
                                }
                                catch (IOException e3) {
                                    log.warn("Unable to close IndexReader: " + e3);
                                }
                            }
                        }
                        if (!IndexMerger.this.indexReplacement.tryAcquire()) {
                            log.debug("index merging canceled");
                            break;
                        }
                        try {
                            log.debug("replace indexes");
                            IndexMerger.this.multiIndex.replaceIndexes(names, index, this.deletedDocuments);
                        }
                        finally {
                            IndexMerger.this.indexReplacement.release();
                        }
                        success = true;
                    }
                    finally {
                        if (!success) {
                            log.debug("deleting index " + index.getName());
                            IndexMerger.this.multiIndex.deleteIndex(index);
                        }
                    }
                }
                catch (Throwable e4) {
                    log.error("Error while merging indexes: ", e4);
                }
            }
            log.info("IndexMerger.Worker terminated");
        }

        public void documentDeleted(Term id) {
            log.debug("document deleted: " + id.text());
            this.deletedDocuments.add(id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IndexBucket
    extends ArrayList<Index> {
        private static final long serialVersionUID = 2985514550083374904L;
        private final long lower;
        private final long upper;
        private final boolean allowMerge;

        IndexBucket(long lower, long upper, boolean allowMerge) {
            this.lower = lower;
            this.upper = upper;
            this.allowMerge = allowMerge;
        }

        boolean fits(long numDocs) {
            return numDocs >= this.lower && numDocs <= this.upper;
        }

        boolean allowsMerge() {
            return this.allowMerge;
        }
    }

    private static final class Merge {
        private final Index[] indexes;

        Merge(Index[] indexes) {
            this.indexes = new Index[indexes.length];
            System.arraycopy(indexes, 0, this.indexes, 0, indexes.length);
        }
    }

    private static final class Index
    implements Comparable {
        private final String name;
        private final int numDocs;

        Index(String name, int numDocs) {
            this.name = name;
            this.numDocs = numDocs;
        }

        public int compareTo(Object o) {
            int val;
            Index other = (Index)o;
            int n = this.numDocs < other.numDocs ? -1 : (val = this.numDocs == other.numDocs ? 0 : 1);
            if (val != 0) {
                return val;
            }
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name + ":" + this.numDocs;
        }
    }
}

