/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.lucene.AggregateRule;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.util.Text;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AggregateRuleImpl
implements AggregateRule {
    private final NameResolver resolver;
    private final Name nodeTypeName;
    private final NodeInclude[] nodeIncludes;
    private final PropertyInclude[] propertyIncludes;
    private final ItemStateManager ism;
    private final HierarchyManager hmgr;

    AggregateRuleImpl(Node config, NameResolver resolver, ItemStateManager ism, HierarchyManager hmgr) throws MalformedPathException, IllegalNameException, NamespaceException, RepositoryException {
        this.resolver = resolver;
        this.nodeTypeName = this.getNodeTypeName(config);
        this.nodeIncludes = this.getNodeIncludes(config);
        this.propertyIncludes = this.getPropertyIncludes(config);
        this.ism = ism;
        this.hmgr = hmgr;
    }

    public NodeState getAggregateRoot(NodeState nodeState) throws ItemStateException, RepositoryException {
        NodeState aggregateRoot;
        for (NodeInclude nodeInclude : this.nodeIncludes) {
            aggregateRoot = nodeInclude.matches(nodeState);
            if (aggregateRoot == null || !aggregateRoot.getNodeTypeName().equals(this.nodeTypeName)) continue;
            return aggregateRoot;
        }
        for (AbstractInclude abstractInclude : this.propertyIncludes) {
            aggregateRoot = abstractInclude.matches(nodeState);
            if (aggregateRoot == null || !aggregateRoot.getNodeTypeName().equals(this.nodeTypeName)) continue;
            return aggregateRoot;
        }
        return null;
    }

    public NodeState[] getAggregatedNodeStates(NodeState nodeState) throws ItemStateException {
        if (nodeState.getNodeTypeName().equals(this.nodeTypeName)) {
            ArrayList<NodeState> nodeStates = new ArrayList<NodeState>();
            for (NodeInclude nodeInclude : this.nodeIncludes) {
                nodeStates.addAll(Arrays.asList(nodeInclude.resolve(nodeState)));
            }
            if (nodeStates.size() > 0) {
                return nodeStates.toArray(new NodeState[nodeStates.size()]);
            }
        }
        return null;
    }

    public PropertyState[] getAggregatedPropertyStates(NodeState nodeState) throws ItemStateException {
        if (nodeState.getNodeTypeName().equals(this.nodeTypeName)) {
            ArrayList<PropertyState> propStates = new ArrayList<PropertyState>();
            for (PropertyInclude propertyInclude : this.propertyIncludes) {
                propStates.addAll(Arrays.asList(propertyInclude.resolvePropertyStates(nodeState)));
            }
            if (propStates.size() > 0) {
                return propStates.toArray(new PropertyState[propStates.size()]);
            }
        }
        return null;
    }

    private Name getNodeTypeName(Node config) throws IllegalNameException, NamespaceException {
        String ntString = config.getAttributes().getNamedItem("primaryType").getNodeValue();
        return this.resolver.getQName(ntString);
    }

    private NodeInclude[] getNodeIncludes(Node config) throws MalformedPathException, IllegalNameException, NamespaceException {
        ArrayList<NodeInclude> includes = new ArrayList<NodeInclude>();
        NodeList childNodes = config.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals("include")) continue;
            Name ntName = null;
            Node ntAttr = n.getAttributes().getNamedItem("primaryType");
            if (ntAttr != null) {
                ntName = this.resolver.getQName(ntAttr.getNodeValue());
            }
            PathBuilder builder = new PathBuilder();
            for (String element : Text.explode(AggregateRuleImpl.getTextContent(n), 47)) {
                if (element.equals("*")) {
                    builder.addLast(NameConstants.ANY_NAME);
                    continue;
                }
                builder.addLast(this.resolver.getQName(element));
            }
            includes.add(new NodeInclude(builder.getPath(), ntName));
        }
        return includes.toArray(new NodeInclude[includes.size()]);
    }

    private PropertyInclude[] getPropertyIncludes(Node config) throws MalformedPathException, IllegalNameException, NamespaceException, RepositoryException {
        ArrayList<PropertyInclude> includes = new ArrayList<PropertyInclude>();
        NodeList childNodes = config.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals("include-property")) continue;
            PathBuilder builder = new PathBuilder();
            for (String element : Text.explode(AggregateRuleImpl.getTextContent(n), 47)) {
                if (element.equals("*")) {
                    throw new IllegalNameException("* not supported in include-property");
                }
                builder.addLast(this.resolver.getQName(element));
            }
            includes.add(new PropertyInclude(builder.getPath()));
        }
        return includes.toArray(new PropertyInclude[includes.size()]);
    }

    private static String getTextContent(Node node) {
        StringBuffer content = new StringBuffer();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 3) continue;
            content.append(((CharacterData)n).getData());
        }
        return content.toString();
    }

    private final class PropertyInclude
    extends AbstractInclude {
        private final Name propertyName;

        PropertyInclude(Path pattern) throws RepositoryException {
            super(pattern.getAncestor(1), null);
            this.propertyName = pattern.getNameElement().getName();
        }

        PropertyState[] resolvePropertyStates(NodeState nodeState) throws ItemStateException {
            ArrayList<NodeState> nodeStates = new ArrayList<NodeState>();
            this.resolve(nodeState, nodeStates, 0);
            ArrayList<PropertyState> propStates = new ArrayList<PropertyState>();
            for (NodeState state : nodeStates) {
                if (!state.hasPropertyName(this.propertyName)) continue;
                PropertyId propId = new PropertyId(state.getNodeId(), this.propertyName);
                propStates.add((PropertyState)AggregateRuleImpl.this.ism.getItemState(propId));
            }
            return propStates.toArray(new PropertyState[propStates.size()]);
        }
    }

    private final class NodeInclude
    extends AbstractInclude {
        NodeInclude(Path pattern, Name nodeTypeName) {
            super(pattern, nodeTypeName);
        }

        NodeState[] resolve(NodeState nodeState) throws ItemStateException {
            ArrayList<NodeState> nodeStates = new ArrayList<NodeState>();
            this.resolve(nodeState, nodeStates, 0);
            return nodeStates.toArray(new NodeState[nodeStates.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractInclude {
        protected final Name nodeTypeName;
        protected final Path pattern;

        AbstractInclude(Path pattern, Name nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
            this.pattern = pattern;
        }

        NodeState matches(NodeState nodeState) throws ItemStateException, RepositoryException {
            if (this.nodeTypeName == null || nodeState.getNodeTypeName().equals(this.nodeTypeName)) {
                Path.Element[] elements = this.pattern.getElements();
                for (int e = elements.length - 1; e >= 0; --e) {
                    NodeId parentId = nodeState.getParentId();
                    if (parentId == null) {
                        return null;
                    }
                    NodeState parent = (NodeState)AggregateRuleImpl.this.ism.getItemState(parentId);
                    if (elements[e].getName().getLocalName().equals("*")) {
                        nodeState = parent;
                        continue;
                    }
                    Name name = AggregateRuleImpl.this.hmgr.getName(nodeState.getId());
                    if (elements[e].getName().equals(name)) {
                        nodeState = parent;
                        continue;
                    }
                    return null;
                }
                return nodeState;
            }
            return null;
        }

        protected void resolve(NodeState nodeState, List<NodeState> collector, int offset) throws ItemStateException {
            Name currentName = this.pattern.getElements()[offset].getName();
            List<ChildNodeEntry> cne = currentName.getLocalName().equals("*") ? nodeState.getChildNodeEntries() : nodeState.getChildNodeEntries(currentName);
            if (this.pattern.getLength() - 1 == offset) {
                for (ChildNodeEntry entry : cne) {
                    NodeState ns = (NodeState)AggregateRuleImpl.this.ism.getItemState(entry.getId());
                    if (this.nodeTypeName != null && !ns.getNodeTypeName().equals(this.nodeTypeName)) continue;
                    collector.add(ns);
                }
            } else {
                ++offset;
                for (ChildNodeEntry entry : cne) {
                    NodeId id = entry.getId();
                    this.resolve((NodeState)AggregateRuleImpl.this.ism.getItemState(id), collector, offset);
                }
            }
        }
    }
}

