/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.BitSet;
import org.apache.jackrabbit.core.query.lucene.CachingIndexReader;
import org.apache.jackrabbit.core.query.lucene.CommittableIndexReader;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.DynamicPooledExecutor;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexingQueue;
import org.apache.jackrabbit.core.query.lucene.LazyTextExtractorField;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.jackrabbit.core.query.lucene.SharedIndexReader;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractIndex {
    private static final Logger log = LoggerFactory.getLogger(AbstractIndex.class);
    private static final LoggingPrintStream STREAM_LOGGER = new LoggingPrintStream();
    private static final DynamicPooledExecutor EXECUTOR = new DynamicPooledExecutor();
    private IndexWriter indexWriter;
    private CommittableIndexReader indexReader;
    private Directory directory;
    private Analyzer analyzer;
    private final Similarity similarity;
    private boolean useCompoundFile = true;
    private int maxFieldLength = 10000;
    private int termInfosIndexDivisor = 1;
    private DocNumberCache cache;
    private SharedIndexReader sharedReader;
    private ReadOnlyIndexReader readOnlyReader;
    private IndexingQueue indexingQueue;
    private boolean isExisting;

    AbstractIndex(Analyzer analyzer, Similarity similarity, Directory directory, DocNumberCache cache, IndexingQueue indexingQueue) throws IOException {
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.directory = directory;
        this.cache = cache;
        this.indexingQueue = indexingQueue;
        this.isExisting = IndexReader.indexExists(directory);
        if (!this.isExisting) {
            this.indexWriter = new IndexWriter(directory, analyzer, IndexWriter.MaxFieldLength.LIMITED);
            this.indexWriter.close();
            this.indexWriter = null;
        }
    }

    Directory getDirectory() {
        return this.directory;
    }

    boolean isExisting() {
        return this.isExisting;
    }

    void addDocuments(Document[] docs) throws IOException {
        final IndexWriter writer = this.getIndexWriter();
        DynamicPooledExecutor.Command[] commands = new DynamicPooledExecutor.Command[docs.length];
        for (int i = 0; i < docs.length; ++i) {
            final Document doc = this.getFinishedDocument(docs[i]);
            commands[i] = new DynamicPooledExecutor.Command(){

                public Object call() throws Exception {
                    long time = System.currentTimeMillis();
                    writer.addDocument(doc);
                    return System.currentTimeMillis() - time;
                }
            };
        }
        DynamicPooledExecutor.Result[] results = EXECUTOR.executeAndWait(commands);
        this.invalidateSharedReader();
        IOException ex = null;
        for (DynamicPooledExecutor.Result result : results) {
            if (result.getException() != null) {
                Throwable cause = result.getException().getCause();
                if (ex == null) {
                    if (cause instanceof IOException) {
                        ex = (IOException)cause;
                        continue;
                    }
                    throw Util.createIOException(cause);
                }
                log.warn("Exception while inverting document", cause);
                continue;
            }
            log.debug("Inverted document in {} ms", result.get());
        }
        if (ex != null) {
            throw ex;
        }
    }

    int removeDocument(Term idTerm) throws IOException {
        return this.getIndexReader().deleteDocuments(idTerm);
    }

    protected synchronized CommittableIndexReader getIndexReader() throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            log.debug("closing IndexWriter.");
            this.indexWriter = null;
        }
        if (this.indexReader == null) {
            IndexDeletionPolicy idp = this.getIndexDeletionPolicy();
            IndexReader reader = idp != null ? IndexReader.open(this.getDirectory(), idp) : IndexReader.open(this.getDirectory());
            reader.setTermInfosIndexDivisor(this.termInfosIndexDivisor);
            this.indexReader = new CommittableIndexReader(reader);
        }
        return this.indexReader;
    }

    protected IndexDeletionPolicy getIndexDeletionPolicy() {
        return null;
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader(boolean initCache) throws IOException {
        CommittableIndexReader modifiableReader = this.getIndexReader();
        long modCount = modifiableReader.getModificationCount();
        if (this.readOnlyReader != null) {
            if (this.readOnlyReader.getDeletedDocsVersion() == modCount) {
                this.readOnlyReader.acquire();
                return this.readOnlyReader;
            }
            if (this.readOnlyReader.getRefCount() == 1) {
                this.readOnlyReader.updateDeletedDocs(modifiableReader);
                this.readOnlyReader.acquire();
                return this.readOnlyReader;
            }
            this.readOnlyReader.release();
            this.readOnlyReader = null;
        }
        BitSet deleted = new BitSet(modifiableReader.maxDoc());
        for (int i = 0; i < modifiableReader.maxDoc(); ++i) {
            if (!modifiableReader.isDeleted(i)) continue;
            deleted.set(i);
        }
        if (this.sharedReader == null) {
            IndexReader reader = IndexReader.open(this.getDirectory(), true);
            reader.setTermInfosIndexDivisor(this.termInfosIndexDivisor);
            CachingIndexReader cr = new CachingIndexReader(reader, this.cache, initCache);
            this.sharedReader = new SharedIndexReader(cr);
        }
        this.readOnlyReader = new ReadOnlyIndexReader(this.sharedReader, deleted, modCount);
        this.readOnlyReader.acquire();
        return this.readOnlyReader;
    }

    protected ReadOnlyIndexReader getReadOnlyIndexReader() throws IOException {
        return this.getReadOnlyIndexReader(false);
    }

    protected synchronized IndexWriter getIndexWriter() throws IOException {
        if (this.indexReader != null) {
            this.indexReader.close();
            log.debug("closing IndexReader.");
            this.indexReader = null;
        }
        if (this.indexWriter == null) {
            this.indexWriter = new IndexWriter(this.getDirectory(), this.analyzer, new IndexWriter.MaxFieldLength(this.maxFieldLength));
            this.indexWriter.setSimilarity(this.similarity);
            this.indexWriter.setUseCompoundFile(this.useCompoundFile);
            this.indexWriter.setInfoStream(STREAM_LOGGER);
        }
        return this.indexWriter;
    }

    protected void commit() throws IOException {
        this.commit(false);
    }

    protected synchronized void commit(boolean optimize) throws IOException {
        if (this.indexReader != null) {
            log.debug("committing IndexReader.");
            this.indexReader.flush();
        }
        if (this.indexWriter != null) {
            log.debug("committing IndexWriter.");
            this.indexWriter.commit();
        }
        if (optimize) {
            IndexWriter writer = this.getIndexWriter();
            writer.optimize();
            writer.close();
            this.indexWriter = null;
        }
    }

    synchronized void close() {
        this.releaseWriterAndReaders();
        if (this.directory != null) {
            try {
                this.directory.close();
            }
            catch (IOException e) {
                this.directory = null;
            }
        }
    }

    protected void releaseWriterAndReaders() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.close();
            }
            catch (IOException e) {
                log.warn("Exception closing index writer: " + e.toString());
            }
            this.indexWriter = null;
        }
        if (this.indexReader != null) {
            try {
                this.indexReader.close();
            }
            catch (IOException e) {
                log.warn("Exception closing index reader: " + e.toString());
            }
            this.indexReader = null;
        }
        if (this.readOnlyReader != null) {
            try {
                this.readOnlyReader.release();
            }
            catch (IOException e) {
                log.warn("Exception closing index reader: " + e.toString());
            }
            this.readOnlyReader = null;
        }
        if (this.sharedReader != null) {
            try {
                this.sharedReader.release();
            }
            catch (IOException e) {
                log.warn("Exception closing index reader: " + e.toString());
            }
            this.sharedReader = null;
        }
    }

    synchronized long getRamSizeInBytes() {
        if (this.indexWriter != null) {
            return this.indexWriter.ramSizeInBytes();
        }
        return 0L;
    }

    protected synchronized void invalidateSharedReader() throws IOException {
        if (this.readOnlyReader != null) {
            this.readOnlyReader.release();
            this.readOnlyReader = null;
        }
        if (this.sharedReader != null) {
            this.sharedReader.release();
            this.sharedReader = null;
        }
    }

    private Document getFinishedDocument(Document doc) throws IOException {
        if (!Util.isDocumentReady(doc)) {
            Document copy = new Document();
            copy.add(new Field(FieldNames.REINDEXING_REQUIRED, "", Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            for (Fieldable f : doc.getFields()) {
                Field field = null;
                Field.TermVector tv = this.getTermVectorParameter(f);
                Field.Store stored = this.getStoreParameter(f);
                Field.Index indexed = this.getIndexParameter(f);
                if (f instanceof LazyTextExtractorField || f.readerValue() != null) {
                    field = new Field(f.name(), new StringReader(""), tv);
                } else if (f.stringValue() != null) {
                    field = new Field(f.name(), f.stringValue(), stored, indexed, tv);
                } else if (f.isBinary()) {
                    field = new Field(f.name(), f.binaryValue(), stored);
                }
                if (field == null) continue;
                field.setOmitNorms(f.getOmitNorms());
                copy.add(field);
            }
            Document existing = this.indexingQueue.addDocument(doc);
            if (existing != null) {
                Util.disposeDocument(existing);
            }
            doc = copy;
        }
        return doc;
    }

    void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
        if (this.indexWriter != null) {
            this.indexWriter.setUseCompoundFile(b);
        }
    }

    void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
        if (this.indexWriter != null) {
            this.indexWriter.setMaxFieldLength(maxFieldLength);
        }
    }

    public int getTermInfosIndexDivisor() {
        return this.termInfosIndexDivisor;
    }

    public void setTermInfosIndexDivisor(int termInfosIndexDivisor) {
        this.termInfosIndexDivisor = termInfosIndexDivisor;
    }

    private Field.Index getIndexParameter(Fieldable f) {
        if (!f.isIndexed()) {
            return Field.Index.NO;
        }
        if (f.isTokenized()) {
            return Field.Index.ANALYZED;
        }
        return Field.Index.NOT_ANALYZED;
    }

    private Field.Store getStoreParameter(Fieldable f) {
        if (f.isCompressed()) {
            return Field.Store.COMPRESS;
        }
        if (f.isStored()) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }

    private Field.TermVector getTermVectorParameter(Fieldable f) {
        if (f.isStorePositionWithTermVector() && f.isStoreOffsetWithTermVector()) {
            return Field.TermVector.WITH_POSITIONS_OFFSETS;
        }
        if (f.isStorePositionWithTermVector()) {
            return Field.TermVector.WITH_POSITIONS;
        }
        if (f.isStoreOffsetWithTermVector()) {
            return Field.TermVector.WITH_OFFSETS;
        }
        if (f.isTermVectorStored()) {
            return Field.TermVector.YES;
        }
        return Field.TermVector.NO;
    }

    private static final class LoggingPrintStream
    extends PrintStream {
        private StringBuffer buffer = new StringBuffer();

        public LoggingPrintStream() {
            super(new OutputStream(){

                public void write(int b) {
                }
            });
        }

        public void print(String s) {
            this.buffer.append(s);
        }

        public void println(String s) {
            this.buffer.append(s);
            log.debug(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }
}

