/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.io.IOException;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.OnWorkspaceInconsistency;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.QueryImpl;
import org.apache.jackrabbit.core.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryHandler
implements QueryHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueryHandler.class);
    private QueryHandlerContext context;
    private OnWorkspaceInconsistency owi = OnWorkspaceInconsistency.FAIL;
    private String queryClass = QueryImpl.class.getName();
    private String idleTime;

    @Override
    public final void init(QueryHandlerContext context) throws IOException {
        this.context = context;
        this.doInit();
    }

    protected abstract void doInit() throws IOException;

    @Override
    public QueryHandlerContext getContext() {
        return this.context;
    }

    @Override
    public synchronized void updateNodes(Iterator<NodeId> remove, Iterator<NodeState> add) throws RepositoryException, IOException {
        while (remove.hasNext()) {
            this.deleteNode(remove.next());
        }
        while (add.hasNext()) {
            this.addNode(add.next());
        }
    }

    public OnWorkspaceInconsistency getOnWorkspaceInconsistencyHandler() {
        return this.owi;
    }

    public void setOnWorkspaceInconsistency(String name) {
        this.owi = OnWorkspaceInconsistency.fromString(name);
    }

    public String getOnWorkspaceInconsistency() {
        return this.owi.getName();
    }

    public void setQueryClass(String queryClass) {
        this.queryClass = queryClass;
    }

    @Override
    public String getQueryClass() {
        return this.queryClass;
    }

    public void setIdleTime(String idleTime) {
        log.warn("Parameter 'idleTime' is not supported anymore. Please use 'maxIdleTime' in the repository configuration.");
        this.idleTime = idleTime;
    }

    public String getIdleTime() {
        return this.idleTime;
    }
}

