/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.jackrabbit.core.persistence.bundle.util.ConnectionRecoveryManager;
import org.apache.jackrabbit.core.util.StringIndex;

public class DbNameIndex
implements StringIndex {
    protected ConnectionRecoveryManager connectionManager;
    protected String nameSelectSQL;
    protected String indexSelectSQL;
    protected String nameInsertSQL;
    private final HashMap<String, Integer> string2Index = new HashMap();
    private final HashMap<Integer, String> index2String = new HashMap();

    public DbNameIndex(ConnectionRecoveryManager conMgr, String schemaObjectPrefix) throws SQLException {
        this.connectionManager = conMgr;
        this.init(schemaObjectPrefix);
    }

    protected void init(String schemaObjectPrefix) throws SQLException {
        this.nameSelectSQL = "select NAME from " + schemaObjectPrefix + "NAMES where ID = ?";
        this.indexSelectSQL = "select ID from " + schemaObjectPrefix + "NAMES where NAME = ?";
        this.nameInsertSQL = "insert into " + schemaObjectPrefix + "NAMES (NAME) values (?)";
    }

    public void close() {
    }

    public int stringToIndex(String string) {
        Integer index = this.string2Index.get(string);
        if (index == null) {
            String dbString = string.length() == 0 ? " " : string;
            int idx = this.getIndex(dbString);
            if (idx == -1) {
                idx = this.insertString(dbString);
            }
            index = idx;
            this.string2Index.put(string, index);
            this.index2String.put(index, string);
            return idx;
        }
        return index;
    }

    public String indexToString(int idx) throws IllegalArgumentException {
        Integer index = idx;
        String s = this.index2String.get(index);
        if (s == null) {
            s = this.getString(idx);
            if (s.equals(" ")) {
                s = "";
            }
            this.index2String.put(index, s);
            this.string2Index.put(s, index);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insertString(String string) {
        int result = -1;
        try {
            PreparedStatement stmt = this.connectionManager.executeStmt(this.nameInsertSQL, new Object[]{string}, true, 0);
            ResultSet rs = stmt.getGeneratedKeys();
            try {
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to insert index for string: " + string);
            ise.initCause(e);
            throw ise;
        }
        if (result != -1) {
            return result;
        }
        return this.getIndex(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getIndex(String string) {
        try {
            PreparedStatement stmt = this.connectionManager.executeStmt(this.indexSelectSQL, new Object[]{string});
            ResultSet rs = stmt.getResultSet();
            try {
                if (rs.next()) {
                    int n = rs.getInt(1);
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                rs.close();
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to read index for string: " + string);
            ise.initCause(e);
            throw ise;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getString(int index) throws IllegalArgumentException, IllegalStateException {
        String result = null;
        try {
            PreparedStatement stmt = this.connectionManager.executeStmt(this.nameSelectSQL, new Object[]{index});
            ResultSet rs = stmt.getResultSet();
            try {
                if (rs.next()) {
                    result = rs.getString(1);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to read name for index: " + index);
            ise.initCause(e);
            throw ise;
        }
        if (result == null) {
            throw new IllegalArgumentException("Index not found: " + index);
        }
        return result;
    }
}

