/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashSet;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.persistence.bundle.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.bundle.util.ItemStateBinding;
import org.apache.jackrabbit.core.persistence.bundle.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.ResourceBasedBLOBStore;
import org.apache.jackrabbit.core.util.StringIndex;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleBinding
extends ItemStateBinding {
    private static final int BINARY_IN_BLOB_STORE = -1;
    private static final int BINARY_IN_DATA_STORE = -2;
    private static Logger log = LoggerFactory.getLogger(BundleBinding.class);

    public BundleBinding(ErrorHandling errorHandling, BLOBStore blobStore, StringIndex nsIndex, StringIndex nameIndex, DataStore dataStore) {
        super(errorHandling, blobStore, nsIndex, nameIndex, dataStore);
    }

    public NodePropBundle readBundle(DataInputStream in, NodeId id) throws IOException {
        NodePropBundle bundle = new NodePropBundle(this, id);
        int index = in.readInt();
        int version = index >> 24 & 0xFF;
        String uri = this.nsIndex.indexToString(index &= 0xFFFFFF);
        String local = this.nameIndex.indexToString(in.readInt());
        Name nodeTypeName = NameFactoryImpl.getInstance().create(uri, local);
        bundle.setNodeTypeName(nodeTypeName);
        bundle.setParentId(this.readID(in));
        bundle.setNodeDefId(NodeDefId.valueOf(in.readUTF()));
        HashSet<Name> mixinTypeNames = new HashSet<Name>();
        Name name = this.readIndexedQName(in);
        while (name != null) {
            mixinTypeNames.add(name);
            name = this.readIndexedQName(in);
        }
        bundle.setMixinTypeNames(mixinTypeNames);
        name = this.readIndexedQName(in);
        while (name != null) {
            PropertyId pId = new PropertyId(bundle.getId(), name);
            if (name.equals(NameConstants.JCR_PRIMARYTYPE) || name.equals(NameConstants.JCR_MIXINTYPES) || name.equals(NameConstants.JCR_UUID)) {
                this.readPropertyEntry(in, pId);
                name = this.readIndexedQName(in);
                continue;
            }
            NodePropBundle.PropertyEntry pState = this.readPropertyEntry(in, pId);
            bundle.addProperty(pState);
            name = this.readIndexedQName(in);
        }
        bundle.setReferenceable(in.readBoolean());
        NodeId childId = this.readID(in);
        while (childId != null) {
            bundle.addChildNodeEntry(this.readQName(in), childId);
            childId = this.readID(in);
        }
        if (version >= 1) {
            bundle.setModCount(this.readModCount(in));
        }
        HashSet<NodeId> sharedSet = new HashSet<NodeId>();
        if (version >= 2) {
            NodeId parentId = this.readID(in);
            while (parentId != null) {
                sharedSet.add(parentId);
                parentId = this.readID(in);
            }
        }
        bundle.setSharedSet(sharedSet);
        return bundle;
    }

    public boolean checkBundle(DataInputStream in) {
        int version;
        try {
            int index = in.readInt();
            version = index >> 24 & 0xFF;
            String uri = this.nsIndex.indexToString(index &= 0xFFFFFF);
            String local = this.nameIndex.indexToString(in.readInt());
            Name nodeTypeName = NameFactoryImpl.getInstance().create(uri, local);
            log.debug("Serialzation Version: " + version);
            log.debug("NodeTypeName: " + nodeTypeName);
        }
        catch (IOException e) {
            log.error("Error while reading NodeTypeName: " + e);
            return false;
        }
        try {
            NodeId parentId = this.readID(in);
            log.debug("ParentUUID: " + parentId);
        }
        catch (IOException e) {
            log.error("Error while reading ParentUUID: " + e);
            return false;
        }
        try {
            String definitionId = in.readUTF();
            log.debug("DefinitionId: " + definitionId);
        }
        catch (IOException e) {
            log.error("Error while reading DefinitionId: " + e);
            return false;
        }
        try {
            Name mixinName = this.readIndexedQName(in);
            while (mixinName != null) {
                log.debug("MixinTypeName: " + mixinName);
                mixinName = this.readIndexedQName(in);
            }
        }
        catch (IOException e) {
            log.error("Error while reading MixinTypes: " + e);
            return false;
        }
        try {
            Name propName = this.readIndexedQName(in);
            while (propName != null) {
                log.debug("PropertyName: " + propName);
                if (!this.checkPropertyState(in)) {
                    return false;
                }
                propName = this.readIndexedQName(in);
            }
        }
        catch (IOException e) {
            log.error("Error while reading property names: " + e);
            return false;
        }
        try {
            boolean hasUUID = in.readBoolean();
            log.debug("hasUUID: " + hasUUID);
        }
        catch (IOException e) {
            log.error("Error while reading 'hasUUID': " + e);
            return false;
        }
        try {
            NodeId cneId = this.readID(in);
            while (cneId != null) {
                Name cneName = this.readQName(in);
                log.debug("ChildNodentry: " + cneId + ":" + cneName);
                cneId = this.readID(in);
            }
        }
        catch (IOException e) {
            log.error("Error while reading child node entry: " + e);
            return false;
        }
        if (version >= 1) {
            try {
                short modCount = this.readModCount(in);
                log.debug("modCount: " + modCount);
            }
            catch (IOException e) {
                log.error("Error while reading mod cout: " + e);
                return false;
            }
        }
        return true;
    }

    public void writeBundle(DataOutputStream out, NodePropBundle bundle) throws IOException {
        long size = out.size();
        out.writeInt(0x2000000 | this.nsIndex.stringToIndex(bundle.getNodeTypeName().getNamespaceURI()));
        out.writeInt(this.nameIndex.stringToIndex(bundle.getNodeTypeName().getLocalName()));
        this.writeID(out, bundle.getParentId());
        out.writeUTF(bundle.getNodeDefId().toString());
        for (Name name : bundle.getMixinTypeNames()) {
            this.writeIndexedQName(out, name);
        }
        this.writeIndexedQName(out, null);
        for (Name pName : bundle.getPropertyNames()) {
            if (pName.equals(NameConstants.JCR_PRIMARYTYPE) || pName.equals(NameConstants.JCR_MIXINTYPES) || pName.equals(NameConstants.JCR_UUID)) continue;
            NodePropBundle.PropertyEntry pState = bundle.getPropertyEntry(pName);
            if (pState == null) {
                log.error("PropertyState missing in bundle: " + pName);
                continue;
            }
            this.writeIndexedQName(out, pName);
            this.writeState(out, pState);
        }
        this.writeIndexedQName(out, null);
        out.writeBoolean(bundle.isReferenceable());
        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
            this.writeID(out, entry.getId());
            this.writeQName(out, entry.getName());
        }
        this.writeID(out, null);
        this.writeModCount(out, bundle.getModCount());
        for (NodeId nodeId : bundle.getSharedSet()) {
            this.writeID(out, nodeId);
        }
        this.writeID(out, null);
        bundle.setSize((long)out.size() - size);
    }

    public NodePropBundle.PropertyEntry readPropertyEntry(DataInputStream in, PropertyId id) throws IOException {
        NodePropBundle.PropertyEntry entry = new NodePropBundle.PropertyEntry(id);
        int type = in.readInt();
        entry.setModCount((short)(type >> 16 & 0xFFFF));
        entry.setType(type &= 0xFFFF);
        entry.setMultiValued(in.readBoolean());
        entry.setPropDefId(PropDefId.valueOf(in.readUTF()));
        int count = in.readInt();
        InternalValue[] values = new InternalValue[count];
        String[] blobIds = new String[count];
        for (int i = 0; i < count; ++i) {
            InternalValue val;
            switch (type) {
                case 2: {
                    int size = in.readInt();
                    if (size == -2) {
                        val = InternalValue.create(this.dataStore, in.readUTF());
                        break;
                    }
                    if (size == -1) {
                        blobIds[i] = in.readUTF();
                        try {
                            if (this.blobStore instanceof ResourceBasedBLOBStore) {
                                val = InternalValue.create(((ResourceBasedBLOBStore)this.blobStore).getResource(blobIds[i]));
                                break;
                            }
                            val = InternalValue.create(this.blobStore.get(blobIds[i]));
                            break;
                        }
                        catch (IOException e) {
                            if (this.errorHandling.ignoreMissingBlobs()) {
                                log.warn("Ignoring error while reading blob-resource: " + e);
                                val = InternalValue.create(new byte[0]);
                                break;
                            }
                            throw e;
                        }
                        catch (Exception e) {
                            throw new IOException("Unable to create property value: " + e.toString());
                        }
                    }
                    byte[] data = new byte[size];
                    in.readFully(data);
                    val = InternalValue.create(data);
                    break;
                }
                case 4: {
                    val = InternalValue.create(in.readDouble());
                    break;
                }
                case 12: {
                    val = InternalValue.create(this.readDecimal(in));
                    break;
                }
                case 3: {
                    val = InternalValue.create(in.readLong());
                    break;
                }
                case 6: {
                    val = InternalValue.create(in.readBoolean());
                    break;
                }
                case 7: {
                    val = InternalValue.create(this.readQName(in));
                    break;
                }
                case 9: 
                case 10: {
                    val = InternalValue.create(this.readID(in));
                    break;
                }
                default: {
                    int len = in.readInt();
                    byte[] bytes = new byte[len];
                    in.readFully(bytes);
                    val = InternalValue.valueOf(new String(bytes, "UTF-8"), type);
                }
            }
            values[i] = val;
        }
        entry.setValues(values);
        entry.setBlobIds(blobIds);
        return entry;
    }

    public boolean checkPropertyState(DataInputStream in) {
        int count;
        int type;
        try {
            type = in.readInt();
            short modCount = (short)(type >> 16 | 0xFFFF);
            log.debug("  PropertyType: " + PropertyType.nameFromValue(type &= 0xFFFF));
            log.debug("  ModCount: " + modCount);
        }
        catch (IOException e) {
            log.error("Error while reading property type: " + e);
            return false;
        }
        try {
            boolean isMV = in.readBoolean();
            log.debug("  MultiValued: " + isMV);
        }
        catch (IOException e) {
            log.error("Error while reading multivalued: " + e);
            return false;
        }
        try {
            String defintionId = in.readUTF();
            log.debug("  DefinitionId: " + defintionId);
        }
        catch (IOException e) {
            log.error("Error while reading definition id: " + e);
            return false;
        }
        try {
            count = in.readInt();
            log.debug("  num values: " + count);
        }
        catch (IOException e) {
            log.error("Error while reading number of values: " + e);
            return false;
        }
        block41: for (int i = 0; i < count; ++i) {
            switch (type) {
                case 2: {
                    int size;
                    try {
                        size = in.readInt();
                        log.debug("  binary size: " + size);
                    }
                    catch (IOException e) {
                        log.error("Error while reading size of binary: " + e);
                        return false;
                    }
                    if (size == -2) {
                        try {
                            String s = in.readUTF();
                            if (s.length() > 80) {
                                s = s.substring(80) + "...";
                            }
                            log.debug("  global data store id: " + s);
                            continue block41;
                        }
                        catch (IOException e) {
                            log.error("Error while reading blob id: " + e);
                            return false;
                        }
                    }
                    if (size == -1) {
                        try {
                            String s = in.readUTF();
                            log.debug("  blobid: " + s);
                            continue block41;
                        }
                        catch (IOException e) {
                            log.error("Error while reading blob id: " + e);
                            return false;
                        }
                    }
                    byte[] data = new byte[size];
                    try {
                        in.readFully(data);
                        log.debug("  binary: " + data.length + " bytes");
                        continue block41;
                    }
                    catch (IOException e) {
                        log.error("Error while reading inlined binary: " + e);
                        return false;
                    }
                }
                case 4: {
                    try {
                        double d = in.readDouble();
                        log.debug("  double: " + d);
                        continue block41;
                    }
                    catch (IOException e) {
                        log.error("Error while reading double value: " + e);
                        return false;
                    }
                }
                case 12: {
                    try {
                        BigDecimal d = this.readDecimal(in);
                        log.debug("  decimal: " + d);
                        continue block41;
                    }
                    catch (IOException e) {
                        log.error("Error while reading decimal value: " + e);
                        return false;
                    }
                }
                case 3: {
                    try {
                        double l = in.readLong();
                        log.debug("  long: " + l);
                        continue block41;
                    }
                    catch (IOException e) {
                        log.error("Error while reading long value: " + e);
                        return false;
                    }
                }
                case 6: {
                    try {
                        boolean b = in.readBoolean();
                        log.debug("  boolean: " + b);
                        continue block41;
                    }
                    catch (IOException e) {
                        log.error("Error while reading boolean value: " + e);
                        return false;
                    }
                }
                case 7: {
                    try {
                        Name name = this.readQName(in);
                        log.debug("  name: " + name);
                        continue block41;
                    }
                    catch (IOException e) {
                        log.error("Error while reading name value: " + e);
                        return false;
                    }
                }
                case 9: 
                case 10: {
                    try {
                        NodeId id = this.readID(in);
                        log.debug("  reference: " + id);
                        continue block41;
                    }
                    catch (IOException e) {
                        log.error("Error while reading reference value: " + e);
                        return false;
                    }
                }
                default: {
                    int len;
                    try {
                        len = in.readInt();
                        log.debug("  size of string value: " + len);
                    }
                    catch (IOException e) {
                        log.error("Error while reading size of string value: " + e);
                        return false;
                    }
                    try {
                        byte[] bytes = new byte[len];
                        in.readFully(bytes);
                        String s = new String(bytes, "UTF-8");
                        if (s.length() > 80) {
                            s = s.substring(80) + "...";
                        }
                        log.debug("  string: " + s);
                        continue block41;
                    }
                    catch (IOException e) {
                        log.error("Error while reading string value: " + e);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void writeState(DataOutputStream out, NodePropBundle.PropertyEntry state) throws IOException {
        out.writeInt(state.getType() | state.getModCount() << 16);
        out.writeBoolean(state.isMultiValued());
        out.writeUTF(state.getPropDefId().toString());
        values = state.getValues();
        out.writeInt(values.length);
        block28: for (i = 0; i < values.length; ++i) {
            val = values[i];
            switch (state.getType()) {
                case 2: {
                    try {
                        size = val.getLength();
                        if (this.dataStore != null) {
                            maxMemorySize = this.dataStore.getMinRecordLength() - 1;
                            if (size < (long)maxMemorySize) {
                                this.writeSmallBinary(out, val, state, i);
                                continue block28;
                            }
                            out.writeInt(-2);
                            val.store(this.dataStore);
                            out.writeUTF(val.toString());
                            continue block28;
                        }
                        if (size < 0L) {
                            BundleBinding.log.warn("Blob has negative size. Potential loss of data. id={} idx={}", state.getId(), (Object)String.valueOf(i));
                            out.writeInt(0);
                            values[i] = InternalValue.create(new byte[0]);
                            val.discard();
                            continue block28;
                        }
                        if (size <= this.minBlobSize) ** GOTO lbl55
                        out.writeInt(-1);
                        blobId = state.getBlobId(i);
                        if (blobId != null) ** GOTO lbl53
                        try {
                            in = val.getStream();
                            try {
                                blobId = this.blobStore.createId(state.getId(), i);
                                this.blobStore.put(blobId, in, size);
                                state.setBlobId(blobId, i);
                            }
                            finally {
                                IOUtils.closeQuietly(in);
                            }
                        }
                        catch (Exception e) {
                            msg = "Error while storing blob. id=" + state.getId() + " idx=" + i + " size=" + size;
                            BundleBinding.log.error(msg, e);
                            throw new IOException(msg);
                        }
                        try {
                            values[i] = this.blobStore instanceof ResourceBasedBLOBStore ? InternalValue.create(((ResourceBasedBLOBStore)this.blobStore).getResource(blobId)) : InternalValue.create(this.blobStore.get(blobId));
                        }
                        catch (Exception e) {
                            BundleBinding.log.error("Error while reloading blob. truncating. id=" + state.getId() + " idx=" + i + " size=" + size, e);
                            values[i] = InternalValue.create(new byte[0]);
                        }
                        val.discard();
lbl53:
                        // 2 sources

                        out.writeUTF(blobId);
                        continue block28;
lbl55:
                        // 1 sources

                        data = this.writeSmallBinary(out, val, state, i);
                        values[i] = InternalValue.create(data);
                        val.discard();
                        continue block28;
                    }
                    catch (RepositoryException e) {
                        msg = "Error while storing blob. id=" + state.getId() + " idx=" + i + " value=" + val;
                        BundleBinding.log.error(msg, e);
                        throw new IOException(msg);
                    }
                }
                case 4: {
                    try {
                        out.writeDouble(val.getDouble());
                        continue block28;
                    }
                    catch (RepositoryException e) {
                        throw new IOException("Unexpected error while writing DOUBLE value.");
                    }
                }
                case 12: {
                    try {
                        this.writeDecimal(out, val.getDecimal());
                        continue block28;
                    }
                    catch (RepositoryException e) {
                        throw new IOException("Unexpected error while writing DECIMAL value.");
                    }
                }
                case 3: {
                    try {
                        out.writeLong(val.getLong());
                        continue block28;
                    }
                    catch (RepositoryException e) {
                        throw new IOException("Unexpected error while writing LONG value.");
                    }
                }
                case 6: {
                    try {
                        out.writeBoolean(val.getBoolean());
                        continue block28;
                    }
                    catch (RepositoryException e) {
                        throw new IOException("Unexpected error while writing BOOLEAN value.");
                    }
                }
                case 7: {
                    try {
                        this.writeQName(out, val.getName());
                        continue block28;
                    }
                    catch (RepositoryException e) {
                        throw new IOException("Unexpected error while writing NAME value.");
                    }
                }
                case 9: 
                case 10: {
                    this.writeID(out, val.getNodeId());
                    continue block28;
                }
                default: {
                    bytes = val.toString().getBytes("UTF-8");
                    out.writeInt(bytes.length);
                    out.write(bytes);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeSmallBinary(DataOutputStream out, InternalValue value, NodePropBundle.PropertyEntry state, int i) throws IOException {
        try {
            int size = (int)value.getLength();
            out.writeInt(size);
            byte[] data = new byte[size];
            DataInputStream in = new DataInputStream(value.getStream());
            try {
                in.readFully(data);
            }
            finally {
                IOUtils.closeQuietly(in);
            }
            out.write(data, 0, data.length);
            return data;
        }
        catch (Exception e) {
            String msg = "Error while storing blob. id=" + state.getId() + " idx=" + i + " value=" + value;
            log.error(msg, e);
            throw new IOException(msg);
        }
    }
}

