/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.jackrabbit.core.observation.DispatchAction;
import org.apache.jackrabbit.core.observation.EventConsumer;
import org.apache.jackrabbit.core.observation.EventDispatcher;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObservationDispatcher
extends EventDispatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ObservationDispatcher.class);
    private static final DispatchAction DISPOSE_MARKER = new DispatchAction(null, null);
    private Set<EventConsumer> activeConsumers = new HashSet<EventConsumer>();
    private Set<EventConsumer> synchronousConsumers = new HashSet<EventConsumer>();
    private Set<EventConsumer> readOnlyConsumers;
    private Set<EventConsumer> synchronousReadOnlyConsumers;
    private Object consumerChange = new Object();
    private Buffer eventQueue = BufferUtils.blockingBuffer(new UnboundedFifoBuffer());
    private Thread notificationThread = new Thread((Runnable)this, "ObservationManager");

    public ObservationDispatcher() {
        this.notificationThread.setDaemon(true);
        this.notificationThread.start();
    }

    public void dispose() {
        this.eventQueue.add(DISPOSE_MARKER);
        try {
            this.notificationThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.info("Notification of EventListeners stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<EventConsumer> getAsynchronousConsumers() {
        Object object = this.consumerChange;
        synchronized (object) {
            if (this.readOnlyConsumers == null) {
                this.readOnlyConsumers = Collections.unmodifiableSet(new HashSet<EventConsumer>(this.activeConsumers));
            }
            return this.readOnlyConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<EventConsumer> getSynchronousConsumers() {
        Object object = this.consumerChange;
        synchronized (object) {
            if (this.synchronousReadOnlyConsumers == null) {
                this.synchronousReadOnlyConsumers = Collections.unmodifiableSet(new HashSet<EventConsumer>(this.synchronousConsumers));
            }
            return this.synchronousReadOnlyConsumers;
        }
    }

    @Override
    public void run() {
        DispatchAction action;
        while ((action = (DispatchAction)this.eventQueue.remove()) != DISPOSE_MARKER) {
            log.debug("got EventStateCollection");
            log.debug("event delivery to " + action.getEventConsumers().size() + " consumers started...");
            for (EventConsumer c : action.getEventConsumers()) {
                try {
                    c.consumeEvents(action.getEventStates());
                }
                catch (Throwable t) {
                    log.warn("EventConsumer threw exception: " + t.toString());
                    log.debug("Stacktrace: ", t);
                }
            }
            log.debug("event delivery finished.");
        }
    }

    @Override
    void prepareEvents(EventStateCollection events) {
        HashSet<EventConsumer> consumers = new HashSet<EventConsumer>();
        consumers.addAll(this.getSynchronousConsumers());
        consumers.addAll(this.getAsynchronousConsumers());
        for (EventConsumer c : consumers) {
            c.prepareEvents(events);
        }
    }

    @Override
    void prepareDeleted(EventStateCollection events, ChangeLog changes) {
        HashSet<EventConsumer> consumers = new HashSet<EventConsumer>();
        consumers.addAll(this.getSynchronousConsumers());
        consumers.addAll(this.getAsynchronousConsumers());
        for (EventConsumer c : consumers) {
            c.prepareDeleted(events, changes.deletedStates());
        }
    }

    @Override
    void dispatchEvents(EventStateCollection events) {
        Set<EventConsumer> synchronous = this.getSynchronousConsumers();
        if (log.isDebugEnabled()) {
            log.debug("notifying " + synchronous.size() + " synchronous listeners.");
        }
        for (EventConsumer c : synchronous) {
            try {
                c.consumeEvents(events);
            }
            catch (Throwable t) {
                log.error("Synchronous EventConsumer threw exception.", t);
            }
        }
        this.eventQueue.add(new DispatchAction(events, this.getAsynchronousConsumers()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(EventConsumer consumer) {
        Object object = this.consumerChange;
        synchronized (object) {
            if (consumer.getEventListener() instanceof SynchronousEventListener) {
                this.synchronousConsumers.remove(consumer);
                this.synchronousConsumers.add(consumer);
                this.synchronousReadOnlyConsumers = null;
            } else {
                this.activeConsumers.remove(consumer);
                this.activeConsumers.add(consumer);
                this.readOnlyConsumers = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumer(EventConsumer consumer) {
        Object object = this.consumerChange;
        synchronized (object) {
            if (consumer.getEventListener() instanceof SynchronousEventListener) {
                this.synchronousConsumers.remove(consumer);
                this.synchronousReadOnlyConsumers = null;
            } else {
                this.activeConsumers.remove(consumer);
                this.readOnlyConsumers = null;
            }
        }
    }
}

