/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.ItemDef;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefImpl;
import org.apache.jackrabbit.core.nodetype.xml.AdditionalNamespaceResolver;
import org.apache.jackrabbit.core.util.DOMWalker;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.value.InternalValueFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.value.ValueHelper;

public class NodeTypeReader {
    private final DOMWalker walker;
    private final Properties namespaces;
    private final NamePathResolver resolver;
    private final ValueFactory valueFactory;
    private final QValueFactory qValueFactory = InternalValueFactory.getInstance();

    public static NodeTypeDef[] read(InputStream xml) throws IOException, InvalidNodeTypeDefException {
        try {
            NodeTypeReader reader = new NodeTypeReader(xml);
            return reader.getNodeTypeDefs();
        }
        catch (NameException e) {
            throw new InvalidNodeTypeDefException("Invalid namespace reference in a node type definition", e);
        }
        catch (NamespaceException e) {
            throw new InvalidNodeTypeDefException("Invalid namespace reference in a node type definition", e);
        }
    }

    public NodeTypeReader(InputStream xml) throws IOException {
        this.walker = new DOMWalker(xml);
        this.namespaces = this.walker.getNamespaces();
        AdditionalNamespaceResolver nsResolver = new AdditionalNamespaceResolver(this.namespaces);
        this.resolver = new DefaultNamePathResolver(nsResolver);
        this.valueFactory = new ValueFactoryQImpl(this.qValueFactory, this.resolver);
    }

    public Properties getNamespaces() {
        return this.namespaces;
    }

    public NodeTypeDef[] getNodeTypeDefs() throws InvalidNodeTypeDefException, NameException, NamespaceException {
        ArrayList<NodeTypeDef> defs = new ArrayList<NodeTypeDef>();
        while (this.walker.iterateElements("nodeType")) {
            defs.add(this.getNodeTypeDef());
        }
        return defs.toArray(new NodeTypeDef[defs.size()]);
    }

    private NodeTypeDef getNodeTypeDef() throws InvalidNodeTypeDefException, NameException, NamespaceException {
        String primaryItemName;
        NodeTypeDef type = new NodeTypeDef();
        type.setName(this.resolver.getQName(this.walker.getAttribute("name")));
        type.setMixin(Boolean.valueOf(this.walker.getAttribute("isMixin")));
        type.setOrderableChildNodes(Boolean.valueOf(this.walker.getAttribute("hasOrderableChildNodes")));
        type.setAbstract(Boolean.valueOf(this.walker.getAttribute("isAbstract")));
        if (this.walker.getAttribute("isQueryable") != null) {
            type.setQueryable(Boolean.valueOf(this.walker.getAttribute("isQueryable")));
        }
        if ((primaryItemName = this.walker.getAttribute("primaryItemName")) != null && primaryItemName.length() > 0) {
            type.setPrimaryItemName(this.resolver.getQName(primaryItemName));
        }
        if (this.walker.enterElement("supertypes")) {
            ArrayList<Name> supertypes = new ArrayList<Name>();
            while (this.walker.iterateElements("supertype")) {
                supertypes.add(this.resolver.getQName(this.walker.getContent()));
            }
            type.setSupertypes(supertypes.toArray(new Name[supertypes.size()]));
            this.walker.leaveElement();
        }
        ArrayList<PropDefImpl> properties = new ArrayList<PropDefImpl>();
        while (this.walker.iterateElements("propertyDefinition")) {
            PropDefImpl def = this.getPropDef();
            def.setDeclaringNodeType(type.getName());
            properties.add(def);
        }
        type.setPropertyDefs(properties.toArray(new PropDef[properties.size()]));
        ArrayList<NodeDefImpl> nodes = new ArrayList<NodeDefImpl>();
        while (this.walker.iterateElements("childNodeDefinition")) {
            NodeDefImpl def = this.getChildNodeDef();
            def.setDeclaringNodeType(type.getName());
            nodes.add(def);
        }
        type.setChildNodeDefs(nodes.toArray(new NodeDef[nodes.size()]));
        return type;
    }

    private PropDefImpl getPropDef() throws InvalidNodeTypeDefException, NameException, NamespaceException {
        PropDefImpl def = new PropDefImpl();
        String name = this.walker.getAttribute("name");
        if (name.equals("*")) {
            def.setName(ItemDef.ANY_NAME);
        } else {
            def.setName(this.resolver.getQName(name));
        }
        def.setAutoCreated(Boolean.valueOf(this.walker.getAttribute("autoCreated")));
        def.setMandatory(Boolean.valueOf(this.walker.getAttribute("mandatory")));
        def.setProtected(Boolean.valueOf(this.walker.getAttribute("protected")));
        def.setOnParentVersion(OnParentVersionAction.valueFromName(this.walker.getAttribute("onParentVersion")));
        def.setMultiple(Boolean.valueOf(this.walker.getAttribute("multiple")));
        def.setFullTextSearchable(Boolean.valueOf(this.walker.getAttribute("isFullTextSearchable")));
        def.setQueryOrderable(Boolean.valueOf(this.walker.getAttribute("isQueryOrderable")));
        String s = this.walker.getAttribute("availableQueryOperators");
        if (s != null && s.length() > 0) {
            String[] ops = s.split(" ");
            ArrayList<String> queryOps = new ArrayList<String>();
            for (String op1 : ops) {
                String op = op1.trim();
                if (op.equals("OP_EQ")) {
                    queryOps.add("jcr.operator.equal.to");
                    continue;
                }
                if (op.equals("OP_NE")) {
                    queryOps.add("jcr.operator.not.equal.to");
                    continue;
                }
                if (op.equals("OP_LT")) {
                    queryOps.add("jcr.operator.less.than");
                    continue;
                }
                if (op.equals("OP_LE")) {
                    queryOps.add("jcr.operator.less.than.or.equal.to");
                    continue;
                }
                if (op.equals("OP_GT")) {
                    queryOps.add("jcr.operator.greater.than");
                    continue;
                }
                if (op.equals("OP_GE")) {
                    queryOps.add("jcr.operator.greater.than.or.equal.to");
                    continue;
                }
                if (op.equals("OP_LIKE")) {
                    queryOps.add("jcr.operator.like");
                    continue;
                }
                throw new InvalidNodeTypeDefException("'" + op + "' is not a valid query operator");
            }
            def.setAvailableQueryOperators(queryOps.toArray(new String[queryOps.size()]));
        }
        def.setRequiredType(PropertyType.valueFromName(this.walker.getAttribute("requiredType")));
        if (this.walker.enterElement("valueConstraints")) {
            ArrayList<ValueConstraint> constraints = new ArrayList<ValueConstraint>();
            int type = def.getRequiredType();
            while (this.walker.iterateElements("valueConstraint")) {
                String constraint = this.walker.getContent();
                try {
                    constraints.add(ValueConstraint.create(type, constraint.trim(), this.resolver));
                }
                catch (InvalidConstraintException e) {
                    throw new InvalidNodeTypeDefException("Invalid value constraint " + constraint, e);
                }
            }
            def.setValueConstraints(constraints.toArray(new QValueConstraint[constraints.size()]));
            this.walker.leaveElement();
        }
        if (this.walker.enterElement("defaultValues")) {
            ArrayList<InternalValue> values = new ArrayList<InternalValue>();
            int type = def.getRequiredType();
            if (type == 0) {
                type = 1;
            }
            while (this.walker.iterateElements("defaultValue")) {
                String value = this.walker.getContent();
                try {
                    Value v = ValueHelper.convert(value, type, this.valueFactory);
                    values.add((InternalValue)ValueFormat.getQValue(v, this.resolver, this.qValueFactory));
                }
                catch (RepositoryException e) {
                    throw new InvalidNodeTypeDefException("Unable to create default value: " + value, e);
                }
            }
            def.setDefaultValues(values.toArray(new InternalValue[values.size()]));
            this.walker.leaveElement();
        }
        return def;
    }

    private NodeDefImpl getChildNodeDef() throws NameException, NamespaceException {
        NodeDefImpl def = new NodeDefImpl();
        String name = this.walker.getAttribute("name");
        if (name.equals("*")) {
            def.setName(ItemDef.ANY_NAME);
        } else {
            def.setName(this.resolver.getQName(name));
        }
        def.setAutoCreated(Boolean.valueOf(this.walker.getAttribute("autoCreated")));
        def.setMandatory(Boolean.valueOf(this.walker.getAttribute("mandatory")));
        def.setProtected(Boolean.valueOf(this.walker.getAttribute("protected")));
        def.setOnParentVersion(OnParentVersionAction.valueFromName(this.walker.getAttribute("onParentVersion")));
        def.setAllowsSameNameSiblings(Boolean.valueOf(this.walker.getAttribute("sameNameSiblings")));
        String type = this.walker.getAttribute("defaultPrimaryType");
        if (type != null && type.length() > 0) {
            def.setDefaultPrimaryType(this.resolver.getQName(type));
        }
        if (this.walker.enterElement("requiredPrimaryTypes")) {
            ArrayList<Name> types = new ArrayList<Name>();
            while (this.walker.iterateElements("requiredPrimaryType")) {
                types.add(this.resolver.getQName(this.walker.getContent()));
            }
            def.setRequiredPrimaryTypes(types.toArray(new Name[types.size()]));
            this.walker.leaveElement();
        }
        return def;
    }
}

