/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.Arrays;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.nodetype.ItemDefImpl;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.QPropertyDefinitionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.Operator;

public class PropDefImpl
extends ItemDefImpl
implements PropDef {
    private int requiredType = 0;
    private QValueConstraint[] valueConstraints = QValueConstraint.EMPTY_ARRAY;
    private InternalValue[] defaultValues = InternalValue.EMPTY_ARRAY;
    private boolean multiple = false;
    private PropDefId id = null;
    private boolean fullTextSearchable = true;
    private boolean queryOrderable = true;
    private String[] queryOperators = Operator.getAllQueryOperators();

    public PropDefImpl() {
    }

    public PropDefImpl(QPropertyDefinition pd) {
        super(pd);
        this.requiredType = pd.getRequiredType();
        this.valueConstraints = pd.getValueConstraints();
        QValue[] vs = pd.getDefaultValues();
        if (vs != null) {
            this.defaultValues = new InternalValue[vs.length];
            for (int i = 0; i < vs.length; ++i) {
                try {
                    this.defaultValues[i] = InternalValue.create(vs[i]);
                    continue;
                }
                catch (RepositoryException e) {
                    throw new IllegalStateException("Error while converting default values.", e);
                }
            }
        }
        this.multiple = pd.isMultiple();
        this.fullTextSearchable = pd.isFullTextSearchable();
        this.queryOrderable = pd.isQueryOrderable();
        this.queryOperators = pd.getAvailableQueryOperators();
    }

    public QPropertyDefinition getQPropertyDefinition() {
        return new QPropertyDefinitionImpl(this.getName(), this.getDeclaringNodeType(), this.isAutoCreated(), this.isMandatory(), this.getOnParentVersion(), this.isProtected(), this.getDefaultValues(), this.isMultiple(), this.getRequiredType(), this.getValueConstraints(), this.getAvailableQueryOperators(), this.isFullTextSearchable(), this.isQueryOrderable());
    }

    public void setRequiredType(int requiredType) {
        this.id = null;
        this.requiredType = requiredType;
    }

    public void setValueConstraints(QValueConstraint[] valueConstraints) {
        this.id = null;
        this.valueConstraints = valueConstraints != null ? valueConstraints : QValueConstraint.EMPTY_ARRAY;
    }

    public void setDefaultValues(InternalValue[] defaultValues) {
        this.id = null;
        this.defaultValues = defaultValues != null ? defaultValues : InternalValue.EMPTY_ARRAY;
    }

    public void setMultiple(boolean multiple) {
        this.id = null;
        this.multiple = multiple;
    }

    public void setFullTextSearchable(boolean fullTextSearchable) {
        this.id = null;
        this.fullTextSearchable = fullTextSearchable;
    }

    public void setQueryOrderable(boolean queryOrderable) {
        this.id = null;
        this.queryOrderable = queryOrderable;
    }

    public void setAvailableQueryOperators(String[] queryOperators) {
        this.id = null;
        this.queryOperators = queryOperators != null ? queryOperators : new String[0];
    }

    public void setDeclaringNodeType(Name declaringNodeType) {
        this.id = null;
        super.setDeclaringNodeType(declaringNodeType);
    }

    public void setName(Name name) {
        this.id = null;
        super.setName(name);
    }

    public void setAutoCreated(boolean autoCreated) {
        this.id = null;
        super.setAutoCreated(autoCreated);
    }

    public void setOnParentVersion(int onParentVersion) {
        this.id = null;
        super.setOnParentVersion(onParentVersion);
    }

    public void setProtected(boolean writeProtected) {
        this.id = null;
        super.setProtected(writeProtected);
    }

    public void setMandatory(boolean mandatory) {
        this.id = null;
        super.setMandatory(mandatory);
    }

    public PropDefId getId() {
        if (this.id == null) {
            this.id = new PropDefId(this);
        }
        return this.id;
    }

    public int getRequiredType() {
        return this.requiredType;
    }

    public QValueConstraint[] getValueConstraints() {
        return this.valueConstraints;
    }

    public InternalValue[] getDefaultValues() {
        return this.defaultValues;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean definesNode() {
        return false;
    }

    public String[] getAvailableQueryOperators() {
        return this.queryOperators;
    }

    public boolean isFullTextSearchable() {
        return this.fullTextSearchable;
    }

    public boolean isQueryOrderable() {
        return this.queryOrderable;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PropDefImpl) {
            PropDefImpl other = (PropDefImpl)obj;
            return super.equals(obj) && this.requiredType == other.requiredType && Arrays.equals(this.valueConstraints, other.valueConstraints) && Arrays.equals(this.defaultValues, other.defaultValues) && this.multiple == other.multiple && Arrays.equals(this.queryOperators, other.queryOperators) && this.queryOrderable == other.queryOrderable && this.fullTextSearchable == other.fullTextSearchable;
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

