/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.cluster.NodeTypeEventChannel;
import org.apache.jackrabbit.core.cluster.NodeTypeEventListener;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.nodetype.BitsetENTCacheImpl;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.NodeDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeDefDiff;
import org.apache.jackrabbit.core.nodetype.NodeTypeDefStore;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeRegistry
implements Dumpable,
NodeTypeEventListener {
    private static Logger log = LoggerFactory.getLogger(NodeTypeRegistry.class);
    private static final String BUILTIN_NODETYPES_RESOURCE_PATH = "org/apache/jackrabbit/core/nodetype/builtin_nodetypes.cnd";
    private static final String CUSTOM_NODETYPES_RESOURCE_NAME = "custom_nodetypes.xml";
    private final FileSystem ntStore;
    private final FileSystemResource customNodeTypesResource;
    private final NodeTypeDefStore builtInNTDefs;
    private final NodeTypeDefStore customNTDefs;
    private EffectiveNodeTypeCache entCache;
    private final Map<Name, NodeTypeDef> registeredNTDefs;
    private final NodeDef rootNodeDef;
    private final Map<PropDefId, PropDef> propDefs;
    private final Map<NodeDefId, NodeDef> nodeDefs;
    private final NamespaceRegistry nsReg;
    private final Map<NodeTypeRegistryListener, NodeTypeRegistryListener> listeners = Collections.synchronizedMap(new ReferenceMap(2, 2));
    private NodeTypeEventChannel eventChannel;

    public static NodeTypeRegistry create(NamespaceRegistry nsReg, FileSystem ntStore) throws RepositoryException {
        NodeTypeRegistry ntMgr = new NodeTypeRegistry(nsReg, ntStore);
        return ntMgr;
    }

    public Name[] getRegisteredNodeTypes() {
        return this.registeredNTDefs.keySet().toArray(new Name[this.registeredNTDefs.size()]);
    }

    public synchronized EffectiveNodeType registerNodeType(NodeTypeDef ntd) throws InvalidNodeTypeDefException, RepositoryException {
        EffectiveNodeType ent = this.internalRegister(ntd);
        this.customNTDefs.add(ntd);
        this.persistCustomNodeTypeDefs(this.customNTDefs);
        if (this.eventChannel != null) {
            HashSet<NodeTypeDef> ntDefs = new HashSet<NodeTypeDef>();
            ntDefs.add(ntd);
            this.eventChannel.registered(ntDefs);
        }
        this.notifyRegistered(ntd.getName());
        return ent;
    }

    public void registerNodeTypes(Collection<NodeTypeDef> ntDefs) throws InvalidNodeTypeDefException, RepositoryException {
        this.registerNodeTypes(ntDefs, false);
    }

    private synchronized void registerNodeTypes(Collection<NodeTypeDef> ntDefs, boolean external) throws InvalidNodeTypeDefException, RepositoryException {
        this.internalRegister(ntDefs);
        for (NodeTypeDef ntDef : ntDefs) {
            this.customNTDefs.add(ntDef);
        }
        this.persistCustomNodeTypeDefs(this.customNTDefs);
        if (!external && this.eventChannel != null) {
            this.eventChannel.registered(ntDefs);
        }
        for (NodeTypeDef ntDef : ntDefs) {
            this.notifyRegistered(ntDef.getName());
        }
    }

    public void unregisterNodeTypes(Collection<Name> ntNames) throws NoSuchNodeTypeException, RepositoryException {
        this.unregisterNodeTypes(ntNames, false);
    }

    private synchronized void unregisterNodeTypes(Collection<Name> ntNames, boolean external) throws NoSuchNodeTypeException, RepositoryException {
        for (Name ntName : ntNames) {
            if (!this.registeredNTDefs.containsKey(ntName)) {
                throw new NoSuchNodeTypeException(ntName.toString());
            }
            if (this.builtInNTDefs.contains(ntName)) {
                throw new RepositoryException(ntName.toString() + ": can't unregister built-in node type.");
            }
            Set<Name> dependents = this.getDependentNodeTypes(ntName);
            dependents.removeAll(ntNames);
            if (dependents.size() <= 0) continue;
            StringBuffer msg = new StringBuffer();
            msg.append(ntName).append(" can not be removed because the following node types depend on it: ");
            for (Name dependent : dependents) {
                msg.append(dependent);
                msg.append(" ");
            }
            throw new RepositoryException(msg.toString());
        }
        for (Name ntName : ntNames) {
            this.checkForReferencesInContent(ntName);
        }
        this.internalUnregister(ntNames);
        if (!external && this.eventChannel != null) {
            this.eventChannel.unregistered(ntNames);
        }
        for (Name ntName : ntNames) {
            this.customNTDefs.remove(ntName);
            this.notifyUnregistered(ntName);
        }
        this.persistCustomNodeTypeDefs(this.customNTDefs);
    }

    public void unregisterNodeType(Name ntName) throws NoSuchNodeTypeException, RepositoryException {
        HashSet<Name> ntNames = new HashSet<Name>();
        ntNames.add(ntName);
        this.unregisterNodeTypes(ntNames);
    }

    public EffectiveNodeType reregisterNodeType(NodeTypeDef ntd) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        return this.reregisterNodeType(ntd, false);
    }

    private synchronized EffectiveNodeType reregisterNodeType(NodeTypeDef ntd, boolean external) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        Name name = ntd.getName();
        if (!this.registeredNTDefs.containsKey(name)) {
            throw new NoSuchNodeTypeException(name.toString());
        }
        if (this.builtInNTDefs.contains(name)) {
            throw new RepositoryException(name.toString() + ": can't reregister built-in node type.");
        }
        NodeTypeRegistry.checkNtBaseSubtyping(ntd, this.registeredNTDefs);
        NodeTypeRegistry.validateNodeTypeDef(ntd, this.entCache, this.registeredNTDefs, this.nsReg, false);
        NodeTypeDef ntdOld = this.registeredNTDefs.get(name);
        NodeTypeDefDiff diff = NodeTypeDefDiff.create(ntdOld, ntd);
        if (!diff.isModified()) {
            return this.getEffectiveNodeType(name);
        }
        if (diff.isTrivial()) {
            this.internalUnregister(name);
            this.customNTDefs.remove(name);
            EffectiveNodeType entNew = this.internalRegister(ntd);
            this.customNTDefs.add(ntd);
            this.persistCustomNodeTypeDefs(this.customNTDefs);
            if (!external && this.eventChannel != null) {
                this.eventChannel.reregistered(ntd);
            }
            this.notifyReRegistered(name);
            return entNew;
        }
        String message = "The following nodetype change contains non-trivial changes.Up until now only trivial changes are supported. (see javadoc for " + NodeTypeDefDiff.class.getName() + "):\n" + diff.toString();
        throw new RepositoryException(message);
    }

    public EffectiveNodeType getEffectiveNodeType(Name ntName) throws NoSuchNodeTypeException {
        return NodeTypeRegistry.getEffectiveNodeType(ntName, this.entCache, this.registeredNTDefs);
    }

    public EffectiveNodeType getEffectiveNodeType(Name primary, Set<Name> mixins) throws NodeTypeConflictException, NoSuchNodeTypeException {
        if (mixins.isEmpty()) {
            return this.getEffectiveNodeType(primary);
        }
        Name[] names = new Name[mixins.size() + 1];
        mixins.toArray(names);
        names[names.length - 1] = primary;
        return NodeTypeRegistry.getEffectiveNodeType(names, this.entCache, this.registeredNTDefs);
    }

    public Set<Name> getDependentNodeTypes(Name nodeTypeName) throws NoSuchNodeTypeException {
        if (!this.registeredNTDefs.containsKey(nodeTypeName)) {
            throw new NoSuchNodeTypeException(nodeTypeName.toString());
        }
        HashSet<Name> names = new HashSet<Name>();
        for (NodeTypeDef ntd : this.registeredNTDefs.values()) {
            if (!ntd.getDependencies().contains(nodeTypeName)) continue;
            names.add(ntd.getName());
        }
        return names;
    }

    public NodeTypeDef getNodeTypeDef(Name nodeTypeName) throws NoSuchNodeTypeException {
        NodeTypeDef def = this.registeredNTDefs.get(nodeTypeName);
        if (def == null) {
            throw new NoSuchNodeTypeException(nodeTypeName.toString());
        }
        return (NodeTypeDef)def.clone();
    }

    public boolean isRegistered(Name nodeTypeName) {
        return this.registeredNTDefs.containsKey(nodeTypeName);
    }

    public boolean isBuiltIn(Name nodeTypeName) {
        return this.builtInNTDefs.contains(nodeTypeName);
    }

    public NodeDef getNodeDef(NodeDefId id) {
        return this.nodeDefs.get(id);
    }

    public PropDef getPropDef(PropDefId id) {
        return this.propDefs.get(id);
    }

    public void addListener(NodeTypeRegistryListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    public void removeListener(NodeTypeRegistryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("NodeTypeRegistry (" + this + ")");
        ps.println();
        ps.println("Registered NodeTypes:");
        ps.println();
        for (NodeTypeDef ntd : this.registeredNTDefs.values()) {
            NodeDef[] nd;
            PropDef[] pd;
            ps.println(ntd.getName());
            Name[] supertypes = ntd.getSupertypes();
            ps.println("\tSupertypes");
            for (Name supertype : supertypes) {
                ps.println("\t\t" + supertype);
            }
            ps.println("\tMixin\t" + ntd.isMixin());
            ps.println("\tOrderableChildNodes\t" + ntd.hasOrderableChildNodes());
            ps.println("\tPrimaryItemName\t" + (ntd.getPrimaryItemName() == null ? "<null>" : ntd.getPrimaryItemName().toString()));
            for (PropDef aPd : pd = ntd.getPropertyDefs()) {
                ps.print("\tPropertyDefinition");
                ps.println(" (declared in " + aPd.getDeclaringNodeType() + ") id=" + aPd.getId());
                ps.println("\t\tName\t\t" + (aPd.definesResidual() ? "*" : aPd.getName().toString()));
                String type = aPd.getRequiredType() == 0 ? "null" : PropertyType.nameFromValue(aPd.getRequiredType());
                ps.println("\t\tRequiredType\t" + type);
                QValueConstraint[] vca = aPd.getValueConstraints();
                StringBuffer constraints = new StringBuffer();
                if (vca == null) {
                    constraints.append("<null>");
                } else {
                    for (QValueConstraint aVca : vca) {
                        if (constraints.length() > 0) {
                            constraints.append(", ");
                        }
                        constraints.append(aVca.getString());
                    }
                }
                ps.println("\t\tValueConstraints\t" + constraints.toString());
                InternalValue[] defVals = aPd.getDefaultValues();
                StringBuffer defaultValues = new StringBuffer();
                if (defVals == null) {
                    defaultValues.append("<null>");
                } else {
                    for (InternalValue defVal : defVals) {
                        if (defaultValues.length() > 0) {
                            defaultValues.append(", ");
                        }
                        defaultValues.append(defVal.toString());
                    }
                }
                ps.println("\t\tDefaultValue\t" + defaultValues.toString());
                ps.println("\t\tAutoCreated\t" + aPd.isAutoCreated());
                ps.println("\t\tMandatory\t" + aPd.isMandatory());
                ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue(aPd.getOnParentVersion()));
                ps.println("\t\tProtected\t" + aPd.isProtected());
                ps.println("\t\tMultiple\t" + aPd.isMultiple());
            }
            for (NodeDef aNd : nd = ntd.getChildNodeDefs()) {
                Name defPrimaryType;
                ps.print("\tNodeDefinition");
                ps.println(" (declared in " + aNd.getDeclaringNodeType() + ") id=" + aNd.getId());
                ps.println("\t\tName\t\t" + (aNd.definesResidual() ? "*" : aNd.getName().toString()));
                Name[] reqPrimaryTypes = aNd.getRequiredPrimaryTypes();
                if (reqPrimaryTypes != null && reqPrimaryTypes.length > 0) {
                    for (Name reqPrimaryType : reqPrimaryTypes) {
                        ps.print("\t\tRequiredPrimaryType\t" + reqPrimaryType);
                    }
                }
                if ((defPrimaryType = aNd.getDefaultPrimaryType()) != null) {
                    ps.print("\n\t\tDefaultPrimaryType\t" + defPrimaryType);
                }
                ps.println("\n\t\tAutoCreated\t" + aNd.isAutoCreated());
                ps.println("\t\tMandatory\t" + aNd.isMandatory());
                ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue(aNd.getOnParentVersion()));
                ps.println("\t\tProtected\t" + aNd.isProtected());
                ps.println("\t\tAllowsSameNameSiblings\t" + aNd.allowsSameNameSiblings());
            }
        }
        ps.println();
        this.entCache.dump(ps);
    }

    public void externalRegistered(Collection ntDefs) throws RepositoryException, InvalidNodeTypeDefException {
        this.registerNodeTypes(ntDefs, true);
    }

    @Override
    public void externalReregistered(NodeTypeDef ntDef) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        this.reregisterNodeType(ntDef, true);
    }

    public void externalUnregistered(Collection ntNames) throws RepositoryException, NoSuchNodeTypeException {
        this.unregisterNodeTypes(ntNames, true);
    }

    protected NodeTypeRegistry(NamespaceRegistry nsReg, FileSystem ntStore) throws RepositoryException {
        this.nsReg = nsReg;
        this.ntStore = ntStore;
        this.customNodeTypesResource = new FileSystemResource(this.ntStore, CUSTOM_NODETYPES_RESOURCE_NAME);
        try {
            if (!this.customNodeTypesResource.exists()) {
                this.customNodeTypesResource.makeParentDirs();
            }
        }
        catch (FileSystemException fse) {
            String error = "internal error: invalid resource: " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, fse);
        }
        this.entCache = new BitsetENTCacheImpl();
        this.registeredNTDefs = new ConcurrentReaderHashMap();
        this.propDefs = new ConcurrentReaderHashMap();
        this.nodeDefs = new ConcurrentReaderHashMap();
        this.rootNodeDef = NodeTypeRegistry.createRootNodeDef();
        this.nodeDefs.put(this.rootNodeDef.getId(), this.rootNodeDef);
        this.builtInNTDefs = new NodeTypeDefStore();
        try {
            this.loadBuiltInNodeTypeDefs(this.builtInNTDefs);
            this.internalRegister(this.builtInNTDefs.all(), true);
        }
        catch (InvalidNodeTypeDefException intde) {
            String error = "internal error: invalid built-in node type definition stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.cnd";
            log.debug(error);
            throw new RepositoryException(error, intde);
        }
        this.customNTDefs = new NodeTypeDefStore();
        this.loadCustomNodeTypeDefs(this.customNTDefs);
        try {
            this.internalRegister(this.customNTDefs.all());
        }
        catch (InvalidNodeTypeDefException intde) {
            String error = "internal error: invalid custom node type definition stored in " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, intde);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadBuiltInNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        InputStream in = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream(BUILTIN_NODETYPES_RESOURCE_PATH);
            if (in != null) {
                InputStreamReader r = new InputStreamReader(in, "utf-8");
                store.loadCND(r, BUILTIN_NODETYPES_RESOURCE_PATH);
            }
        }
        catch (IOException ioe) {
            try {
                String error = "internal error: failed to read built-in node type definitions stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.cnd";
                log.debug(error);
                throw new RepositoryException(error, ioe);
                catch (InvalidNodeTypeDefException intde) {
                    error = "internal error: invalid built-in node type definition stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.cnd";
                    log.debug(error);
                    throw new RepositoryException(error, intde);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
    }

    protected void loadCustomNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        InputStream in = null;
        try {
            if (this.customNodeTypesResource.exists()) {
                in = this.customNodeTypesResource.getInputStream();
            }
        }
        catch (FileSystemException fse) {
            String error = "internal error: failed to access custom node type definitions stored in " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, fse);
        }
        if (in == null) {
            log.info("no custom node type definitions found");
        } else {
            try {
                store.load(in);
            }
            catch (IOException ioe) {
                String error = "internal error: failed to read custom node type definitions stored in " + this.customNodeTypesResource.getPath();
                log.debug(error);
                throw new RepositoryException(error, ioe);
            }
            catch (InvalidNodeTypeDefException intde) {
                String error = "internal error: invalid custom node type definition stored in " + this.customNodeTypesResource.getPath();
                log.debug(error);
                throw new RepositoryException(error, intde);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistCustomNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        try {
            OutputStream out = this.customNodeTypesResource.getOutputStream();
            try {
                store.store(out, this.nsReg);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ioe) {
            String error = "internal error: failed to persist custom node type definitions to " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, ioe);
        }
        catch (FileSystemException fse) {
            String error = "internal error: failed to persist custom node type definitions to " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, fse);
        }
    }

    protected void checkForConflictingContent(NodeTypeDef ntd) throws RepositoryException {
        throw new RepositoryException("not yet implemented");
    }

    protected void checkForReferencesInContent(Name nodeTypeName) throws RepositoryException {
        throw new RepositoryException("not yet implemented");
    }

    public NodeDef getRootNodeDef() {
        return this.rootNodeDef;
    }

    public void setEventChannel(NodeTypeEventChannel eventChannel) {
        this.eventChannel = eventChannel;
        eventChannel.setListener(this);
    }

    static EffectiveNodeType getEffectiveNodeType(Name ntName, EffectiveNodeTypeCache entCache, Map<Name, NodeTypeDef> ntdCache) throws NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(new Name[]{ntName});
        EffectiveNodeType ent = entCache.get(key);
        if (ent != null) {
            return ent;
        }
        NodeTypeDef ntd = ntdCache.get(ntName);
        if (ntd == null) {
            throw new NoSuchNodeTypeException(ntName.toString());
        }
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            try {
                ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
                entCache.put(ent);
                return ent;
            }
            catch (NodeTypeConflictException ntce) {
                String msg = "internal error: encountered invalid registered node type " + ntName;
                log.debug(msg);
                throw new NoSuchNodeTypeException(msg, ntce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EffectiveNodeType getEffectiveNodeType(Name[] ntNames, EffectiveNodeTypeCache entCache, Map<Name, NodeTypeDef> ntdCache) throws NodeTypeConflictException, NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(ntNames);
        if (entCache.contains(key)) {
            return entCache.get(key);
        }
        for (Name ntName : ntNames) {
            if (ntdCache.containsKey(ntName)) continue;
            throw new NoSuchNodeTypeException(ntName.toString());
        }
        EffectiveNodeTypeCache.Key requested = key;
        EffectiveNodeType result = null;
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            while (key.getNames().length > 0) {
                Name[] remainder;
                EffectiveNodeTypeCache.Key subKey = entCache.findBest(key);
                if (subKey != null) {
                    EffectiveNodeType ent = entCache.get(subKey);
                    if (result == null) {
                        result = ent;
                    } else {
                        result = result.merge(ent);
                        entCache.put(result);
                    }
                    key = key.subtract(subKey);
                    continue;
                }
                for (Name aRemainder : remainder = key.getNames()) {
                    NodeTypeDef ntd = ntdCache.get(aRemainder);
                    EffectiveNodeType ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
                    entCache.put(ent);
                    if (result == null) {
                        result = ent;
                        continue;
                    }
                    result = result.merge(ent);
                    entCache.put(result);
                }
            }
        }
        if (!entCache.contains(requested)) {
            entCache.put(requested, result);
        }
        return result;
    }

    static void checkForCircularInheritance(Name[] supertypes, Stack<Name> inheritanceChain, Map<Name, NodeTypeDef> ntDefCache) throws InvalidNodeTypeDefException, RepositoryException {
        for (Name nt : supertypes) {
            int pos = inheritanceChain.lastIndexOf(nt);
            if (pos >= 0) {
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < inheritanceChain.size(); ++j) {
                    if (j == pos) {
                        buf.append("--> ");
                    }
                    buf.append(inheritanceChain.get(j));
                    buf.append(" extends ");
                }
                buf.append("--> ");
                buf.append(nt);
                throw new InvalidNodeTypeDefException("circular inheritance detected: " + buf.toString());
            }
            try {
                NodeTypeDef ntd = ntDefCache.get(nt);
                Name[] sta = ntd.getSupertypes();
                if (sta.length <= 0) continue;
                inheritanceChain.push(nt);
                NodeTypeRegistry.checkForCircularInheritance(sta, inheritanceChain, ntDefCache);
                inheritanceChain.pop();
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg = "unknown supertype: " + nt;
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, nsnte);
            }
        }
    }

    static void checkForCircularNodeAutoCreation(EffectiveNodeType childNodeENT, Stack<Name> definingParentNTs, EffectiveNodeTypeCache anEntCache, Map<Name, NodeTypeDef> ntDefCache) throws InvalidNodeTypeDefException {
        NodeDef[] nodeDefs;
        Name[] childNodeNTs;
        for (Name nt : childNodeNTs = childNodeENT.getAllNodeTypes()) {
            int pos = definingParentNTs.lastIndexOf(nt);
            if (pos < 0) continue;
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < definingParentNTs.size(); ++j) {
                if (j == pos) {
                    buf.append("--> ");
                }
                buf.append("node type ");
                buf.append(definingParentNTs.get(j));
                buf.append(" defines auto-created child node with default ");
            }
            buf.append("--> ");
            buf.append("node type ");
            buf.append(nt);
            throw new InvalidNodeTypeDefException("circular node auto-creation detected: " + buf.toString());
        }
        for (NodeDef nodeDef : nodeDefs = childNodeENT.getAutoCreateNodeDefs()) {
            Name dnt = nodeDef.getDefaultPrimaryType();
            Name definingNT = nodeDef.getDeclaringNodeType();
            try {
                if (dnt == null) continue;
                definingParentNTs.push(definingNT);
                NodeTypeRegistry.checkForCircularNodeAutoCreation(NodeTypeRegistry.getEffectiveNodeType(dnt, anEntCache, ntDefCache), definingParentNTs, anEntCache, ntDefCache);
                definingParentNTs.pop();
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg = definingNT + " defines invalid default node type for child node " + nodeDef.getName();
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, nsnte);
            }
        }
    }

    private EffectiveNodeType internalRegister(NodeTypeDef ntd) throws InvalidNodeTypeDefException, RepositoryException {
        NodeDef[] nda;
        PropDef[] pda;
        Name name = ntd.getName();
        if (name != null && this.registeredNTDefs.containsKey(name)) {
            String msg = name + " already exists";
            log.debug(msg);
            throw new InvalidNodeTypeDefException(msg);
        }
        NodeTypeRegistry.checkNtBaseSubtyping(ntd, this.registeredNTDefs);
        EffectiveNodeType ent = NodeTypeRegistry.validateNodeTypeDef(ntd, this.entCache, this.registeredNTDefs, this.nsReg, false);
        this.entCache.put(ent);
        ntd = (NodeTypeDef)ntd.clone();
        this.registeredNTDefs.put(name, ntd);
        for (PropDef aPda : pda = ntd.getPropertyDefs()) {
            this.propDefs.put(aPda.getId(), aPda);
        }
        for (NodeDef aNda : nda = ntd.getChildNodeDefs()) {
            this.nodeDefs.put(aNda.getId(), aNda);
        }
        return ent;
    }

    private void internalRegister(Collection<NodeTypeDef> ntDefs) throws InvalidNodeTypeDefException, RepositoryException {
        this.internalRegister(ntDefs, false);
    }

    private void internalRegister(Collection<NodeTypeDef> ntDefs, boolean lenient) throws InvalidNodeTypeDefException, RepositoryException {
        HashMap<Name, NodeTypeDef> tmpNTDefCache = new HashMap<Name, NodeTypeDef>(this.registeredNTDefs);
        for (NodeTypeDef ntd : ntDefs) {
            Name name = ntd.getName();
            if (name != null && tmpNTDefCache.containsKey(name)) {
                String msg = name + " already exists";
                if (tmpNTDefCache.containsKey(name)) {
                    msg = msg + " locally";
                }
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            tmpNTDefCache.put(ntd.getName(), ntd);
        }
        for (NodeTypeDef ntd : ntDefs) {
            NodeTypeRegistry.checkNtBaseSubtyping(ntd, tmpNTDefCache);
        }
        EffectiveNodeTypeCache tmpENTCache = (EffectiveNodeTypeCache)this.entCache.clone();
        for (NodeTypeDef ntd : ntDefs) {
            EffectiveNodeType ent = NodeTypeRegistry.validateNodeTypeDef(ntd, tmpENTCache, tmpNTDefCache, this.nsReg, lenient);
            tmpENTCache.put(ent);
        }
        for (NodeTypeDef ntd : ntDefs) {
            NodeDef[] nda;
            PropDef[] pda;
            ntd = (NodeTypeDef)ntd.clone();
            this.registeredNTDefs.put(ntd.getName(), ntd);
            for (PropDef aPda : pda = ntd.getPropertyDefs()) {
                this.propDefs.put(aPda.getId(), aPda);
            }
            for (NodeDef aNda : nda = ntd.getChildNodeDefs()) {
                this.nodeDefs.put(aNda.getId(), aNda);
            }
        }
        this.entCache = tmpENTCache;
    }

    private void internalUnregister(Name name) throws NoSuchNodeTypeException {
        NodeDef[] nda;
        PropDef[] pda;
        NodeTypeDef ntd = this.registeredNTDefs.get(name);
        if (ntd == null) {
            throw new NoSuchNodeTypeException(name.toString());
        }
        this.registeredNTDefs.remove(name);
        this.entCache.invalidate(name);
        for (PropDef aPda : pda = ntd.getPropertyDefs()) {
            this.propDefs.remove(aPda.getId());
        }
        for (NodeDef aNda : nda = ntd.getChildNodeDefs()) {
            this.nodeDefs.remove(aNda.getId());
        }
    }

    private void internalUnregister(Collection<Name> ntNames) throws NoSuchNodeTypeException {
        for (Name name : ntNames) {
            this.internalUnregister(name);
        }
    }

    private static void checkNamespace(Name name, NamespaceRegistry nsReg) throws RepositoryException {
        if (name != null) {
            nsReg.getPrefix(name.getNamespaceURI());
        }
    }

    private static boolean checkNtBaseSubtyping(NodeTypeDef ntd, Map<Name, NodeTypeDef> ntdCache) {
        boolean modified;
        if (NameConstants.NT_BASE.equals(ntd.getName())) {
            return false;
        }
        TreeSet<Name> supertypes = new TreeSet<Name>(Arrays.asList(ntd.getSupertypes()));
        if (supertypes.isEmpty()) {
            return false;
        }
        if (ntd.isMixin()) {
            modified = supertypes.remove(NameConstants.NT_BASE);
        } else {
            boolean allMixins = true;
            for (Name name : supertypes) {
                NodeTypeDef def;
                if (name.equals(NameConstants.NT_BASE) || (def = ntdCache.get(name)) == null || def.isMixin()) continue;
                allMixins = false;
                break;
            }
            modified = allMixins ? supertypes.add(NameConstants.NT_BASE) : supertypes.remove(NameConstants.NT_BASE);
        }
        if (modified) {
            ntd.setSupertypes(supertypes.toArray(new Name[supertypes.size()]));
        }
        return modified;
    }

    private static EffectiveNodeType validateNodeTypeDef(NodeTypeDef ntd, EffectiveNodeTypeCache entCache, Map<Name, NodeTypeDef> ntdCache, NamespaceRegistry nsReg, boolean lenient) throws InvalidNodeTypeDefException, RepositoryException {
        NodeDef[] cnda;
        String msg;
        PropDef[] pda;
        EffectiveNodeType ent = null;
        Name name = ntd.getName();
        if (name == null) {
            String msg2 = "no name specified";
            log.debug(msg2);
            throw new InvalidNodeTypeDefException(msg2);
        }
        NodeTypeRegistry.checkNamespace(name, nsReg);
        Name[] supertypes = ntd.getSupertypes();
        if (supertypes.length > 0) {
            for (Name supertype : supertypes) {
                NodeTypeRegistry.checkNamespace(supertype, nsReg);
                if (name.equals(supertype)) {
                    String msg3 = "[" + name + "] invalid supertype: " + supertype + " (infinite recursion))";
                    log.debug(msg3);
                    throw new InvalidNodeTypeDefException(msg3);
                }
                if (ntdCache.containsKey(supertype)) continue;
                String msg4 = "[" + name + "] invalid supertype: " + supertype;
                log.debug(msg4);
                throw new InvalidNodeTypeDefException(msg4);
            }
            Stack<Name> inheritanceChain = new Stack<Name>();
            inheritanceChain.push(name);
            NodeTypeRegistry.checkForCircularInheritance(supertypes, inheritanceChain, ntdCache);
        }
        if (supertypes.length > 0) {
            try {
                EffectiveNodeType est = NodeTypeRegistry.getEffectiveNodeType(supertypes, entCache, ntdCache);
                if (ntd.getPrimaryItemName() != null && est.getPrimaryItemName() != null) {
                    String msg5 = "[" + name + "] primaryItemName is already specified by a supertype and must therefore not be overridden.";
                    log.debug(msg5);
                    throw new InvalidNodeTypeDefException(msg5);
                }
            }
            catch (NodeTypeConflictException ntce) {
                String msg6 = "[" + name + "] failed to validate supertypes";
                log.debug(msg6);
                throw new InvalidNodeTypeDefException(msg6, ntce);
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg7 = "[" + name + "] failed to validate supertypes";
                log.debug(msg7);
                throw new InvalidNodeTypeDefException(msg7, nsnte);
            }
        }
        NodeTypeRegistry.checkNamespace(ntd.getPrimaryItemName(), nsReg);
        for (PropDef pd : pda = ntd.getPropertyDefs()) {
            QValueConstraint[] constraints;
            String msg2;
            if (!name.equals(pd.getDeclaringNodeType())) {
                String msg8 = "[" + name + "#" + pd.getName() + "] invalid declaring node type specified";
                log.debug(msg8);
                throw new InvalidNodeTypeDefException(msg8);
            }
            NodeTypeRegistry.checkNamespace(pd.getName(), nsReg);
            if (pd.definesResidual() && pd.isAutoCreated()) {
                msg2 = "[" + name + "#" + pd.getName() + "] auto-created properties must specify a name";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2);
            }
            if (pd.getRequiredType() == 0 && pd.isAutoCreated()) {
                msg2 = "[" + name + "#" + pd.getName() + "] auto-created properties must specify a type";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2);
            }
            InternalValue[] defVals = pd.getDefaultValues();
            if (defVals != null && defVals.length != 0) {
                int reqType = pd.getRequiredType();
                for (InternalValue internalValue : defVals) {
                    if (reqType == 0) {
                        reqType = internalValue.getType();
                        continue;
                    }
                    if (internalValue.getType() == reqType) continue;
                    String msg9 = "[" + name + "#" + pd.getName() + "] type of default value(s) is not consistent with required property type";
                    log.debug(msg9);
                    throw new InvalidNodeTypeDefException(msg9);
                }
            } else if (!lenient && pd.isAutoCreated()) {
                msg = "[" + name + "#" + pd.getName() + "] auto-created property must have a default value";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            if ((constraints = pd.getValueConstraints()) == null || constraints.length <= 0) continue;
            if (defVals != null && defVals.length > 0) {
                for (InternalValue internalValue : defVals) {
                    boolean satisfied = false;
                    ConstraintViolationException cve = null;
                    for (QValueConstraint constraint : constraints) {
                        try {
                            constraint.check(internalValue);
                            satisfied = true;
                            break;
                        }
                        catch (ConstraintViolationException e) {
                            cve = e;
                        }
                    }
                    if (satisfied) continue;
                    String msg10 = "[" + name + "#" + pd.getName() + "] default value does not satisfy value constraint";
                    log.debug(msg10);
                    throw new InvalidNodeTypeDefException(msg10, cve);
                }
            }
            if (pd.getRequiredType() != 9 && pd.getRequiredType() != 10) continue;
            for (QValueConstraint qValueConstraint : constraints) {
                Name ntName = NameFactoryImpl.getInstance().create(qValueConstraint.getString());
                if (name.equals(ntName) || ntdCache.containsKey(ntName)) continue;
                String msg11 = "[" + name + "#" + pd.getName() + "] invalid " + (pd.getRequiredType() == 9 ? "REFERENCE" : "WEAKREFERENCE") + " value constraint '" + ntName + "' (unknown node type)";
                log.debug(msg11);
                throw new InvalidNodeTypeDefException(msg11);
            }
        }
        for (NodeDef cnd : cnda = ntd.getChildNodeDefs()) {
            Name[] reqTypes;
            if (!name.equals(cnd.getDeclaringNodeType())) {
                msg = "[" + name + "#" + cnd.getName() + "] invalid declaring node type specified";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            NodeTypeRegistry.checkNamespace(cnd.getName(), nsReg);
            if (cnd.definesResidual() && cnd.isAutoCreated()) {
                msg = "[" + name + "#" + cnd.getName() + "] auto-created child-nodes must specify a name";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            if (cnd.getDefaultPrimaryType() == null && cnd.isAutoCreated()) {
                msg = "[" + name + "#" + cnd.getName() + "] auto-created child-nodes must specify a default primary type";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            Name dpt = cnd.getDefaultPrimaryType();
            NodeTypeRegistry.checkNamespace(dpt, nsReg);
            boolean referenceToSelf = false;
            EffectiveNodeType defaultENT = null;
            if (dpt != null) {
                if (name.equals(dpt)) {
                    referenceToSelf = true;
                }
                if (!name.equals(dpt) && !ntdCache.containsKey(dpt)) {
                    String msg13 = "[" + name + "#" + cnd.getName() + "] invalid default primary type '" + dpt + "'";
                    log.debug(msg13);
                    throw new InvalidNodeTypeDefException(msg13);
                }
                try {
                    defaultENT = !referenceToSelf ? NodeTypeRegistry.getEffectiveNodeType(dpt, entCache, ntdCache) : (ent = EffectiveNodeType.create(ntd, entCache, ntdCache));
                    if (cnd.isAutoCreated()) {
                        Stack<Name> definingNTs = new Stack<Name>();
                        definingNTs.push(name);
                        NodeTypeRegistry.checkForCircularNodeAutoCreation(defaultENT, definingNTs, entCache, ntdCache);
                    }
                }
                catch (NodeTypeConflictException ntce) {
                    String string = "[" + name + "#" + cnd.getName() + "] failed to validate default primary type";
                    log.debug(string);
                    throw new InvalidNodeTypeDefException(string, ntce);
                }
                catch (NoSuchNodeTypeException nsnte) {
                    String string = "[" + name + "#" + cnd.getName() + "] failed to validate default primary type";
                    log.debug(string);
                    throw new InvalidNodeTypeDefException(string, nsnte);
                }
            }
            if ((reqTypes = cnd.getRequiredPrimaryTypes()) == null || reqTypes.length <= 0) continue;
            for (Name rpt : reqTypes) {
                if (NameConstants.NT_BASE.equals(rpt)) continue;
                NodeTypeRegistry.checkNamespace(rpt, nsReg);
                referenceToSelf = false;
                if (name.equals(rpt)) {
                    referenceToSelf = true;
                }
                if (!name.equals(rpt) && !ntdCache.containsKey(rpt)) {
                    String msg14 = "[" + name + "#" + cnd.getName() + "] invalid required primary type: " + rpt;
                    log.debug(msg14);
                    throw new InvalidNodeTypeDefException(msg14);
                }
                if (defaultENT != null && !defaultENT.includesNodeType(rpt)) {
                    String msg15 = "[" + name + "#" + cnd.getName() + "] default primary type does not satisfy required primary type constraint " + rpt;
                    log.debug(msg15);
                    throw new InvalidNodeTypeDefException(msg15);
                }
                try {
                    if (!referenceToSelf) {
                        NodeTypeRegistry.getEffectiveNodeType(rpt, entCache, ntdCache);
                        continue;
                    }
                    if (ent != null) continue;
                    ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
                }
                catch (NodeTypeConflictException ntce) {
                    String msg16 = "[" + name + "#" + cnd.getName() + "] failed to validate required primary type constraint";
                    log.debug(msg16);
                    throw new InvalidNodeTypeDefException(msg16, ntce);
                }
                catch (NoSuchNodeTypeException nsnte) {
                    String msg17 = "[" + name + "#" + cnd.getName() + "] failed to validate required primary type constraint";
                    log.debug(msg17);
                    throw new InvalidNodeTypeDefException(msg17, nsnte);
                }
            }
        }
        if (ent == null) {
            try {
                ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
            }
            catch (NodeTypeConflictException ntce) {
                String msg18 = "[" + name + "] failed to resolve node type definition";
                log.debug(msg18);
                throw new InvalidNodeTypeDefException(msg18, ntce);
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg19 = "[" + name + "] failed to resolve node type definition";
                log.debug(msg19);
                throw new InvalidNodeTypeDefException(msg19, nsnte);
            }
        }
        return ent;
    }

    private static NodeDef createRootNodeDef() {
        NodeDefImpl def = new NodeDefImpl();
        def.setDeclaringNodeType(NameConstants.REP_ROOT);
        def.setRequiredPrimaryTypes(new Name[]{NameConstants.REP_ROOT});
        def.setDefaultPrimaryType(NameConstants.REP_ROOT);
        def.setMandatory(true);
        def.setProtected(false);
        def.setOnParentVersion(2);
        def.setAllowsSameNameSiblings(false);
        def.setAutoCreated(true);
        return def;
    }

    private void notifyRegistered(Name ntName) {
        NodeTypeRegistryListener[] la;
        for (NodeTypeRegistryListener aLa : la = this.listeners.values().toArray(new NodeTypeRegistryListener[this.listeners.size()])) {
            if (aLa == null) continue;
            aLa.nodeTypeRegistered(ntName);
        }
    }

    private void notifyReRegistered(Name ntName) {
        NodeTypeRegistryListener[] la;
        for (NodeTypeRegistryListener aLa : la = this.listeners.values().toArray(new NodeTypeRegistryListener[this.listeners.size()])) {
            if (aLa == null) continue;
            aLa.nodeTypeReRegistered(ntName);
        }
    }

    private void notifyUnregistered(Name ntName) {
        NodeTypeRegistryListener[] la;
        for (NodeTypeRegistryListener aLa : la = this.listeners.values().toArray(new NodeTypeRegistryListener[this.listeners.size()])) {
            if (aLa == null) continue;
            aLa.nodeTypeUnregistered(ntName);
        }
    }
}

