/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefImpl;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.QNodeTypeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public class NodeTypeDef
implements Cloneable {
    private Name name;
    private Name[] supertypes;
    private boolean mixin;
    private boolean orderableChildNodes;
    private boolean queryable;
    private boolean abstractStatus;
    private Name primaryItemName;
    private Set<PropDef> propDefs;
    private Set<NodeDef> nodeDefs;
    private Set<Name> dependencies;

    public NodeTypeDef() {
        this.dependencies = null;
        this.name = null;
        this.primaryItemName = null;
        this.supertypes = Name.EMPTY_ARRAY;
        this.mixin = false;
        this.orderableChildNodes = false;
        this.abstractStatus = false;
        this.queryable = true;
        this.nodeDefs = new HashSet<NodeDef>();
        this.propDefs = new HashSet<PropDef>();
    }

    public NodeTypeDef(QNodeTypeDefinition def) {
        this.name = def.getName();
        this.primaryItemName = def.getPrimaryItemName();
        this.supertypes = def.getSupertypes();
        this.mixin = def.isMixin();
        this.orderableChildNodes = def.hasOrderableChildNodes();
        this.abstractStatus = def.isAbstract();
        this.queryable = def.isQueryable();
        this.nodeDefs = new HashSet<NodeDef>();
        for (QNodeDefinition qNodeDefinition : def.getChildNodeDefs()) {
            this.nodeDefs.add(new NodeDefImpl(qNodeDefinition));
        }
        this.propDefs = new HashSet<PropDef>();
        for (QItemDefinition qItemDefinition : def.getPropertyDefs()) {
            this.propDefs.add(new PropDefImpl((QPropertyDefinition)qItemDefinition));
        }
    }

    public QNodeTypeDefinition getQNodeTypeDefinition() {
        QNodeDefinition[] qNodeDefs = new QNodeDefinition[this.nodeDefs.size()];
        int i = 0;
        for (NodeDef nd : this.nodeDefs) {
            qNodeDefs[i++] = ((NodeDefImpl)nd).getQNodeDefinition();
        }
        QPropertyDefinition[] qPropDefs = new QPropertyDefinition[this.propDefs.size()];
        i = 0;
        for (PropDef pd : this.propDefs) {
            qPropDefs[i++] = ((PropDefImpl)pd).getQPropertyDefinition();
        }
        return new QNodeTypeDefinitionImpl(this.getName(), this.getSupertypes(), null, this.isMixin(), this.isAbstract(), this.isQueryable(), this.hasOrderableChildNodes(), this.getPrimaryItemName(), qPropDefs, qNodeDefs);
    }

    public Collection getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new HashSet<Name>();
            this.dependencies.addAll(Arrays.asList(this.supertypes));
            for (NodeDef nd : this.nodeDefs) {
                Name[] ntNames;
                Name ntName = nd.getDefaultPrimaryType();
                if (ntName != null && !this.name.equals(ntName)) {
                    this.dependencies.add(ntName);
                }
                for (Name ntName1 : ntNames = nd.getRequiredPrimaryTypes()) {
                    if (ntName1 == null || this.name.equals(ntName1)) continue;
                    this.dependencies.add(ntName1);
                }
            }
            for (PropDef pd : this.propDefs) {
                QValueConstraint[] ca;
                if (pd.getRequiredType() != 9 && pd.getRequiredType() != 10 || (ca = pd.getValueConstraints()) == null) continue;
                for (QValueConstraint aCa : ca) {
                    Name rcName = NameFactoryImpl.getInstance().create(aCa.getString());
                    if (this.name.equals(rcName)) continue;
                    this.dependencies.add(rcName);
                }
            }
        }
        return this.dependencies;
    }

    private void resetDependencies() {
        this.dependencies = null;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public void setSupertypes(Name[] names) {
        this.resetDependencies();
        if (names.length == 0) {
            this.supertypes = Name.EMPTY_ARRAY;
        } else if (names.length == 1) {
            this.supertypes = new Name[]{names[0]};
        } else {
            TreeSet<Name> types = new TreeSet<Name>();
            types.addAll(Arrays.asList(names));
            this.supertypes = types.toArray(new Name[types.size()]);
        }
    }

    public void setMixin(boolean mixin) {
        this.mixin = mixin;
    }

    public void setOrderableChildNodes(boolean orderableChildNodes) {
        this.orderableChildNodes = orderableChildNodes;
    }

    public void setAbstract(boolean abstractStatus) {
        this.abstractStatus = abstractStatus;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    public void setPrimaryItemName(Name primaryItemName) {
        this.primaryItemName = primaryItemName;
    }

    public void setPropertyDefs(PropDef[] defs) {
        this.resetDependencies();
        this.propDefs.clear();
        this.propDefs.addAll(Arrays.asList(defs));
    }

    public void setChildNodeDefs(NodeDef[] defs) {
        this.resetDependencies();
        this.nodeDefs.clear();
        this.nodeDefs.addAll(Arrays.asList(defs));
    }

    public Name getName() {
        return this.name;
    }

    public Name[] getSupertypes() {
        if (this.supertypes.length > 0 || this.isMixin() || NameConstants.NT_BASE.equals(this.getName())) {
            return this.supertypes;
        }
        return new Name[]{NameConstants.NT_BASE};
    }

    public boolean isMixin() {
        return this.mixin;
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    public boolean isAbstract() {
        return this.abstractStatus;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public Name getPrimaryItemName() {
        return this.primaryItemName;
    }

    public PropDef[] getPropertyDefs() {
        if (this.propDefs.isEmpty()) {
            return PropDef.EMPTY_ARRAY;
        }
        return this.propDefs.toArray(new PropDef[this.propDefs.size()]);
    }

    public NodeDef[] getChildNodeDefs() {
        if (this.nodeDefs.isEmpty()) {
            return NodeDef.EMPTY_ARRAY;
        }
        return this.nodeDefs.toArray(new NodeDef[this.nodeDefs.size()]);
    }

    public Object clone() {
        NodeTypeDef clone = new NodeTypeDef();
        clone.name = this.name;
        clone.primaryItemName = this.primaryItemName;
        clone.supertypes = this.supertypes;
        clone.mixin = this.mixin;
        clone.orderableChildNodes = this.orderableChildNodes;
        clone.abstractStatus = this.abstractStatus;
        clone.queryable = this.queryable;
        clone.nodeDefs = new HashSet<NodeDef>();
        clone.nodeDefs = new HashSet<NodeDef>(this.nodeDefs);
        clone.propDefs = new HashSet<PropDef>(this.propDefs);
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeTypeDef) {
            NodeTypeDef other = (NodeTypeDef)obj;
            return (this.name == null ? other.name == null : this.name.equals(other.name)) && (this.primaryItemName == null ? other.primaryItemName == null : this.primaryItemName.equals(other.primaryItemName)) && Arrays.equals(this.getSupertypes(), other.getSupertypes()) && this.mixin == other.mixin && this.orderableChildNodes == other.orderableChildNodes && this.abstractStatus == other.abstractStatus && this.queryable == other.queryable && ((Object)this.propDefs).equals(other.propDefs) && ((Object)this.nodeDefs).equals(other.nodeDefs);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

