/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.core.nodetype.ItemDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.commons.QNodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class NodeDefImpl
extends ItemDefImpl
implements NodeDef {
    private Name defaultPrimaryType;
    private Set<Name> requiredPrimaryTypes;
    private boolean allowsSameNameSiblings;
    private NodeDefId id;

    public NodeDefImpl() {
        this.defaultPrimaryType = null;
        this.requiredPrimaryTypes = new HashSet<Name>();
        this.requiredPrimaryTypes.add(NameConstants.NT_BASE);
        this.allowsSameNameSiblings = false;
        this.id = null;
    }

    public NodeDefImpl(QNodeDefinition nd) {
        super(nd);
        this.defaultPrimaryType = nd.getDefaultPrimaryType();
        this.requiredPrimaryTypes = new HashSet<Name>(Arrays.asList(nd.getRequiredPrimaryTypes()));
        this.allowsSameNameSiblings = nd.allowsSameNameSiblings();
        this.id = null;
    }

    public QNodeDefinition getQNodeDefinition() {
        return new QNodeDefinitionImpl(this.getName(), this.getDeclaringNodeType(), this.isAutoCreated(), this.isMandatory(), this.getOnParentVersion(), this.isProtected(), this.getDefaultPrimaryType(), this.getRequiredPrimaryTypes(), this.allowsSameNameSiblings());
    }

    public void setDefaultPrimaryType(Name defaultNodeType) {
        this.id = null;
        this.defaultPrimaryType = defaultNodeType;
    }

    public void setRequiredPrimaryTypes(Name[] requiredPrimaryTypes) {
        if (requiredPrimaryTypes == null) {
            throw new IllegalArgumentException("requiredPrimaryTypes can not be null");
        }
        this.id = null;
        this.requiredPrimaryTypes.clear();
        this.requiredPrimaryTypes.addAll(Arrays.asList(requiredPrimaryTypes));
    }

    public void setAllowsSameNameSiblings(boolean allowsSameNameSiblings) {
        this.id = null;
        this.allowsSameNameSiblings = allowsSameNameSiblings;
    }

    public void setDeclaringNodeType(Name declaringNodeType) {
        this.id = null;
        super.setDeclaringNodeType(declaringNodeType);
    }

    public void setName(Name name) {
        this.id = null;
        super.setName(name);
    }

    public void setAutoCreated(boolean autoCreated) {
        this.id = null;
        super.setAutoCreated(autoCreated);
    }

    public void setOnParentVersion(int onParentVersion) {
        this.id = null;
        super.setOnParentVersion(onParentVersion);
    }

    public void setProtected(boolean writeProtected) {
        this.id = null;
        super.setProtected(writeProtected);
    }

    public void setMandatory(boolean mandatory) {
        this.id = null;
        super.setMandatory(mandatory);
    }

    public NodeDefId getId() {
        if (this.id == null) {
            this.id = new NodeDefId(this);
        }
        return this.id;
    }

    public Name getDefaultPrimaryType() {
        return this.defaultPrimaryType;
    }

    public Name[] getRequiredPrimaryTypes() {
        if (this.requiredPrimaryTypes.isEmpty()) {
            return Name.EMPTY_ARRAY;
        }
        return this.requiredPrimaryTypes.toArray(new Name[this.requiredPrimaryTypes.size()]);
    }

    public boolean allowsSameNameSiblings() {
        return this.allowsSameNameSiblings;
    }

    public boolean definesNode() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeDefImpl) {
            NodeDefImpl other = (NodeDefImpl)obj;
            return super.equals(obj) && ((Object)this.requiredPrimaryTypes).equals(other.requiredPrimaryTypes) && (this.defaultPrimaryType == null ? other.defaultPrimaryType == null : this.defaultPrimaryType.equals(other.defaultPrimaryType)) && this.allowsSameNameSiblings == other.allowsSameNameSiblings;
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

