/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.core.nodetype.ItemDef;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectiveNodeType
implements Cloneable {
    private static Logger log = LoggerFactory.getLogger(EffectiveNodeType.class);
    private final TreeSet<Name> mergedNodeTypes = new TreeSet();
    private final TreeSet<Name> inheritedNodeTypes = new TreeSet();
    private final TreeSet<Name> allNodeTypes = new TreeSet();
    private final HashMap<Name, List<ItemDef>> namedItemDefs = new HashMap();
    private final ArrayList<ItemDef> unnamedItemDefs = new ArrayList();
    private boolean orderableChildNodes = false;
    private Name primaryItemName = null;

    private EffectiveNodeType() {
    }

    static EffectiveNodeType create(NodeTypeDef ntd, EffectiveNodeTypeCache entCache, Map<Name, NodeTypeDef> ntdCache) throws NodeTypeConflictException, NoSuchNodeTypeException {
        PropDef[] pda;
        NodeDef[] cnda;
        EffectiveNodeType ent = new EffectiveNodeType();
        Name ntName = ntd.getName();
        ent.mergedNodeTypes.add(ntName);
        ent.allNodeTypes.add(ntName);
        HashMap<Serializable, ItemDef> itemDefIds = new HashMap<Serializable, ItemDef>();
        for (NodeDef aCnda : cnda = ntd.getChildNodeDefs()) {
            if (itemDefIds.containsKey(aCnda.getId())) {
                String msg = aCnda.definesResidual() ? ntName + " contains ambiguous residual child node definitions" : ntName + " contains ambiguous definitions for child node named " + aCnda.getName();
                log.debug(msg);
                throw new NodeTypeConflictException(msg);
            }
            itemDefIds.put(aCnda.getId(), aCnda);
            if (aCnda.definesResidual()) {
                ent.unnamedItemDefs.add(aCnda);
                continue;
            }
            Name name = aCnda.getName();
            List<ItemDef> defs = ent.namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList<ItemDef>();
                ent.namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (ItemDef itemDef : defs) {
                    if (!aCnda.isAutoCreated() && !itemDef.isAutoCreated()) continue;
                    String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg);
                    throw new NodeTypeConflictException(msg);
                }
            }
            defs.add(aCnda);
        }
        for (PropDef aPda : pda = ntd.getPropertyDefs()) {
            if (itemDefIds.containsKey(aPda.getId())) {
                String msg = aPda.definesResidual() ? ntName + " contains ambiguous residual property definitions" : ntName + " contains ambiguous definitions for property named " + aPda.getName();
                log.debug(msg);
                throw new NodeTypeConflictException(msg);
            }
            itemDefIds.put(aPda.getId(), aPda);
            if (aPda.definesResidual()) {
                ent.unnamedItemDefs.add(aPda);
                continue;
            }
            Name name = aPda.getName();
            List<ItemDef> defs = ent.namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList<ItemDef>();
                ent.namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (ItemDef def3 : defs) {
                    if (!aPda.isAutoCreated() && !def3.isAutoCreated()) continue;
                    String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg);
                    throw new NodeTypeConflictException(msg);
                }
            }
            defs.add(aPda);
        }
        Name[] supertypes = ntd.getSupertypes();
        if (supertypes.length > 0) {
            EffectiveNodeType base = NodeTypeRegistry.getEffectiveNodeType(supertypes, entCache, ntdCache);
            ent.internalMerge(base, true);
        }
        if (ntd.hasOrderableChildNodes()) {
            ent.orderableChildNodes = true;
        } else {
            Name[] nta;
            for (Name aNta : nta = ent.getInheritedNodeTypes()) {
                NodeTypeDef nodeTypeDef = ntdCache.get(aNta);
                if (!nodeTypeDef.hasOrderableChildNodes()) continue;
                ent.orderableChildNodes = true;
                break;
            }
        }
        if (ntd.getPrimaryItemName() != null) {
            ent.primaryItemName = ntd.getPrimaryItemName();
        } else {
            Name[] nta;
            for (Name aNta : nta = ent.getInheritedNodeTypes()) {
                NodeTypeDef nodeTypeDef = ntdCache.get(aNta);
                if (nodeTypeDef.getPrimaryItemName() == null) continue;
                ent.primaryItemName = nodeTypeDef.getPrimaryItemName();
                break;
            }
        }
        return ent;
    }

    static EffectiveNodeType create() {
        return new EffectiveNodeType();
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    public Name getPrimaryItemName() {
        return this.primaryItemName;
    }

    public Name[] getMergedNodeTypes() {
        return this.mergedNodeTypes.toArray(new Name[this.mergedNodeTypes.size()]);
    }

    public Name[] getInheritedNodeTypes() {
        return this.inheritedNodeTypes.toArray(new Name[this.inheritedNodeTypes.size()]);
    }

    public Name[] getAllNodeTypes() {
        return this.allNodeTypes.toArray(new Name[this.allNodeTypes.size()]);
    }

    public ItemDef[] getAllItemDefs() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        for (List<ItemDef> itemDefs : this.namedItemDefs.values()) {
            defs.addAll(itemDefs);
        }
        defs.addAll(this.unnamedItemDefs);
        if (defs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        return defs.toArray(new ItemDef[defs.size()]);
    }

    public ItemDef[] getNamedItemDefs() {
        if (this.namedItemDefs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.namedItemDefs.size());
        for (List<ItemDef> itemDefs : this.namedItemDefs.values()) {
            defs.addAll(itemDefs);
        }
        if (defs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        return defs.toArray(new ItemDef[defs.size()]);
    }

    public ItemDef[] getUnnamedItemDefs() {
        if (this.unnamedItemDefs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        return this.unnamedItemDefs.toArray(new ItemDef[this.unnamedItemDefs.size()]);
    }

    public boolean hasNamedItemDef(Name name) {
        return this.namedItemDefs.containsKey(name);
    }

    public ItemDef[] getNamedItemDefs(Name name) {
        List<ItemDef> defs = this.namedItemDefs.get(name);
        if (defs == null || defs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        return defs.toArray(new ItemDef[defs.size()]);
    }

    public NodeDef[] getAllNodeDefs() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<NodeDef> defs = new ArrayList<NodeDef>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        for (ItemDef itemDef : this.unnamedItemDefs) {
            if (!itemDef.definesNode()) continue;
            defs.add((NodeDef)itemDef);
        }
        for (List list : this.namedItemDefs.values()) {
            for (ItemDef def : list) {
                if (!def.definesNode()) continue;
                defs.add((NodeDef)def);
            }
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public NodeDef[] getNamedNodeDefs() {
        if (this.namedItemDefs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<NodeDef> defs = new ArrayList<NodeDef>(this.namedItemDefs.size());
        for (List<ItemDef> list : this.namedItemDefs.values()) {
            for (ItemDef def : list) {
                if (!def.definesNode()) continue;
                defs.add((NodeDef)def);
            }
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public NodeDef[] getNamedNodeDefs(Name name) {
        List<ItemDef> list = this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<NodeDef> defs = new ArrayList<NodeDef>(list.size());
        for (ItemDef def : list) {
            if (!def.definesNode()) continue;
            defs.add((NodeDef)def);
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public NodeDef[] getUnnamedNodeDefs() {
        if (this.unnamedItemDefs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<NodeDef> defs = new ArrayList<NodeDef>(this.unnamedItemDefs.size());
        for (ItemDef def : this.unnamedItemDefs) {
            if (!def.definesNode()) continue;
            defs.add((NodeDef)def);
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public NodeDef[] getAutoCreateNodeDefs() {
        if (this.namedItemDefs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<NodeDef> defs = new ArrayList<NodeDef>(this.namedItemDefs.size());
        for (List<ItemDef> list : this.namedItemDefs.values()) {
            for (ItemDef def : list) {
                if (!def.definesNode() || !def.isAutoCreated()) continue;
                defs.add((NodeDef)def);
            }
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public PropDef[] getAllPropDefs() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<PropDef> defs = new ArrayList<PropDef>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        for (ItemDef itemDef : this.unnamedItemDefs) {
            if (itemDef.definesNode()) continue;
            defs.add((PropDef)itemDef);
        }
        for (List list : this.namedItemDefs.values()) {
            for (ItemDef def : list) {
                if (def.definesNode()) continue;
                defs.add((PropDef)def);
            }
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public PropDef[] getNamedPropDefs() {
        if (this.namedItemDefs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<PropDef> defs = new ArrayList<PropDef>(this.namedItemDefs.size());
        for (List<ItemDef> list : this.namedItemDefs.values()) {
            for (ItemDef def : list) {
                if (def.definesNode()) continue;
                defs.add((PropDef)def);
            }
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public PropDef[] getNamedPropDefs(Name name) {
        List<ItemDef> list = this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<PropDef> defs = new ArrayList<PropDef>(list.size());
        for (ItemDef def : list) {
            if (def.definesNode()) continue;
            defs.add((PropDef)def);
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public PropDef[] getUnnamedPropDefs() {
        if (this.unnamedItemDefs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<PropDef> defs = new ArrayList<PropDef>(this.unnamedItemDefs.size());
        for (ItemDef def : this.unnamedItemDefs) {
            if (def.definesNode()) continue;
            defs.add((PropDef)def);
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public PropDef[] getAutoCreatePropDefs() {
        if (this.namedItemDefs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<PropDef> defs = new ArrayList<PropDef>(this.namedItemDefs.size());
        for (List<ItemDef> list : this.namedItemDefs.values()) {
            for (ItemDef def : list) {
                if (def.definesNode() || !def.isAutoCreated()) continue;
                defs.add((PropDef)def);
            }
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public PropDef[] getMandatoryPropDefs() {
        if (this.namedItemDefs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<PropDef> defs = new ArrayList<PropDef>(this.namedItemDefs.size());
        for (List<ItemDef> list : this.namedItemDefs.values()) {
            for (ItemDef def : list) {
                if (def.definesNode() || !def.isMandatory()) continue;
                defs.add((PropDef)def);
            }
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public NodeDef[] getMandatoryNodeDefs() {
        if (this.namedItemDefs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<NodeDef> defs = new ArrayList<NodeDef>(this.namedItemDefs.size());
        for (List<ItemDef> list : this.namedItemDefs.values()) {
            for (ItemDef def : list) {
                if (!def.definesNode() || !def.isMandatory()) continue;
                defs.add((NodeDef)def);
            }
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public boolean includesNodeType(Name nodeTypeName) {
        return this.allNodeTypes.contains(nodeTypeName);
    }

    public boolean includesNodeTypes(Name[] nodeTypeNames) {
        return this.allNodeTypes.containsAll(Arrays.asList(nodeTypeNames));
    }

    public static void checkSetPropertyValueConstraints(PropDef pd, InternalValue[] values) throws ConstraintViolationException, RepositoryException {
        if (!pd.isMultiple() && values != null && values.length > 1) {
            throw new ConstraintViolationException("the property is not multi-valued");
        }
        QValueConstraint[] constraints = pd.getValueConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        if (values != null && values.length > 0) {
            for (InternalValue value : values) {
                boolean satisfied = false;
                ConstraintViolationException cve = null;
                for (QValueConstraint constraint : constraints) {
                    try {
                        constraint.check(value);
                        satisfied = true;
                        break;
                    }
                    catch (ConstraintViolationException e) {
                        cve = e;
                    }
                }
                if (satisfied) continue;
                throw cve;
            }
        }
    }

    public void checkAddNodeConstraints(Name name) throws ConstraintViolationException {
        try {
            this.getApplicableChildNodeDef(name, null, null);
        }
        catch (NoSuchNodeTypeException nsnte) {
            String msg = "internal eror: inconsistent node type";
            log.debug(msg);
            throw new ConstraintViolationException(msg, nsnte);
        }
    }

    public void checkAddNodeConstraints(Name name, Name nodeTypeName, NodeTypeRegistry ntReg) throws ConstraintViolationException, NoSuchNodeTypeException {
        NodeDef nd;
        if (nodeTypeName != null) {
            NodeTypeDef ntDef = ntReg.getNodeTypeDef(nodeTypeName);
            if (ntDef.isAbstract()) {
                throw new ConstraintViolationException(nodeTypeName + " is abstract.");
            }
            if (ntDef.isMixin()) {
                throw new ConstraintViolationException(nodeTypeName + " is mixin.");
            }
        }
        if ((nd = this.getApplicableChildNodeDef(name, nodeTypeName, ntReg)).isProtected()) {
            throw new ConstraintViolationException(name + " is protected");
        }
        if (nd.isAutoCreated()) {
            throw new ConstraintViolationException(name + " is auto-created and can not be manually added");
        }
    }

    public NodeDef getApplicableChildNodeDef(Name name, Name nodeTypeName, NodeTypeRegistry ntReg) throws NoSuchNodeTypeException, ConstraintViolationException {
        NodeDef[] nda;
        ItemDef[] defs;
        EffectiveNodeType entTarget = nodeTypeName != null ? ntReg.getEffectiveNodeType(nodeTypeName) : null;
        for (ItemDef def : defs = this.getNamedItemDefs(name)) {
            if (!def.definesNode()) continue;
            NodeDef nd = (NodeDef)def;
            Name[] types = nd.getRequiredPrimaryTypes();
            if (!(entTarget != null && types != null ? entTarget.includesNodeTypes(types) : nd.getDefaultPrimaryType() != null)) continue;
            return nd;
        }
        for (NodeDef nd : nda = this.getUnnamedNodeDefs()) {
            if (entTarget != null && nd.getRequiredPrimaryTypes() != null) {
                if (!entTarget.includesNodeTypes(nd.getRequiredPrimaryTypes())) continue;
                return nd;
            }
            if (nd.getDefaultPrimaryType() == null) continue;
            return nd;
        }
        throw new ConstraintViolationException("no matching child node definition found for " + name);
    }

    public PropDef getApplicablePropertyDef(Name name, int type, boolean multiValued) throws ConstraintViolationException {
        PropDef match = this.getMatchingPropDef(this.getNamedPropDefs(name), type, multiValued);
        if (match != null) {
            return match;
        }
        match = this.getMatchingPropDef(this.getUnnamedPropDefs(), type, multiValued);
        if (match != null) {
            return match;
        }
        throw new ConstraintViolationException("no matching property definition found for " + name);
    }

    public PropDef getApplicablePropertyDef(Name name, int type) throws ConstraintViolationException {
        PropDef match = this.getMatchingPropDef(this.getNamedPropDefs(name), type);
        if (match != null) {
            return match;
        }
        match = this.getMatchingPropDef(this.getUnnamedPropDefs(), type);
        if (match != null) {
            return match;
        }
        throw new ConstraintViolationException("no matching property definition found for " + name);
    }

    private PropDef getMatchingPropDef(PropDef[] defs, int type) {
        PropDef match = null;
        for (PropDef pd : defs) {
            int reqType = pd.getRequiredType();
            if (reqType != 0 && type != 0 && reqType != type) continue;
            if (match == null) {
                match = pd;
            } else if (match.getRequiredType() != pd.getRequiredType()) {
                if (match.getRequiredType() == 0) {
                    match = pd;
                }
            } else if (match.isMultiple() && !pd.isMultiple()) {
                match = pd;
            }
            if (match.getRequiredType() == 0 || match.isMultiple()) continue;
            return match;
        }
        return match;
    }

    private PropDef getMatchingPropDef(PropDef[] defs, int type, boolean multiValued) {
        PropDef match = null;
        for (PropDef pd : defs) {
            int reqType = pd.getRequiredType();
            if (reqType != 0 && type != 0 && reqType != type || multiValued != pd.isMultiple()) continue;
            if (pd.getRequiredType() != 0) {
                return pd;
            }
            if (match != null) continue;
            match = pd;
        }
        return match;
    }

    public void checkRemoveItemConstraints(Name name) throws ConstraintViolationException {
        ItemDef[] defs = this.getNamedItemDefs(name);
        if (defs != null) {
            for (ItemDef def : defs) {
                if (def.isMandatory()) {
                    throw new ConstraintViolationException("can't remove mandatory item");
                }
                if (!def.isProtected()) continue;
                throw new ConstraintViolationException("can't remove protected item");
            }
        }
    }

    public void checkRemoveNodeConstraints(Name name) throws ConstraintViolationException {
        NodeDef[] defs = this.getNamedNodeDefs(name);
        if (defs != null) {
            for (NodeDef def : defs) {
                if (def.isMandatory()) {
                    throw new ConstraintViolationException("can't remove mandatory node");
                }
                if (!def.isProtected()) continue;
                throw new ConstraintViolationException("can't remove protected node");
            }
        }
    }

    public void checkRemovePropertyConstraints(Name name) throws ConstraintViolationException {
        PropDef[] defs = this.getNamedPropDefs(name);
        if (defs != null) {
            for (PropDef def : defs) {
                if (def.isMandatory()) {
                    throw new ConstraintViolationException("can't remove mandatory property");
                }
                if (!def.isProtected()) continue;
                throw new ConstraintViolationException("can't remove protected property");
            }
        }
    }

    EffectiveNodeType merge(EffectiveNodeType other) throws NodeTypeConflictException {
        EffectiveNodeType copy = (EffectiveNodeType)this.clone();
        copy.internalMerge(other, false);
        return copy;
    }

    private synchronized void internalMerge(EffectiveNodeType other, boolean supertype) throws NodeTypeConflictException {
        String msg;
        ItemDef[] defs;
        Name[] nta = other.getAllNodeTypes();
        int includedCount = 0;
        for (Name aNta : nta) {
            if (!this.includesNodeType(aNta)) continue;
            log.debug("node type '" + aNta + "' is already contained.");
            ++includedCount;
        }
        if (includedCount == nta.length) {
            return;
        }
        for (ItemDef def : defs = other.getNamedItemDefs()) {
            if (this.includesNodeType(def.getDeclaringNodeType())) continue;
            Name name = def.getName();
            List<ItemDef> existingDefs = this.namedItemDefs.get(name);
            if (existingDefs != null) {
                if (existingDefs.size() > 0) {
                    for (ItemDef existingDef : existingDefs) {
                        if (def.isAutoCreated() || existingDef.isAutoCreated()) {
                            msg = "The item definition for '" + name + "' in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existingDef.getDeclaringNodeType() + "': name collision with auto-create definition";
                            log.debug(msg);
                            throw new NodeTypeConflictException(msg);
                        }
                        if (def.definesNode() != existingDef.definesNode()) continue;
                        if (!def.definesNode()) {
                            PropDef pd = (PropDef)def;
                            PropDef epd = (PropDef)existingDef;
                            if (pd.getRequiredType() != epd.getRequiredType() || pd.isMultiple() != epd.isMultiple()) continue;
                            String msg2 = "The property definition for '" + name + "' in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existingDef.getDeclaringNodeType() + "': ambiguous property definition";
                            log.debug(msg2);
                            throw new NodeTypeConflictException(msg2);
                        }
                        msg = "The child node definition for '" + name + "' in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existingDef.getDeclaringNodeType() + "': ambiguous child node definition";
                        log.debug(msg);
                        throw new NodeTypeConflictException(msg);
                    }
                }
            } else {
                existingDefs = new ArrayList<ItemDef>();
                this.namedItemDefs.put(name, existingDefs);
            }
            existingDefs.add(def);
        }
        for (ItemDef def : defs = other.getUnnamedItemDefs()) {
            if (this.includesNodeType(def.getDeclaringNodeType())) continue;
            for (ItemDef existing : this.unnamedItemDefs) {
                if (def.definesNode() != existing.definesNode()) continue;
                if (!def.definesNode()) {
                    PropDef pd = (PropDef)def;
                    PropDef epd = (PropDef)existing;
                    if (pd.getRequiredType() != epd.getRequiredType() || pd.isMultiple() != epd.isMultiple()) continue;
                    msg = "A property definition in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existing.getDeclaringNodeType() + "': ambiguous residual property definition";
                    log.debug(msg);
                    throw new NodeTypeConflictException(msg);
                }
                NodeDef nd = (NodeDef)def;
                NodeDef end = (NodeDef)existing;
                if (!Arrays.equals(nd.getRequiredPrimaryTypes(), end.getRequiredPrimaryTypes()) || !(nd.getDefaultPrimaryType() == null ? end.getDefaultPrimaryType() == null : nd.getDefaultPrimaryType().equals(end.getDefaultPrimaryType()))) continue;
                msg = "A child node definition in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existing.getDeclaringNodeType() + "': ambiguous residual child node definition";
                log.debug(msg);
                throw new NodeTypeConflictException(msg);
            }
            this.unnamedItemDefs.add(def);
        }
        this.allNodeTypes.addAll(Arrays.asList(nta));
        if (supertype) {
            nta = other.getMergedNodeTypes();
            this.inheritedNodeTypes.addAll(Arrays.asList(nta));
            nta = other.getInheritedNodeTypes();
            this.inheritedNodeTypes.addAll(Arrays.asList(nta));
        } else {
            nta = other.getMergedNodeTypes();
            this.mergedNodeTypes.addAll(Arrays.asList(nta));
            nta = other.getInheritedNodeTypes();
            this.inheritedNodeTypes.addAll(Arrays.asList(nta));
        }
        if (other.hasOrderableChildNodes()) {
            this.orderableChildNodes = true;
        }
        if (this.primaryItemName == null && other.getPrimaryItemName() != null) {
            this.primaryItemName = other.getPrimaryItemName();
        }
    }

    protected Object clone() {
        EffectiveNodeType clone = new EffectiveNodeType();
        clone.mergedNodeTypes.addAll(this.mergedNodeTypes);
        clone.inheritedNodeTypes.addAll(this.inheritedNodeTypes);
        clone.allNodeTypes.addAll(this.allNodeTypes);
        for (Name name : this.namedItemDefs.keySet()) {
            List<ItemDef> list = this.namedItemDefs.get(name);
            clone.namedItemDefs.put(name, new ArrayList<ItemDef>(list));
        }
        clone.unnamedItemDefs.addAll(this.unnamedItemDefs);
        clone.orderableChildNodes = this.orderableChildNodes;
        clone.primaryItemName = this.primaryItemName;
        return clone;
    }
}

