/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data.db;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.db.DbDataStore;
import org.apache.jackrabbit.core.persistence.bundle.util.ConnectionRecoveryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pool {
    protected final int maxSize;
    protected final ArrayList<ConnectionRecoveryManager> all = new ArrayList();
    protected final DbDataStore factory;
    protected final LinkedBlockingQueue<ConnectionRecoveryManager> pool = new LinkedBlockingQueue();

    protected Pool(DbDataStore factory, int maxSize) {
        this.factory = factory;
        this.maxSize = Math.max(1, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionRecoveryManager get() throws InterruptedException, RepositoryException {
        ConnectionRecoveryManager o = this.pool.poll();
        if (o == null) {
            ArrayList<ConnectionRecoveryManager> arrayList = this.all;
            synchronized (arrayList) {
                if (this.all.size() < this.maxSize) {
                    o = this.factory.createNewConnection();
                    this.all.add(o);
                }
            }
            if (o == null) {
                o = this.pool.take();
            }
        }
        return o;
    }

    protected void add(ConnectionRecoveryManager o) throws InterruptedException {
        this.pool.put(o);
    }

    protected ArrayList<ConnectionRecoveryManager> getAll() {
        return this.all;
    }
}

