/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.BeanMap;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanConfig {
    private static Logger log = LoggerFactory.getLogger(BeanConfig.class);
    private static final Map<String, String> DEPRECATIONS;
    private static ClassLoader defaultClassLoader;
    private ClassLoader classLoader = BeanConfig.getDefaultClassLoader();
    private final String className;
    private final Properties properties;
    private boolean validate = true;

    public BeanConfig(String className, Properties properties) {
        if (DEPRECATIONS.containsKey(className)) {
            String replacement = DEPRECATIONS.get(className);
            log.info("{} is deprecated. Please use {} instead", (Object)className, (Object)replacement);
            className = replacement;
        }
        this.className = className;
        this.properties = (Properties)properties.clone();
    }

    public BeanConfig(BeanConfig config) {
        this(config.getClassName(), config.getParameters());
    }

    protected void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getClassName() {
        return this.className;
    }

    public Properties getParameters() {
        return this.properties;
    }

    public Object newInstance() throws ConfigurationException {
        try {
            Class<?> objectClass = Class.forName(this.getClassName(), true, this.getClassLoader());
            Object object = objectClass.newInstance();
            BeanMap map = new BeanMap(object);
            Iterator iterator = map.keyIterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                String string = this.properties.getProperty(name);
                if (string == null) continue;
                map.put(name, this.properties.getProperty(name));
            }
            if (this.validate) {
                for (String string : this.properties.keySet()) {
                    if (map.containsKey(string) || this.properties.getProperty(string) == null) continue;
                    String msg = "Configured class " + object.getClass().getName() + " does not contain the property " + string + ". Please fix the repository configuration.";
                    log.error(msg);
                    throw new ConfigurationException(msg);
                }
            }
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Configured bean implementation class " + this.getClassName() + " was not found.", e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Configured bean implementation class " + this.getClassName() + " can not be instantiated.", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Configured bean implementation class " + this.getClassName() + " is protected.", e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ClassLoader getDefaultClassLoader() {
        return defaultClassLoader;
    }

    public static void setDefaultClassLoader(ClassLoader classLoader) {
        defaultClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            HashMap<String, String> temp = new HashMap<String, String>();
            Properties props = new Properties();
            InputStream in = BeanConfig.class.getResourceAsStream("deprecated-classes.properties");
            try {
                props.load(in);
            }
            finally {
                in.close();
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                temp.put(entry.getKey().toString(), entry.getValue().toString());
            }
            DEPRECATIONS = Collections.unmodifiableMap(temp);
        }
        catch (IOException e) {
            throw new InternalError("failed to read deprecated classes");
        }
        defaultClassLoader = BeanConfig.class.getClassLoader();
    }
}

