/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.TransientRepository;

public class RepositoryFactoryImpl
implements RepositoryFactory {
    public static final String REPOSITORY_HOME = "org.apache.jackrabbit.repository.home";
    public static final String REPOSITORY_CONF = "org.apache.jackrabbit.repository.conf";
    private static final Map<String, JackrabbitRepository> REPOSITORY_INSTANCES = new HashMap<String, JackrabbitRepository>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(Map parameters) throws RepositoryException {
        JackrabbitRepository repo;
        Map<String, JackrabbitRepository> map = REPOSITORY_INSTANCES;
        synchronized (map) {
            if (parameters == null) {
                repo = this.getOrCreateRepository(null, null);
            } else if (parameters.containsKey(REPOSITORY_CONF) && parameters.containsKey(REPOSITORY_HOME)) {
                String conf = (String)parameters.get(REPOSITORY_CONF);
                String home = (String)parameters.get(REPOSITORY_HOME);
                repo = this.getOrCreateRepository(conf, home);
            } else {
                repo = null;
            }
        }
        return repo;
    }

    private JackrabbitRepository getOrCreateRepository(String conf, String home) throws RepositoryException {
        JackrabbitRepository repo = REPOSITORY_INSTANCES.get(home);
        if (repo == null) {
            TransientRepository tr;
            if (home == null) {
                tr = new TransientRepository();
                REPOSITORY_INSTANCES.put(null, tr);
            } else {
                tr = new TransientRepository(conf, home);
            }
            REPOSITORY_INSTANCES.put(tr.getHomeDir(), tr);
            repo = tr;
        }
        return repo;
    }
}

