/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Calendar;
import java.util.Set;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class NodeTypeInstanceHandler {
    public static final String DEFAULT_USERID = "system";
    private final String userId;

    public NodeTypeInstanceHandler(String userId) {
        this.userId = userId == null ? DEFAULT_USERID : userId;
    }

    public InternalValue[] computeSystemGeneratedPropertyValues(NodeState parent, PropDef def) {
        InternalValue[] genValues = null;
        Name name = def.getName();
        Name declaringNT = def.getDeclaringNodeType();
        if (NameConstants.JCR_UUID.equals(name)) {
            if (NameConstants.MIX_REFERENCEABLE.equals(declaringNT)) {
                genValues = new InternalValue[]{InternalValue.create(parent.getNodeId().toString())};
            }
        } else if (NameConstants.JCR_PRIMARYTYPE.equals(name)) {
            genValues = new InternalValue[]{InternalValue.create(parent.getNodeTypeName())};
        } else if (NameConstants.JCR_MIXINTYPES.equals(name)) {
            Set<Name> mixins = parent.getMixinTypeNames();
            genValues = new InternalValue[mixins.size()];
            int i = 0;
            for (Name n : mixins) {
                genValues[i++] = InternalValue.create(n);
            }
        } else if (NameConstants.JCR_CREATED.equals(name)) {
            if (NameConstants.MIX_CREATED.equals(declaringNT) || NameConstants.NT_VERSION.equals(declaringNT)) {
                genValues = new InternalValue[]{InternalValue.create(Calendar.getInstance())};
            }
        } else if (NameConstants.JCR_CREATEDBY.equals(name)) {
            if (NameConstants.MIX_CREATED.equals(declaringNT)) {
                genValues = new InternalValue[]{InternalValue.create(this.userId)};
            }
        } else if (NameConstants.JCR_LASTMODIFIED.equals(name)) {
            if (NameConstants.MIX_LASTMODIFIED.equals(declaringNT)) {
                genValues = new InternalValue[]{InternalValue.create(Calendar.getInstance())};
            }
        } else if (NameConstants.JCR_LASTMODIFIEDBY.equals(name)) {
            if (NameConstants.MIX_LASTMODIFIED.equals(declaringNT)) {
                genValues = new InternalValue[]{InternalValue.create(this.userId)};
            }
        } else if (NameConstants.JCR_ETAG.equals(name) && NameConstants.MIX_ETAG.equals(declaringNT)) {
            genValues = new InternalValue[]{InternalValue.create("")};
        }
        return genValues;
    }
}

