/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyItemIterator
implements NodeIterator,
PropertyIterator {
    private static Logger log = LoggerFactory.getLogger(LazyItemIterator.class);
    private final ItemManager itemMgr;
    private final List<ItemId> idList;
    private final NodeId parentId;
    private int pos;
    private Item next;

    public LazyItemIterator(ItemManager itemMgr, List<? extends ItemId> idList) {
        this(itemMgr, idList, null);
    }

    public LazyItemIterator(ItemManager itemMgr, List<? extends ItemId> idList, NodeId parentId) {
        this.itemMgr = itemMgr;
        this.idList = new ArrayList<ItemId>(idList);
        this.parentId = parentId;
        this.pos = 0;
        this.prefetchNext();
    }

    private void prefetchNext() {
        this.next = null;
        while (this.next == null && this.pos < this.idList.size()) {
            ItemId id = this.idList.get(this.pos);
            try {
                if (this.parentId != null) {
                    this.next = this.itemMgr.getNode((NodeId)id, this.parentId);
                    continue;
                }
                this.next = this.itemMgr.getItem(id);
            }
            catch (ItemNotFoundException e) {
                log.debug("ignoring nonexistent item " + id);
                this.idList.remove(this.pos);
            }
            catch (AccessDeniedException e) {
                log.debug("ignoring nonexistent item " + id);
                this.idList.remove(this.pos);
            }
            catch (RepositoryException e) {
                log.error("failed to fetch item " + id + ", skipping...", e);
                this.idList.remove(this.pos);
            }
        }
    }

    @Override
    public Node nextNode() {
        return (Node)this.next();
    }

    @Override
    public Property nextProperty() {
        return (Property)this.next();
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public long getSize() {
        return this.idList.size();
    }

    @Override
    public void skip(long skipNum) {
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must not be negative");
        }
        if (skipNum == 0L) {
            return;
        }
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.next = null;
        while (--skipNum > 0L) {
            ++this.pos;
            if (this.pos >= this.idList.size()) {
                throw new NoSuchElementException();
            }
            ItemId id = this.idList.get(this.pos);
            while (!this.itemMgr.itemExists(id)) {
                log.debug("ignoring nonexistent item " + id);
                this.idList.remove(this.pos);
                if (this.pos >= this.idList.size()) {
                    throw new NoSuchElementException();
                }
                id = this.idList.get(this.pos);
            }
        }
        ++this.pos;
        this.prefetchNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Item item = this.next;
        ++this.pos;
        this.prefetchNext();
        return item;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

