/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import org.apache.jackrabbit.commons.iterator.NodeIterable;
import org.apache.jackrabbit.commons.iterator.PropertyIterable;
import org.apache.jackrabbit.commons.iterator.RowIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrUtils {
    private JcrUtils() {
    }

    public static Iterable<Node> getSharedSet(Node node) throws RepositoryException {
        return new NodeIterable(node.getSharedSet());
    }

    public static Iterable<Node> getChildNodes(Node node) throws RepositoryException {
        return new NodeIterable(node.getNodes());
    }

    public static Iterable<Node> getChildNodes(Node node, String pattern) throws RepositoryException {
        return new NodeIterable(node.getNodes(pattern));
    }

    public static Iterable<Node> getChildNodes(Node node, String[] globs) throws RepositoryException {
        return new NodeIterable(node.getNodes(globs));
    }

    public static Iterable<Property> getProperties(Node node) throws RepositoryException {
        return new PropertyIterable(node.getProperties());
    }

    public static Iterable<Property> getProperties(Node node, String pattern) throws RepositoryException {
        return new PropertyIterable(node.getProperties(pattern));
    }

    public static Iterable<Property> getProperties(Node node, String[] globs) throws RepositoryException {
        return new PropertyIterable(node.getProperties(globs));
    }

    public static Iterable<Property> getReferences(Node node) throws RepositoryException {
        return new PropertyIterable(node.getReferences());
    }

    public static Iterable<Property> getReferences(Node node, String name) throws RepositoryException {
        return new PropertyIterable(node.getReferences(name));
    }

    public static Iterable<Property> getWeakReferences(Node node) throws RepositoryException {
        return new PropertyIterable(node.getWeakReferences());
    }

    public static Iterable<Property> getWeakReferences(Node node, String name) throws RepositoryException {
        return new PropertyIterable(node.getWeakReferences(name));
    }

    public static Iterable<Node> getNodes(QueryResult result) throws RepositoryException {
        return new NodeIterable(result.getNodes());
    }

    public static Iterable<Row> getRows(QueryResult result) throws RepositoryException {
        return new RowIterable(result.getRows());
    }
}

