/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.types.XMLDataValue;
import org.apache.xalan.serialize.DOMSerializer;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SqlXmlUtil
implements Formatable {
    private DocumentBuilder dBuilder;
    private Serializer serializer;
    private XPath query;
    private XPathContext xpContext;
    private String queryExpr;
    private String opName;
    private boolean recompileQuery;

    public SqlXmlUtil() throws StandardException {
        try {
            DocumentBuilderFactory documentBuilderFactory = null;
            try {
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
            }
            catch (Throwable throwable) {
                throw StandardException.newException("XML00", "JAXP");
            }
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            this.dBuilder = documentBuilderFactory.newDocumentBuilder();
            this.dBuilder.setErrorHandler(new XMLErrorHandler());
            this.loadSerializer();
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.newException("XML01", throwable, (Object)throwable.getMessage());
        }
        this.query = null;
    }

    public void compileXQExpr(String string, String string2) throws StandardException {
        try {
            this.query = new XPath(string, null, (PrefixResolver)new PrefixResolverDefault((Node)this.dBuilder.newDocument()), 0);
            this.queryExpr = string;
            this.opName = string2;
            this.recompileQuery = false;
        }
        catch (Throwable throwable) {
            throw StandardException.newException("10000", throwable, (Object)string2, (Object)throwable.getMessage());
        }
    }

    protected String serializeToString(String string) throws Exception {
        ArrayList<Document> arrayList = new ArrayList<Document>();
        arrayList.add(this.dBuilder.parse(new InputSource(new StringReader(string))));
        return this.serializeToString(arrayList, null);
    }

    protected String serializeToString(ArrayList arrayList, XMLDataValue xMLDataValue) throws IOException {
        if (arrayList == null || arrayList.size() == 0) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        this.serializer.setWriter((Writer)stringWriter);
        DOMSerializer dOMSerializer = this.serializer.asDOMSerializer();
        int n = arrayList.size();
        Object var6_6 = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            var6_6 = arrayList.get(i);
            if (var6_6 instanceof String) {
                if (bl) {
                    stringWriter.write(" ");
                }
                stringWriter.write((String)var6_6);
                bl = true;
                continue;
            }
            if (var6_6 instanceof Attr) {
                if (xMLDataValue != null) {
                    xMLDataValue.markAsHavingTopLevelAttr();
                }
                dOMSerializer.serialize((Node)var6_6);
                bl = false;
                continue;
            }
            Node node = var6_6;
            if (node instanceof Text) {
                stringWriter.write(node.getNodeValue());
            } else {
                dOMSerializer.serialize(node);
            }
            bl = false;
        }
        stringWriter.flush();
        return stringWriter.toString();
    }

    protected ArrayList evalXQExpression(XMLDataValue xMLDataValue, boolean bl, int[] nArray) throws Exception {
        if (this.recompileQuery) {
            this.compileXQExpr(this.queryExpr, this.opName);
        }
        if (xMLDataValue.getXType() != 0) {
            throw StandardException.newException("2200V", bl ? "XMLQUERY" : "XMLEXISTS");
        }
        Document document = null;
        document = this.dBuilder.parse(new InputSource(new StringReader(xMLDataValue.getString())));
        this.getXPathContext();
        this.xpContext.reset();
        XObject xObject = this.query.execute(this.xpContext, (Node)document, null);
        if (!bl) {
            if (xObject instanceof XNodeSet && ((XNodeSet)xObject).nodelist().getLength() > 0) {
                return new ArrayList(0);
            }
            if (!(xObject instanceof XNodeSet)) {
                return new ArrayList(0);
            }
            return null;
        }
        NodeList nodeList = null;
        int n = 0;
        if (!(xObject instanceof XNodeSet)) {
            n = 1;
        } else {
            nodeList = xObject.nodelist();
            n = nodeList.getLength();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (nodeList == null) {
            arrayList.add(xObject.str());
        } else {
            for (int i = 0; i < n; ++i) {
                arrayList.add(nodeList.item(i));
            }
        }
        nodeList = null;
        nArray[0] = n == 1 && arrayList.get(0) instanceof Document ? 0 : 1;
        return arrayList;
    }

    private XPathContext getXPathContext() {
        if (this.xpContext == null) {
            this.xpContext = new XPathContext();
        }
        return this.xpContext;
    }

    private void loadSerializer() throws IOException {
        StringWriter stringWriter = new StringWriter();
        Properties properties = OutputProperties.getDefaultMethodProperties((String)"xml");
        properties.setProperty("method", "xml");
        properties.setProperty("omit-xml-declaration", "yes");
        properties.setProperty("encoding", "UTF-8");
        this.serializer = SerializerFactory.getSerializer((Properties)properties);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.query == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(this.queryExpr);
            objectOutput.writeObject(this.opName);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput.readBoolean()) {
            this.queryExpr = (String)objectInput.readObject();
            this.opName = (String)objectInput.readObject();
            this.recompileQuery = true;
        }
    }

    public int getTypeFormatId() {
        return 464;
    }

    private class XMLErrorHandler
    implements ErrorHandler {
        private XMLErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }
    }
}

