/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherBoolProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRGBProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherSpgrRecord;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.record.EscherTextboxWrapper;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public class PPDrawing
extends RecordAtom {
    private byte[] _header = new byte[8];
    private long _type;
    private EscherRecord[] childRecords;
    private EscherTextboxWrapper[] textboxWrappers;
    private EscherDgRecord dg;

    public EscherRecord[] getEscherRecords() {
        return this.childRecords;
    }

    public EscherTextboxWrapper[] getTextboxWrappers() {
        return this.textboxWrappers;
    }

    protected PPDrawing(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._type = LittleEndian.getUShort(this._header, 2);
        byte[] contents = new byte[len];
        System.arraycopy(source, start, contents, 0, len);
        DefaultEscherRecordFactory erf = new DefaultEscherRecordFactory();
        Vector escherChildren = new Vector();
        this.findEscherChildren(erf, contents, 8, len - 8, escherChildren);
        this.childRecords = new EscherRecord[escherChildren.size()];
        for (int i = 0; i < this.childRecords.length; ++i) {
            this.childRecords[i] = (EscherRecord)escherChildren.get(i);
        }
        Vector textboxes = new Vector();
        this.findEscherTextboxRecord(this.childRecords, textboxes);
        this.textboxWrappers = new EscherTextboxWrapper[textboxes.size()];
        for (int i = 0; i < this.textboxWrappers.length; ++i) {
            this.textboxWrappers[i] = (EscherTextboxWrapper)textboxes.get(i);
        }
    }

    public PPDrawing() {
        LittleEndian.putUShort(this._header, 0, 15);
        LittleEndian.putUShort(this._header, 2, RecordTypes.PPDrawing.typeID);
        LittleEndian.putInt(this._header, 4, 0);
        this.textboxWrappers = new EscherTextboxWrapper[0];
        this.create();
    }

    private void findEscherChildren(DefaultEscherRecordFactory erf, byte[] source, int startPos, int lenToGo, Vector found) {
        int escherBytes = LittleEndian.getInt(source, startPos + 4) + 8;
        EscherRecord r = erf.createRecord(source, startPos);
        r.fillFields(source, startPos, erf);
        found.add(r);
        int size = r.getRecordSize();
        if (size < 8) {
            this.logger.log(5, "Hit short DDF record at " + startPos + " - " + size);
        }
        if (size != escherBytes) {
            this.logger.log(5, "Record length=" + escherBytes + " but getRecordSize() returned " + r.getRecordSize() + "; record: " + r.getClass());
            size = escherBytes;
        }
        startPos += size;
        if ((lenToGo -= size) >= 8) {
            this.findEscherChildren(erf, source, startPos, lenToGo, found);
        }
    }

    private void findEscherTextboxRecord(EscherRecord[] toSearch, Vector found) {
        block0: for (int i = 0; i < toSearch.length; ++i) {
            int j;
            if (toSearch[i] instanceof EscherTextboxRecord) {
                EscherTextboxRecord tbr = (EscherTextboxRecord)toSearch[i];
                EscherTextboxWrapper w = new EscherTextboxWrapper(tbr);
                found.add(w);
                for (j = i; j >= 0; --j) {
                    if (!(toSearch[j] instanceof EscherSpRecord)) continue;
                    EscherSpRecord sp = (EscherSpRecord)toSearch[j];
                    w.setShapeId(sp.getShapeId());
                    continue block0;
                }
                continue;
            }
            if (!toSearch[i].isContainerRecord()) continue;
            List childrenL = toSearch[i].getChildRecords();
            EscherRecord[] children = new EscherRecord[childrenL.size()];
            for (j = 0; j < children.length; ++j) {
                children[j] = (EscherRecord)childrenL.get(j);
            }
            this.findEscherTextboxRecord(children, found);
        }
    }

    public long getRecordType() {
        return this._type;
    }

    public Record[] getChildRecords() {
        return null;
    }

    public void writeOut(OutputStream out) throws IOException {
        for (int i = 0; i < this.textboxWrappers.length; ++i) {
            this.textboxWrappers[i].writeOut(null);
        }
        int newSize = 0;
        for (int i = 0; i < this.childRecords.length; ++i) {
            newSize += this.childRecords[i].getRecordSize();
        }
        LittleEndian.putInt(this._header, 4, newSize);
        out.write(this._header);
        byte[] b = new byte[newSize];
        int done = 0;
        for (int i = 0; i < this.childRecords.length; ++i) {
            int written = this.childRecords[i].serialize(done, b);
            done += written;
        }
        out.write(b);
    }

    private void create() {
        EscherContainerRecord dgContainer = new EscherContainerRecord();
        dgContainer.setRecordId((short)-4094);
        dgContainer.setOptions((short)15);
        EscherDgRecord dg = new EscherDgRecord();
        dg.setOptions((short)16);
        dg.setNumShapes(1);
        dgContainer.addChildRecord(dg);
        EscherContainerRecord spgrContainer = new EscherContainerRecord();
        spgrContainer.setOptions((short)15);
        spgrContainer.setRecordId((short)-4093);
        EscherContainerRecord spContainer = new EscherContainerRecord();
        spContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        EscherSpgrRecord spgr = new EscherSpgrRecord();
        spgr.setOptions((short)1);
        spContainer.addChildRecord(spgr);
        EscherSpRecord sp = new EscherSpRecord();
        sp.setOptions((short)2);
        sp.setFlags(5);
        spContainer.addChildRecord(sp);
        spgrContainer.addChildRecord(spContainer);
        dgContainer.addChildRecord(spgrContainer);
        spContainer = new EscherContainerRecord();
        spContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        sp = new EscherSpRecord();
        sp.setOptions((short)18);
        sp.setFlags(3072);
        spContainer.addChildRecord(sp);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-4085);
        opt.addEscherProperty(new EscherRGBProperty(385, 0x8000000));
        opt.addEscherProperty(new EscherRGBProperty(387, 0x8000005));
        opt.addEscherProperty(new EscherSimpleProperty(403, 10064750));
        opt.addEscherProperty(new EscherSimpleProperty(404, 7778750));
        opt.addEscherProperty(new EscherBoolProperty(447, 0x120012));
        opt.addEscherProperty(new EscherBoolProperty(511, 524288));
        opt.addEscherProperty(new EscherSimpleProperty(772, 9));
        opt.addEscherProperty(new EscherSimpleProperty(831, 65537));
        spContainer.addChildRecord(opt);
        dgContainer.addChildRecord(spContainer);
        this.childRecords = new EscherRecord[]{dgContainer};
    }

    public void addTextboxWrapper(EscherTextboxWrapper txtbox) {
        EscherTextboxWrapper[] tw = new EscherTextboxWrapper[this.textboxWrappers.length + 1];
        System.arraycopy(this.textboxWrappers, 0, tw, 0, this.textboxWrappers.length);
        tw[this.textboxWrappers.length] = txtbox;
        this.textboxWrappers = tw;
    }

    public EscherDgRecord getEscherDgRecord() {
        if (this.dg == null) {
            EscherContainerRecord dgContainer = (EscherContainerRecord)this.childRecords[0];
            Iterator it = dgContainer.getChildRecords().iterator();
            while (it.hasNext()) {
                EscherRecord r = (EscherRecord)it.next();
                if (!(r instanceof EscherDgRecord)) continue;
                this.dg = (EscherDgRecord)r;
                break;
            }
        }
        return this.dg;
    }
}

