/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.io;

import javax.jcr.Item;
import org.apache.jackrabbit.server.io.DefaultIOListener;
import org.apache.jackrabbit.server.io.ExportContext;
import org.apache.jackrabbit.server.io.IOListener;
import org.apache.jackrabbit.server.io.IOUtil;
import org.apache.jackrabbit.server.io.MimeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExportContext
implements ExportContext {
    private static Logger log = LoggerFactory.getLogger(AbstractExportContext.class);
    private final IOListener ioListener;
    private final Item exportRoot;
    private final boolean hasStream;
    private final MimeResolver mimeResolver;
    protected boolean completed;

    public AbstractExportContext(Item exportRoot, boolean hasStream, IOListener ioListener) {
        this(exportRoot, hasStream, ioListener, null);
    }

    public AbstractExportContext(Item exportRoot, boolean hasStream, IOListener ioListener, MimeResolver mimeResolver) {
        this.exportRoot = exportRoot;
        this.hasStream = hasStream;
        this.ioListener = ioListener != null ? ioListener : new DefaultIOListener(log);
        this.mimeResolver = mimeResolver != null ? mimeResolver : IOUtil.MIME_RESOLVER;
    }

    public IOListener getIOListener() {
        return this.ioListener;
    }

    public Item getExportRoot() {
        return this.exportRoot;
    }

    public MimeResolver getMimeResolver() {
        return this.mimeResolver;
    }

    public boolean hasStream() {
        return this.hasStream;
    }

    public void informCompleted(boolean success) {
        this.completed = true;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    protected void checkCompleted() {
        if (this.completed) {
            throw new IllegalStateException("ExportContext has already been finalized.");
        }
    }
}

