/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.join.AbstractCondition;
import org.apache.jackrabbit.core.query.lucene.join.ScoreNodeMap;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;

public class EquiJoin
extends AbstractCondition {
    private final ScoreDoc sDoc = new ScoreDoc(-1, 1.0f);
    private final IndexReader reader;
    private final ScoreNodeMap innerScoreNodes = new ScoreNodeMap();
    private final ScoreDocComparator outerLookup;

    public EquiJoin(MultiColumnQueryHits inner, int innerScoreNodeIndex, SortComparatorSource scs, IndexReader reader, Name innerProperty, Name outerProperty) throws IOException {
        super(inner);
        ScoreNode[] nodes;
        this.reader = reader;
        this.outerLookup = scs.newComparator(reader, outerProperty.toString());
        ScoreDocComparator comparator = scs.newComparator(reader, innerProperty.toString());
        while ((nodes = inner.nextScoreNodes()) != null) {
            Integer doc = new Integer(nodes[innerScoreNodeIndex].getDoc(reader));
            this.sDoc.doc = doc;
            Comparable value = comparator.sortValue(this.sDoc);
            if (value == null) continue;
            this.innerScoreNodes.addScoreNodes(value, nodes);
        }
    }

    public ScoreNode[][] getMatchingScoreNodes(ScoreNode outer) throws IOException {
        this.sDoc.doc = outer.getDoc(this.reader);
        Comparable value = this.outerLookup.sortValue(this.sDoc);
        return this.innerScoreNodes.getScoreNodes(value);
    }
}

