/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.constraint.DynamicOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;

public class LowerCaseOperand
extends DynamicOperand {
    private final DynamicOperand operand;

    public LowerCaseOperand(DynamicOperand operand) {
        this.operand = operand;
    }

    public Value[] getValues(ScoreNode sn, EvaluationContext context) throws IOException {
        try {
            ValueFactory vf = context.getSession().getValueFactory();
            Value[] values = this.operand.getValues(sn, context);
            for (int i = 0; i < values.length; ++i) {
                values[i] = vf.createValue(values[i].getString().toLowerCase());
            }
            return values;
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
    }
}

