/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.Calendar;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.api.jsr283.observation.EventIterator;
import org.apache.jackrabbit.core.observation.EventFilter;
import org.apache.jackrabbit.core.observation.EventImpl;
import org.apache.jackrabbit.core.observation.EventState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilteredEventIterator
implements EventIterator {
    private static final Logger log = LoggerFactory.getLogger(FilteredEventIterator.class);
    private final Iterator actualEvents;
    private final EventFilter filter;
    private final Set denied;
    private Event next;
    private long pos = 0L;
    private long timestamp;
    private final String userData;

    public FilteredEventIterator(Iterator eventStates, long timestamp, String userData, EventFilter filter, Set denied) {
        this.actualEvents = eventStates;
        this.filter = filter;
        this.denied = denied;
        this.timestamp = timestamp;
        this.userData = userData;
        this.fetchNext();
    }

    public Object next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Event e = this.next;
        this.fetchNext();
        ++this.pos;
        return e;
    }

    public Event nextEvent() {
        return (Event)this.next();
    }

    public void skip(long skipNum) {
        while (skipNum-- > 0L) {
            this.next();
        }
    }

    public Calendar getDate() {
        throw new RuntimeException("Not implemented yet, see JCR-2086");
    }

    public long getSize() {
        return -1L;
    }

    public long getPosition() {
        return this.pos;
    }

    public void remove() {
        throw new UnsupportedOperationException("EventIterator.remove()");
    }

    public boolean hasNext() {
        return this.next != null;
    }

    private void fetchNext() {
        this.next = null;
        while (this.next == null && this.actualEvents.hasNext()) {
            EventState state = (EventState)this.actualEvents.next();
            if (this.denied != null && this.denied.contains(state.getTargetId())) continue;
            try {
                this.next = this.filter.blocks(state) ? null : new EventImpl(this.filter.getSession(), state, this.timestamp, this.userData);
            }
            catch (RepositoryException e) {
                log.error("Exception while applying filter.", e);
            }
        }
    }
}

