/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.api.jsr283.nodetype.NodeDefinitionTemplate;
import org.apache.jackrabbit.core.nodetype.AbstractItemDefinitionTemplate;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

class NodeDefinitionTemplateImpl
extends AbstractItemDefinitionTemplate
implements NodeDefinitionTemplate {
    private NodeType[] requiredPrimaryTypes;
    private String[] requiredPrimaryTypeNames;
    private String defaultPrimaryTypeName;
    private boolean allowSameNameSiblings;

    NodeDefinitionTemplateImpl(NodeTypeManagerImpl ntMgr) throws RepositoryException {
        this.requiredPrimaryTypes = new NodeType[]{ntMgr.getNodeType(NameConstants.NT_BASE)};
        this.requiredPrimaryTypeNames = new String[]{this.requiredPrimaryTypes[0].getName()};
    }

    NodeDefinitionTemplateImpl(NodeDefinition def) {
        super(def);
        this.requiredPrimaryTypes = def.getRequiredPrimaryTypes();
        this.requiredPrimaryTypeNames = new String[this.requiredPrimaryTypes.length];
        for (int i = 0; i < this.requiredPrimaryTypes.length; ++i) {
            this.requiredPrimaryTypeNames[i] = this.requiredPrimaryTypes[i].getName();
        }
        this.defaultPrimaryTypeName = def.getDefaultPrimaryType() == null ? null : def.getDefaultPrimaryType().getName();
        this.allowSameNameSiblings = def.allowsSameNameSiblings();
    }

    public void setRequiredPrimaryTypeNames(String[] requiredPrimaryTypeNames) {
        this.requiredPrimaryTypeNames = requiredPrimaryTypeNames;
    }

    public void setDefaultPrimaryTypeName(String defaultPrimaryType) {
        this.defaultPrimaryTypeName = defaultPrimaryType;
    }

    public void setSameNameSiblings(boolean allowSameNameSiblings) {
        this.allowSameNameSiblings = allowSameNameSiblings;
    }

    public NodeType[] getRequiredPrimaryTypes() {
        return this.requiredPrimaryTypes;
    }

    public String[] getRequiredPrimaryTypeNames() {
        return this.requiredPrimaryTypeNames;
    }

    public NodeType getDefaultPrimaryType() {
        return null;
    }

    public String getDefaultPrimaryTypeName() {
        return this.defaultPrimaryTypeName;
    }

    public boolean allowsSameNameSiblings() {
        return this.allowSameNameSiblings;
    }
}

