/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class BatchUtils {
    private static final Namespace SV_NAMESPACE = Namespace.getNamespace((String)"sv", (String)"http://www.jcp.org/jcr/sv/1.0");
    private static final String NODE_ELEMENT = "node";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String VALUE_ELEMENT = "value";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String TYPE_ATTRIBUTE = "type";

    private BatchUtils() {
    }

    static Element createNodeElement(Node parent, Name nodeName, Name primaryTypeName, String uniqueId, NamePathResolver resolver) throws NamespaceException {
        Element nodeElement = DomUtil.addChildElement((Node)parent, (String)NODE_ELEMENT, (Namespace)SV_NAMESPACE);
        String nameAttr = resolver.getJCRName(nodeName);
        DomUtil.setAttribute((Element)nodeElement, (String)NAME_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)nameAttr);
        Element propElement = DomUtil.addChildElement((Element)nodeElement, (String)PROPERTY_ELEMENT, (Namespace)SV_NAMESPACE);
        String name = resolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
        DomUtil.setAttribute((Element)propElement, (String)NAME_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)name);
        DomUtil.setAttribute((Element)propElement, (String)TYPE_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)PropertyType.nameFromValue((int)7));
        name = resolver.getJCRName(primaryTypeName);
        DomUtil.addChildElement((Element)propElement, (String)VALUE_ELEMENT, (Namespace)SV_NAMESPACE, (String)name);
        if (uniqueId != null) {
            propElement = DomUtil.addChildElement((Element)nodeElement, (String)PROPERTY_ELEMENT, (Namespace)SV_NAMESPACE);
            name = resolver.getJCRName(NameConstants.JCR_UUID);
            DomUtil.setAttribute((Element)propElement, (String)NAME_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)name);
            DomUtil.setAttribute((Element)propElement, (String)TYPE_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)PropertyType.nameFromValue((int)1));
            DomUtil.addChildElement((Element)propElement, (String)VALUE_ELEMENT, (Namespace)SV_NAMESPACE, (String)uniqueId);
        }
        return nodeElement;
    }

    static void importProperty(Element nodeElement, Name propertyName, int type, QValue[] values, NamePathResolver resolver) throws RepositoryException {
        Element propElement = DomUtil.addChildElement((Element)nodeElement, (String)PROPERTY_ELEMENT, (Namespace)SV_NAMESPACE);
        DomUtil.setAttribute((Element)propElement, (String)NAME_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)resolver.getJCRName(propertyName));
        DomUtil.setAttribute((Element)propElement, (String)TYPE_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)PropertyType.nameFromValue((int)type));
        for (QValue value : values) {
            DomUtil.addChildElement((Element)propElement, (String)VALUE_ELEMENT, (Namespace)SV_NAMESPACE, (String)value.getString());
        }
    }
}

