/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.value;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.apache.jackrabbit.uuid.UUID;

public final class QValueFactoryImpl
implements QValueFactory {
    private static final QValueFactory INSTANCE = new QValueFactoryImpl();
    private static final PathFactory PATH_FACTORY = PathFactoryImpl.getInstance();
    private static final NameFactory NAME_FACTORY = NameFactoryImpl.getInstance();
    private static final String DEFAULT_ENCODING = "UTF-8";

    private QValueFactoryImpl() {
    }

    public static QValueFactory getInstance() {
        return INSTANCE;
    }

    public QValue create(String value, int type) throws RepositoryException {
        if (value == null) {
            throw new IllegalArgumentException("Cannot create QValue from null value.");
        }
        try {
            switch (type) {
                case 6: {
                    return new QValueImpl(Boolean.valueOf(value));
                }
                case 5: {
                    Calendar cal = ISO8601.parse((String)value);
                    if (cal == null) {
                        throw new ValueFormatException("not a valid date: " + value);
                    }
                    return new DateQValue(cal);
                }
                case 4: {
                    return new QValueImpl(Double.valueOf(value));
                }
                case 3: {
                    return new QValueImpl(Long.valueOf(value));
                }
                case 8: {
                    return new QValueImpl(PATH_FACTORY.create(value));
                }
                case 7: {
                    return new QValueImpl(NAME_FACTORY.create(value));
                }
                case 1: 
                case 9: {
                    return new QValueImpl(value, type);
                }
                case 2: {
                    return new BinaryQValue(value.getBytes(DEFAULT_ENCODING));
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ValueFormatException((Throwable)ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RepositoryException((Throwable)ex);
        }
        throw new IllegalArgumentException("illegal type " + type);
    }

    public QValue create(Calendar value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot create QValue from null value.");
        }
        return new DateQValue((Calendar)value.clone());
    }

    public QValue create(double value) {
        return new QValueImpl(new Double(value));
    }

    public QValue create(long value) {
        return new QValueImpl(new Long(value));
    }

    public QValue create(Name value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot create QValue from null value.");
        }
        return new QValueImpl(value);
    }

    public QValue create(Path value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot create QValue from null value.");
        }
        return new QValueImpl(value);
    }

    public QValue create(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot create QValue from null value.");
        }
        return new BinaryQValue(value);
    }

    public QValue create(InputStream value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Cannot create QValue from null value.");
        }
        return new BinaryQValue(value);
    }

    public QValue create(File value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Cannot create QValue from null value.");
        }
        return new BinaryQValue(value);
    }

    public QValue[] computeAutoValues(QPropertyDefinition propertyDefinition) throws RepositoryException {
        Name nodeType = propertyDefinition.getDeclaringNodeType();
        Name name = propertyDefinition.getName();
        if (NameConstants.NT_HIERARCHYNODE.equals(nodeType) && NameConstants.JCR_CREATED.equals(name)) {
            return new QValue[]{this.create(Calendar.getInstance())};
        }
        if (NameConstants.NT_RESOURCE.equals(nodeType) && NameConstants.JCR_LASTMODIFIED.equals(name)) {
            return new QValue[]{this.create(Calendar.getInstance())};
        }
        if (NameConstants.MIX_REFERENCEABLE.equals(nodeType) && NameConstants.JCR_UUID.equals(name)) {
            return new QValue[]{this.create(UUID.randomUUID().toString(), 1)};
        }
        throw new RepositoryException("createFromDefinition not implemented for: " + name);
    }

    private static class BinaryQValue
    implements QValue,
    Serializable {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private static final int MAX_BUFFER_SIZE = 65536;
        private transient File file;
        private transient boolean temp;
        private byte[] buffer = EMPTY_BYTE_ARRAY;
        private transient String text = null;

        private BinaryQValue(InputStream in) throws IOException {
            this(in, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BinaryQValue(InputStream in, boolean temp) throws IOException {
            byte[] spoolBuffer = new byte[8192];
            int len = 0;
            OutputStream out = null;
            File spoolFile = null;
            try {
                int read;
                while ((read = in.read(spoolBuffer)) > 0) {
                    if (out != null) {
                        out.write(spoolBuffer, 0, read);
                        len += read;
                        continue;
                    }
                    if (len + read > 65536) {
                        TransientFileFactory fileFactory = TransientFileFactory.getInstance();
                        spoolFile = fileFactory.createTransientFile("bin", null, null);
                        out = new FileOutputStream(spoolFile);
                        out.write(this.buffer, 0, len);
                        out.write(spoolBuffer, 0, read);
                        this.buffer = null;
                        len += read;
                        continue;
                    }
                    byte[] newBuffer = new byte[len + read];
                    System.arraycopy(this.buffer, 0, newBuffer, 0, len);
                    System.arraycopy(spoolBuffer, 0, newBuffer, len, read);
                    this.buffer = newBuffer;
                    len += read;
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            this.file = spoolFile;
            this.temp = temp;
        }

        private BinaryQValue(byte[] bytes) {
            this.buffer = bytes;
            this.file = null;
            this.temp = false;
        }

        private BinaryQValue(File file) throws IOException {
            String path = file.getCanonicalPath();
            if (!file.isFile()) {
                throw new IOException(path + ": the specified file does not exist");
            }
            if (!file.canRead()) {
                throw new IOException(path + ": the specified file can not be read");
            }
            this.file = file;
            this.temp = false;
        }

        public int getType() {
            return 2;
        }

        public long getLength() {
            if (this.file != null) {
                if (this.file.exists()) {
                    return this.file.length();
                }
                return -1L;
            }
            return this.buffer.length;
        }

        public String getString() throws RepositoryException {
            if (this.text == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    this.spool(out);
                    byte[] data = out.toByteArray();
                    this.text = new String(data, QValueFactoryImpl.DEFAULT_ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RepositoryException("UTF-8 not supported on this platform", (Throwable)e);
                }
                catch (IOException e) {
                    throw new ValueFormatException("conversion from stream to string failed", (Throwable)e);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
            return this.text;
        }

        public InputStream getStream() throws RepositoryException {
            if (this.file != null) {
                try {
                    return new FileInputStream(this.file);
                }
                catch (FileNotFoundException fnfe) {
                    throw new RepositoryException("file backing binary value not found", (Throwable)fnfe);
                }
            }
            return new ByteArrayInputStream(this.buffer);
        }

        public Name getName() throws RepositoryException {
            throw new UnsupportedOperationException();
        }

        public Calendar getCalendar() throws RepositoryException {
            Calendar cal = ISO8601.parse((String)this.getString());
            if (cal == null) {
                throw new ValueFormatException("not a date string: " + this.getString());
            }
            return cal;
        }

        public double getDouble() throws RepositoryException {
            try {
                return Double.parseDouble(this.getString());
            }
            catch (NumberFormatException ex) {
                throw new ValueFormatException((Throwable)ex);
            }
        }

        public long getLong() throws RepositoryException {
            try {
                return Long.parseLong(this.getString());
            }
            catch (NumberFormatException ex) {
                throw new ValueFormatException((Throwable)ex);
            }
        }

        public Path getPath() throws RepositoryException {
            throw new UnsupportedOperationException();
        }

        public void discard() {
            if (!this.temp) {
                return;
            }
            if (this.file != null) {
                this.file.delete();
            } else if (this.buffer != null) {
                this.buffer = EMPTY_BYTE_ARRAY;
            }
        }

        public String toString() {
            if (this.file != null) {
                return this.file.toString();
            }
            return this.buffer.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BinaryQValue) {
                BinaryQValue other = (BinaryQValue)obj;
                return (this.file == null ? other.file == null : this.file.equals(other.file)) && Arrays.equals(this.buffer, other.buffer);
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void spool(OutputStream out) throws RepositoryException, IOException {
            InputStream in;
            if (this.file != null) {
                try {
                    in = new FileInputStream(this.file);
                }
                catch (FileNotFoundException fnfe) {
                    throw new RepositoryException("file backing binary value not found", (Throwable)fnfe);
                }
            } else {
                in = new ByteArrayInputStream(this.buffer);
            }
            try {
                int read;
                byte[] buffer = new byte[8192];
                while ((read = in.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeBoolean(this.file != null);
            if (this.file != null) {
                int bytes;
                byte[] buffer = new byte[4096];
                FileInputStream stream = new FileInputStream(this.file);
                while ((bytes = ((InputStream)stream).read(buffer)) >= 0) {
                    if (bytes <= 0) continue;
                    out.writeInt(bytes);
                    out.write(buffer, 0, bytes);
                }
                out.writeInt(0);
                ((InputStream)stream).close();
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            boolean hasFile = in.readBoolean();
            if (hasFile) {
                this.file = File.createTempFile("binary-qvalue", "bin");
                FileOutputStream out = new FileOutputStream(this.file);
                byte[] buffer = new byte[4096];
                int bytes = in.readInt();
                while (bytes > 0) {
                    if (buffer.length < bytes) {
                        buffer = new byte[bytes];
                    }
                    in.readFully(buffer, 0, bytes);
                    ((OutputStream)out).write(buffer, 0, bytes);
                    bytes = in.readInt();
                }
                ((OutputStream)out).close();
            }
            this.temp = true;
        }
    }

    private static class DateQValue
    extends QValueImpl {
        private final String formattedStr;

        private DateQValue(Calendar value) {
            super(value, 5);
            this.formattedStr = ISO8601.format((Calendar)value);
        }

        public String getString() throws RepositoryException {
            return this.formattedStr;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof DateQValue) {
                DateQValue other = (DateQValue)obj;
                return this.formattedStr.equals(other.formattedStr);
            }
            return false;
        }

        public int hashCode() {
            return this.formattedStr.hashCode();
        }
    }

    private static class QValueImpl
    implements QValue,
    Serializable {
        private final Object val;
        private final int type;

        private QValueImpl(Object value, int type) {
            this.val = value;
            this.type = type;
        }

        private QValueImpl(String value, int type) {
            if (type != 1 && type != 9) {
                throw new IllegalArgumentException();
            }
            this.val = value;
            this.type = type;
        }

        private QValueImpl(Long value) {
            this.val = value;
            this.type = 3;
        }

        private QValueImpl(Double value) {
            this.val = value;
            this.type = 4;
        }

        private QValueImpl(Boolean value) {
            this.val = value;
            this.type = 6;
        }

        private QValueImpl(Name value) {
            this.val = value;
            this.type = 7;
        }

        private QValueImpl(Path value) {
            this.val = value;
            this.type = 8;
        }

        public int getType() {
            return this.type;
        }

        public long getLength() throws RepositoryException {
            return this.getString().length();
        }

        public String getString() throws RepositoryException {
            return this.val.toString();
        }

        public InputStream getStream() throws RepositoryException {
            try {
                return new ByteArrayInputStream(this.getString().getBytes(QValueFactoryImpl.DEFAULT_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                throw new RepositoryException("UTF-8 is not supported encoding on this platform", (Throwable)e);
            }
        }

        public Name getName() throws RepositoryException {
            if (this.type == 7) {
                return (Name)this.val;
            }
            try {
                return NAME_FACTORY.create(this.getString());
            }
            catch (IllegalArgumentException e) {
                throw new ValueFormatException("not a valid Name value: " + this.getString(), (Throwable)e);
            }
        }

        public Calendar getCalendar() throws RepositoryException {
            if (this.type == 5) {
                return (Calendar)((Calendar)this.val).clone();
            }
            if (this.type == 4) {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+00:00"));
                cal.setTimeInMillis(((Double)this.val).longValue());
                return cal;
            }
            if (this.type == 3) {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+00:00"));
                cal.setTimeInMillis((Long)this.val);
                return cal;
            }
            Calendar cal = ISO8601.parse((String)this.getString());
            if (cal == null) {
                throw new ValueFormatException("not a date string: " + this.getString());
            }
            return cal;
        }

        public double getDouble() throws RepositoryException {
            if (this.type == 4) {
                return (Double)this.val;
            }
            if (this.type == 5) {
                return ((Calendar)this.val).getTimeInMillis();
            }
            try {
                return Double.parseDouble(this.getString());
            }
            catch (NumberFormatException ex) {
                throw new ValueFormatException("not a double: " + this.getString(), (Throwable)ex);
            }
        }

        public long getLong() throws RepositoryException {
            if (this.type == 3) {
                return (Long)this.val;
            }
            if (this.type == 4) {
                return ((Double)this.val).longValue();
            }
            if (this.type == 5) {
                return ((Calendar)this.val).getTimeInMillis();
            }
            try {
                return Long.parseLong(this.getString());
            }
            catch (NumberFormatException ex) {
                throw new ValueFormatException("not a long: " + this.getString(), (Throwable)ex);
            }
        }

        public Path getPath() throws RepositoryException {
            if (this.type == 8) {
                return (Path)this.val;
            }
            try {
                return PATH_FACTORY.create(this.getString());
            }
            catch (IllegalArgumentException e) {
                throw new ValueFormatException("not a valid Path: " + this.getString(), (Throwable)e);
            }
        }

        public void discard() {
        }

        public String toString() {
            return this.val.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof QValueImpl) {
                QValueImpl other = (QValueImpl)obj;
                return this.type == other.type && this.val.equals(other.val);
            }
            return false;
        }

        public int hashCode() {
            return this.val.hashCode();
        }
    }
}

