/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Collections;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.jackrabbit.jcr2spi.ItemLifeCycleListener;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.config.CacheBehaviour;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.Remove;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateLifeCycleListener;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.jcr2spi.util.LogUtil;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ItemImpl
implements Item,
ItemStateLifeCycleListener {
    private static Logger log = LoggerFactory.getLogger(ItemImpl.class);
    private final ItemState state;
    protected SessionImpl session;
    protected final Map<ItemLifeCycleListener, ItemLifeCycleListener> listeners = Collections.synchronizedMap(new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.WEAK));

    public ItemImpl(SessionImpl session, ItemState state, ItemLifeCycleListener[] listeners) {
        this.session = session;
        this.state = state;
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                this.addLifeCycleListener(listeners[i]);
            }
        }
        this.notifyCreated();
        state.addListener(this);
    }

    public String getPath() throws RepositoryException {
        this.checkStatus();
        return this.session.getPathResolver().getJCRPath(this.getQPath());
    }

    public abstract String getName() throws RepositoryException;

    public Item getAncestor(int depth) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.checkStatus();
        if (depth == 0) {
            return this.session.getRootNode();
        }
        String msg = "No ancestor at depth = " + depth;
        try {
            Path path = this.getQPath();
            int relDegree = path.getAncestorCount() - depth;
            if (relDegree < 0) {
                throw new ItemNotFoundException(msg);
            }
            Path ancestorPath = path.getAncestor(relDegree);
            if (relDegree == 0) {
                return this;
            }
            return this.getItemManager().getNode(ancestorPath);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(msg);
        }
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.checkStatus();
        if (this.state.isNode() && ((NodeState)this.state).isRoot()) {
            String msg = "Root node doesn't have a parent.";
            log.debug(msg);
            throw new ItemNotFoundException(msg);
        }
        NodeEntry parentEntry = this.getItemState().getHierarchyEntry().getParent();
        return (Node)this.getItemManager().getItem(parentEntry);
    }

    public int getDepth() throws RepositoryException {
        this.checkStatus();
        if (this.state.isNode() && ((NodeState)this.state).isRoot()) {
            return 0;
        }
        return this.session.getHierarchyManager().getDepth(this.state.getHierarchyEntry());
    }

    public Session getSession() throws RepositoryException {
        return this.session;
    }

    public boolean isNew() {
        return this.state.getStatus() == 4;
    }

    public boolean isModified() {
        return this.state.getStatus() == 2;
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        this.checkStatus();
        if (this == otherItem) {
            return true;
        }
        if (this.isNode() != otherItem.isNode()) {
            return false;
        }
        if (otherItem instanceof ItemImpl) {
            ItemImpl other = (ItemImpl)otherItem;
            if (this.state == other.state) {
                return true;
            }
            other.checkStatus();
            String otherWspName = other.session.getWorkspace().getName();
            if (this.session.getWorkspace().getName().equals(otherWspName) && this.state.getStatus() != 4 && other.state.getStatus() != 4) {
                ItemImpl.updateId(this.state);
                ItemImpl.updateId(other.state);
                return this.state.getWorkspaceId().equals(other.state.getWorkspaceId());
            }
        }
        return false;
    }

    public abstract void accept(ItemVisitor var1) throws RepositoryException;

    public abstract boolean isNode();

    public void save() throws AccessDeniedException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, RepositoryException {
        this.checkStatus();
        this.session.getSessionItemStateManager().save(this.getItemState());
    }

    public void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        this.session.checkIsAlive();
        int status = this.state.getStatus();
        if (Status.isTerminal(status) || 3 == status) {
            throw new InvalidItemStateException("Item '" + this + "' doesn't exist anymore");
        }
        if (keepChanges) {
            if (status != 4 && this.session.getCacheBehaviour() != CacheBehaviour.OBSERVATION) {
                this.state.getHierarchyEntry().invalidate(true);
            }
        } else {
            if (status == 4) {
                String msg = "Cannot refresh a new item (" + this.safeGetJCRPath() + ").";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            this.session.getSessionItemStateManager().undo(this.state);
            if (this.session.getCacheBehaviour() != CacheBehaviour.OBSERVATION) {
                this.state.getHierarchyEntry().invalidate(true);
            }
        }
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkSupportedOption("level.2.supported");
        this.checkStatus();
        Operation rm = Remove.create(this.getItemState());
        this.session.getSessionItemStateManager().execute(rm);
    }

    @Override
    public void statusChanged(ItemState state, int previousStatus) {
        if (state != this.state) {
            throw new IllegalArgumentException("Invalid argument: ItemState with changed status must be this.state.");
        }
        switch (state.getStatus()) {
            case 1: {
                if (previousStatus != 0 && previousStatus != 7) break;
                this.notifyUpdated(previousStatus == 7);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                state.removeListener(this);
                this.notifyDestroyed();
                break;
            }
            case 4: {
                log.error("invalid state change to STATUS_NEW");
            }
        }
    }

    private void notifyCreated() {
        ItemLifeCycleListener[] la = this.listeners.values().toArray(new ItemLifeCycleListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            la[i].itemCreated(this);
        }
    }

    private void notifyUpdated(boolean modified) {
        ItemLifeCycleListener[] la = this.listeners.values().toArray(new ItemLifeCycleListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].itemUpdated(this, modified);
        }
    }

    private void notifyDestroyed() {
        ItemLifeCycleListener[] la = this.listeners.values().toArray(new ItemLifeCycleListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].itemDestroyed(this);
        }
    }

    void addLifeCycleListener(ItemLifeCycleListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    void removeLifeCycleListener(ItemLifeCycleListener listener) {
        this.listeners.remove(listener);
    }

    protected void checkStatus() throws RepositoryException {
        this.session.checkIsAlive();
        if (this.state.getStatus() == 0) {
            this.state.getHierarchyEntry().reload(false);
        }
        if (!this.state.isValid()) {
            throw new InvalidItemStateException("Item '" + this + "' doesn't exist anymore. (Status = " + Status.getName(this.state.getStatus()) + ")");
        }
    }

    boolean isSupportedOption(String option) {
        return this.session.isSupportedOption(option);
    }

    void checkSupportedOption(String option) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkSupportedOption(option);
    }

    protected void checkIsWritable() throws UnsupportedRepositoryOperationException, ConstraintViolationException, RepositoryException {
        this.checkSupportedOption("level.2.supported");
        this.checkStatus();
    }

    protected boolean isWritable() throws RepositoryException {
        this.checkStatus();
        return this.session.isSupportedOption("level.2.supported");
    }

    abstract Name getQName() throws RepositoryException;

    Path getQPath() throws RepositoryException {
        return this.state.getPath();
    }

    protected ItemState getItemState() {
        return this.state;
    }

    protected ItemManager getItemManager() {
        return this.session.getItemManager();
    }

    String safeGetJCRPath() {
        return LogUtil.safeGetJCRPath(this.getItemState(), this.session.getPathResolver());
    }

    private static void updateId(ItemState state) throws RepositoryException {
        HierarchyEntry he = state.getHierarchyEntry();
        while (he.getStatus() != 0) {
            if ((he = he.getParent()) != null) continue;
            return;
        }
        he.getItemState();
    }
}

