/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet.remote;

import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import org.apache.jackrabbit.servlet.remote.RemoteBindingServlet;

public class RMIRemoteBindingServlet
extends RemoteBindingServlet {
    private static final long serialVersionUID = 1627580747678104906L;
    private String url;

    public void init() throws ServletException {
        this.url = this.getInitParameter("url");
        if (this.url == null) {
            this.url = "//localhost/javax/jcr/Repository";
        }
        try {
            Naming.bind(this.url, (Remote)this.getRemoteRepository());
        }
        catch (MalformedURLException e) {
            throw new ServletException("Invalid RMI URL: " + this.url, (Throwable)e);
        }
        catch (AlreadyBoundException e) {
            throw new ServletException("RMI URL is already bound: " + this.url, (Throwable)e);
        }
        catch (RemoteException e) {
            throw new ServletException("Failed to bind repository to RMI: " + this.url, (Throwable)e);
        }
    }

    public void destroy() {
        try {
            Naming.unbind(this.url);
        }
        catch (MalformedURLException e) {
            this.log("Invalid RMI URL: " + this.url, e);
        }
        catch (NotBoundException e) {
            this.log("Repository not bound in RMI: " + this.url, e);
        }
        catch (RemoteException e) {
            this.log("Failed to unbind repository from RMI: " + this.url, e);
        }
    }
}

