/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.apache.jackrabbit.server.SessionProvider;
import org.apache.jackrabbit.spi.commons.SessionExtensions;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.util.LinkHeaderFieldParser;

public class SessionProviderImpl
implements SessionProvider {
    public static final String ATTRIBUTE_SESSION_ID = SessionProviderImpl.class + "#sessionid()";
    private CredentialsProvider cp;

    public SessionProviderImpl(CredentialsProvider cp) {
        this.cp = cp;
    }

    public Session getSession(HttpServletRequest request, Repository repository, String workspace) throws LoginException, RepositoryException, ServletException {
        Credentials creds = this.cp.getCredentials(request);
        Session s = creds == null ? repository.login(workspace) : repository.login(creds, workspace);
        LinkHeaderFieldParser lhfp = new LinkHeaderFieldParser(request.getHeaders("Link"));
        String userData = this.getJcrUserData(lhfp);
        s.getWorkspace().getObservationManager().setUserData(userData);
        String sessionId = this.getSessionIdentifier(lhfp);
        if (s instanceof SessionExtensions) {
            SessionExtensions xs = (SessionExtensions)s;
            xs.setAttribute(ATTRIBUTE_SESSION_ID, (Object)sessionId);
        }
        return s;
    }

    public void releaseSession(Session session) {
        session.logout();
    }

    private String getJcrUserData(LinkHeaderFieldParser lhfp) {
        String jcrUserData = null;
        String target = lhfp.getFirstTargetForRelation("http://www.day.com/jcr/webdav/1.0/user-data");
        if (target != null) {
            jcrUserData = this.getJcrUserData(target);
        }
        return jcrUserData;
    }

    private String getSessionIdentifier(LinkHeaderFieldParser lhfp) {
        return lhfp.getFirstTargetForRelation("http://www.day.com/jcr/webdav/1.0/session-id");
    }

    private String getJcrUserData(String target) {
        try {
            String sspart;
            URI datauri = new URI(target);
            String scheme = datauri.getScheme();
            if (scheme != null && "data".equals(scheme.toLowerCase(Locale.ENGLISH)) && (sspart = datauri.getRawSchemeSpecificPart()).startsWith(",")) {
                return Text.unescape((String)sspart.substring(1));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }
}

