/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.Lock;
import javax.jcr.nodetype.NodeType;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.server.io.IOUtil;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.jcr.AbstractItemResource;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.jcr.lock.JcrActiveLock;
import org.apache.jackrabbit.webdav.jcr.lock.SessionScopedLockEntry;
import org.apache.jackrabbit.webdav.jcr.nodetype.NodeTypeProperty;
import org.apache.jackrabbit.webdav.jcr.property.ValuesProperty;
import org.apache.jackrabbit.webdav.jcr.version.report.ExportViewReport;
import org.apache.jackrabbit.webdav.jcr.version.report.LocateCorrespondingNodeReport;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockEntry;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.ordering.OrderPatch;
import org.apache.jackrabbit.webdav.ordering.OrderingResource;
import org.apache.jackrabbit.webdav.ordering.OrderingType;
import org.apache.jackrabbit.webdav.ordering.Position;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DefaultItemCollection
extends AbstractItemResource
implements OrderingResource {
    private static Logger log = LoggerFactory.getLogger((Class)DefaultItemCollection.class);
    private static final String TMP_PREFIX = "_tmp_";

    protected DefaultItemCollection(DavResourceLocator locator, JcrDavSession session, DavResourceFactory factory, Item item) {
        super(locator, session, factory, item);
        if (this.exists() && !(item instanceof Node)) {
            throw new IllegalArgumentException("A collection resource can not be constructed from a Property item.");
        }
    }

    public String getComplianceClass() {
        String cc = super.getComplianceClass();
        if (this.isOrderable()) {
            StringBuffer sb = new StringBuffer(cc);
            sb.append(", ").append("ordered-collections");
            return sb.toString();
        }
        return cc;
    }

    public long getModificationTime() {
        if (this.exists()) {
            try {
                if (((Node)this.item).hasProperty("jcr:lastModified")) {
                    return ((Node)this.item).getProperty("jcr:lastModified").getLong();
                }
            }
            catch (RepositoryException e) {
                log.warn("Error while accessing jcr:lastModified property");
            }
        }
        return new Date().getTime();
    }

    public String getSupportedMethods() {
        String ms = super.getSupportedMethods();
        if (this.isOrderable()) {
            StringBuffer sb = new StringBuffer(ms);
            if (this.isOrderable()) {
                sb.append(", ").append("ORDERPATCH");
            }
            return sb.toString();
        }
        return ms;
    }

    public boolean isCollection() {
        return true;
    }

    public void spool(OutputContext outputContext) throws IOException {
        super.spool(outputContext);
        try {
            OutputStream out = outputContext.getOutputStream();
            if (out != null && this.exists()) {
                this.getRepositorySession().exportSystemView(this.item.getPath(), out, false, true);
            }
        }
        catch (PathNotFoundException e) {
            log.error("Error while spooling resource content: " + e.getMessage());
        }
        catch (RepositoryException e) {
            log.error("Error while spooling resource content: " + e.getMessage());
        }
    }

    public void setProperty(DavProperty property) throws DavException {
        this.internalSetProperty(property);
        this.complete();
    }

    private void internalSetProperty(DavProperty property) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (property.getName().equals((Object)JCR_MIXINNODETYPES)) {
            Node n = (Node)this.item;
            try {
                NodeType[] existingMixin = n.getMixinNodeTypes();
                NodeTypeProperty mix = new NodeTypeProperty(property);
                Set mixins = mix.getNodeTypeNames();
                for (int i = 0; i < existingMixin.length; ++i) {
                    String name = existingMixin[i].getName();
                    if (mixins.contains(name)) {
                        mixins.remove(name);
                        continue;
                    }
                    n.removeMixin(name);
                }
                Iterator it = mixins.iterator();
                while (it.hasNext()) {
                    n.addMixin((String)it.next());
                }
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
        } else {
            throw new DavException(409);
        }
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        this.internalRemoveProperty(propertyName);
        this.complete();
    }

    private void internalRemoveProperty(DavPropertyName propertyName) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (JCR_MIXINNODETYPES.equals((Object)propertyName)) {
            try {
                Node n = (Node)this.item;
                NodeType[] mixins = n.getMixinNodeTypes();
                for (int i = 0; i < mixins.length; ++i) {
                    n.removeMixin(mixins[i].getName());
                }
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
        } else {
            throw new DavException(409);
        }
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        Iterator it = changeList.iterator();
        while (it.hasNext()) {
            Object propEntry = it.next();
            if (propEntry instanceof DavPropertyName) {
                DavPropertyName propName = (DavPropertyName)propEntry;
                this.internalRemoveProperty(propName);
                continue;
            }
            if (propEntry instanceof DavProperty) {
                DavProperty prop = (DavProperty)propEntry;
                this.internalSetProperty(prop);
                continue;
            }
            throw new IllegalArgumentException("unknown object in change list: " + propEntry.getClass().getName());
        }
        this.complete();
        return new MultiStatusResponse(this.getHref(), 200);
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        if (!this.exists()) {
            throw new DavException(409);
        }
        File tmpFile = null;
        try {
            Node n = (Node)this.item;
            InputStream in = inputContext != null ? inputContext.getInputStream() : null;
            String itemPath = this.getLocator().getRepositoryPath();
            String memberName = DefaultItemCollection.getItemName(resource.getLocator().getRepositoryPath());
            if (resource.isCollection()) {
                if (in == null) {
                    n.addNode(memberName);
                } else {
                    int uuidBehavior = 0;
                    String str = inputContext.getProperty("ImportUUIDBehavior");
                    if (str != null) {
                        try {
                            uuidBehavior = Integer.parseInt(str);
                        }
                        catch (NumberFormatException e) {
                            throw new DavException(400);
                        }
                    }
                    if (this.getTransactionId() == null) {
                        this.getRepositorySession().getWorkspace().importXML(itemPath, in, uuidBehavior);
                    } else {
                        this.getRepositorySession().importXML(itemPath, in, uuidBehavior);
                    }
                }
            } else {
                if (in == null) {
                    throw new DavException(400, "Cannot create a new non-collection resource without request body.");
                }
                tmpFile = File.createTempFile(TMP_PREFIX + Text.escape((String)memberName), null, null);
                FileOutputStream out = new FileOutputStream(tmpFile);
                IOUtil.spool(in, out);
                out.close();
                ValuesProperty vp = this.buildValuesProperty(new FileInputStream(tmpFile));
                if (vp != null) {
                    if (JCR_VALUE.equals((Object)vp.getName())) {
                        n.setProperty(memberName, vp.getJcrValue());
                    } else {
                        n.setProperty(memberName, vp.getJcrValues());
                    }
                } else {
                    n.setProperty(memberName, (InputStream)new FileInputStream(tmpFile));
                }
            }
            if (resource.exists() && resource instanceof AbstractItemResource) {
                ((AbstractItemResource)resource).complete();
            } else {
                this.complete();
            }
        }
        catch (ItemExistsException e) {
            throw new JcrDavException(e, 405);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
        catch (IOException e) {
            throw new DavException(422, e.getMessage());
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    public DavResourceIterator getMembers() {
        ArrayList<DavResource> memberList = new ArrayList<DavResource>();
        if (this.exists()) {
            try {
                Node n = (Node)this.item;
                NodeIterator it = n.getNodes();
                while (it.hasNext()) {
                    Node node = it.nextNode();
                    DavResourceLocator loc = this.getLocatorFromItem((Item)node);
                    memberList.add(this.createResourceFromLocator(loc));
                }
                PropertyIterator propIt = n.getProperties();
                while (propIt.hasNext()) {
                    Property prop = propIt.nextProperty();
                    DavResourceLocator loc = this.getLocatorFromItem((Item)prop);
                    memberList.add(this.createResourceFromLocator(loc));
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
            catch (DavException e) {
                log.error(e.getMessage());
            }
        }
        return new DavResourceIteratorImpl(memberList);
    }

    public void removeMember(DavResource member) throws DavException {
        Session session = this.getRepositorySession();
        try {
            String itemPath = member.getLocator().getRepositoryPath();
            if (!this.exists() || !session.itemExists(itemPath)) {
                throw new DavException(404);
            }
            if (!this.getResourcePath().equals(Text.getRelativeParent((String)member.getResourcePath(), (int)1))) {
                throw new DavException(409, member.getResourcePath() + "is not member of this resource (" + this.getResourcePath() + ")");
            }
            this.getRepositorySession().getItem(itemPath).remove();
            this.complete();
        }
        catch (RepositoryException e) {
            log.error("Unexpected error: " + e.getMessage());
            throw new JcrDavException(e);
        }
    }

    public boolean hasLock(Type type, Scope scope) {
        if (this.isLockable(type, scope)) {
            if (Type.WRITE.equals((Object)type)) {
                try {
                    return ((Node)this.item).isLocked();
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
            } else {
                return super.hasLock(type, scope);
            }
        }
        return false;
    }

    public ActiveLock getLock(Type type, Scope scope) {
        ActiveLock lock = null;
        if (Type.WRITE.equals((Object)type)) {
            try {
                if (!this.exists()) {
                    log.warn("Unable to retrieve lock: no item found at '" + this.getResourcePath() + "'");
                } else if (((Node)this.item).isLocked()) {
                    Lock jcrLock = ((Node)this.item).getLock();
                    lock = new JcrActiveLock(jcrLock);
                }
            }
            catch (AccessDeniedException e) {
                log.error("Error while accessing resource lock: " + e.getMessage());
            }
            catch (UnsupportedRepositoryOperationException e) {
                log.error("Error while accessing resource lock: " + e.getMessage());
            }
            catch (RepositoryException e) {
                log.error("Error while accessing resource lock: " + e.getMessage());
            }
        } else {
            lock = super.getLock(type, scope);
        }
        return lock;
    }

    public ActiveLock lock(LockInfo reqLockInfo) throws DavException {
        if (!this.isLockable(reqLockInfo.getType(), reqLockInfo.getScope())) {
            throw new DavException(412);
        }
        if (Type.WRITE.equals((Object)reqLockInfo.getType())) {
            if (!this.exists()) {
                log.warn("Cannot create a write lock for non-existing JCR node (" + this.getResourcePath() + ")");
                throw new DavException(404);
            }
            try {
                boolean sessionScoped = EXCLUSIVE_SESSION.equals((Object)reqLockInfo.getScope());
                Lock jcrLock = ((Node)this.item).lock(reqLockInfo.isDeep(), sessionScoped);
                this.getSession().addReference((Object)jcrLock.getLockToken());
                return new JcrActiveLock(jcrLock, sessionScoped);
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
        }
        return super.lock(reqLockInfo);
    }

    public ActiveLock refreshLock(LockInfo reqLockInfo, String lockToken) throws DavException {
        if (lockToken == null) {
            throw new DavException(412);
        }
        ActiveLock lock = this.getLock(reqLockInfo.getType(), reqLockInfo.getScope());
        if (lock == null) {
            throw new DavException(412, "No lock with the given scope/type present on this resource.");
        }
        if (Type.WRITE.equals((Object)lock.getType())) {
            try {
                Lock jcrLock = ((Node)this.item).getLock();
                jcrLock.refresh();
                return new JcrActiveLock(jcrLock, EXCLUSIVE_SESSION.equals((Object)lock.getScope()));
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
        }
        return super.refreshLock(reqLockInfo, lockToken);
    }

    public void unlock(String lockToken) throws DavException {
        ActiveLock lock = this.getWriteLock();
        if (lock != null && lockToken.equals(lock.getToken())) {
            try {
                ((Node)this.item).unlock();
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
        } else {
            super.unlock(lockToken);
        }
    }

    private ActiveLock getWriteLock() throws DavException {
        if (!this.exists()) {
            throw new DavException(404, "Unable to retrieve write lock for non existing repository item (" + this.getResourcePath() + ")");
        }
        ActiveLock writeLock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (writeLock == null) {
            writeLock = this.getLock(Type.WRITE, EXCLUSIVE_SESSION);
        }
        return writeLock;
    }

    public boolean isOrderable() {
        boolean orderable = false;
        if (this.exists()) {
            try {
                orderable = ((Node)this.item).getPrimaryNodeType().hasOrderableChildNodes();
            }
            catch (RepositoryException e) {
                log.warn(e.getMessage());
            }
        }
        return orderable;
    }

    public void orderMembers(OrderPatch orderPatch) throws DavException {
        if (!this.isOrderable()) {
            throw new DavException(405);
        }
        if (!"DAV:custom".equalsIgnoreCase(orderPatch.getOrderingType())) {
            throw new DavException(422, "Only DAV:custom ordering type supported.");
        }
        OrderPatch.Member[] instructions = orderPatch.getOrderInstructions();
        Node n = (Node)this.item;
        try {
            for (int i = 0; i < instructions.length; ++i) {
                String srcRelPath = Text.unescape((String)instructions[i].getMemberHandle());
                Position pos = instructions[i].getPosition();
                String destRelPath = this.getRelDestinationPath(pos, n.getNodes());
                n.orderBefore(srcRelPath, destRelPath);
            }
            this.complete();
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    private String getRelDestinationPath(Position position, NodeIterator childNodes) throws RepositoryException {
        String destRelPath = null;
        if ("first".equals(position.getType())) {
            if (childNodes.hasNext()) {
                Node firstChild = childNodes.nextNode();
                destRelPath = Text.getName((String)firstChild.getPath());
            }
            if (destRelPath == null) {
                throw new ItemNotFoundException("No 'first' item found for reordering.");
            }
        } else if ("after".equals(position.getType())) {
            String afterRelPath = position.getSegment();
            boolean found = false;
            while (childNodes.hasNext() && destRelPath == null) {
                String childRelPath = Text.getName((String)childNodes.nextNode().getPath());
                if (found) {
                    destRelPath = childRelPath;
                    continue;
                }
                found = afterRelPath.equals(childRelPath);
            }
        } else {
            destRelPath = position.getSegment();
        }
        if (destRelPath != null) {
            destRelPath = Text.unescape((String)destRelPath);
        }
        return destRelPath;
    }

    protected void initLockSupport() {
        super.initLockSupport();
        try {
            if (this.exists() && ((Node)this.item).isNodeType("mix:lockable")) {
                this.supportedLock.addEntry(Type.WRITE, Scope.EXCLUSIVE);
                this.supportedLock.addEntry((LockEntry)new SessionScopedLockEntry());
            }
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage());
        }
    }

    protected void initSupportedReports() {
        super.initSupportedReports();
        if (this.exists()) {
            this.supportedReports.addReportType(ExportViewReport.EXPORTVIEW_REPORT);
            this.supportedReports.addReportType(LocateCorrespondingNodeReport.LOCATE_CORRESPONDING_NODE_REPORT);
        }
    }

    protected void initProperties() {
        super.initProperties();
        if (this.exists()) {
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)"text/xml"));
            Node n = (Node)this.item;
            try {
                if (n.hasProperty("jcr:created")) {
                    long creationTime = n.getProperty("jcr:created").getValue().getLong();
                    this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)DavConstants.creationDateFormat.format(new Date(creationTime))));
                }
            }
            catch (RepositoryException e) {
                log.warn("Error while accessing jcr:created property");
            }
            try {
                this.properties.add((DavProperty)new NodeTypeProperty(JCR_PRIMARYNODETYPE, n.getPrimaryNodeType(), false));
                this.properties.add((DavProperty)new NodeTypeProperty(JCR_MIXINNODETYPES, n.getMixinNodeTypes(), false));
                this.properties.add((DavProperty)new DefaultDavProperty(JCR_INDEX, (Object)new Integer(n.getIndex()), true));
                this.addHrefProperty(JCR_REFERENCES, (Iterator)n.getReferences(), true);
                if (n.isNodeType("mix:referenceable")) {
                    this.properties.add((DavProperty)new DefaultDavProperty(JCR_UUID, (Object)n.getUUID(), true));
                }
            }
            catch (RepositoryException e) {
                log.error("Failed to retrieve primary nodetype property: " + e.getMessage());
            }
            try {
                Item primaryItem = n.getPrimaryItem();
                this.addHrefProperty(JCR_PRIMARYITEM, new Item[]{primaryItem}, true);
            }
            catch (ItemNotFoundException e) {
                log.debug("No primary item present on this node '" + this.getResourcePath() + "'");
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving primary item: " + e.getMessage());
            }
            if (this.isOrderable()) {
                this.properties.add((DavProperty)new OrderingType("DAV:custom"));
            }
        }
    }

    protected void addHrefProperty(DavPropertyName name, Item[] values, boolean isProtected) {
        if (values == null) {
            return;
        }
        String[] pHref = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            pHref[i] = this.getLocatorFromItem(values[i]).getHref(true);
        }
        this.properties.add((DavProperty)new HrefProperty(name, pHref, isProtected));
    }

    protected void addHrefProperty(DavPropertyName name, Iterator itemIterator, boolean isProtected) {
        ArrayList l = new ArrayList();
        while (itemIterator.hasNext()) {
            l.add(itemIterator.next());
        }
        this.addHrefProperty(name, l.toArray(new Item[l.size()]), isProtected);
    }

    private ValuesProperty buildValuesProperty(InputStream in) {
        String errorMsg = "Cannot parse stream into a 'ValuesProperty'.";
        try {
            Document reqBody = DomUtil.BUILDER_FACTORY.newDocumentBuilder().parse(in);
            DefaultDavProperty defaultProp = DefaultDavProperty.createFromXml((Element)reqBody.getDocumentElement());
            ValuesProperty vp = new ValuesProperty((DavProperty)defaultProp, 1, this.getRepositorySession().getValueFactory());
            return vp;
        }
        catch (IOException e) {
            log.debug(errorMsg, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.debug(errorMsg, (Throwable)e);
        }
        catch (SAXException e) {
            log.debug(errorMsg, (Throwable)e);
        }
        catch (DavException e) {
            log.debug(errorMsg, (Throwable)e);
        }
        catch (RepositoryException e) {
            log.debug(errorMsg, (Throwable)e);
        }
        return null;
    }
}

