/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.validation.ValidationExecutor;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

public class ValidationHelper {
    private int noOfEmittedValidationMessagesWithLevelWarn = 0;
    private int noOfEmittedValidationMessagesWithLevelError = 0;

    protected ValidationHelper() {
    }

    public void printMessages(Collection<ValidationViolation> violations, Log log, BuildContext buildContext, Path baseDirectory) {
        for (ValidationViolation violation : violations) {
            int buildContextSeverity;
            switch (violation.getSeverity()) {
                case ERROR: {
                    log.error((CharSequence)ValidationHelper.getDetailMessage(violation, baseDirectory));
                    if (violation.getThrowable() != null) {
                        log.debug(violation.getThrowable());
                    }
                    buildContextSeverity = 2;
                    ++this.noOfEmittedValidationMessagesWithLevelError;
                    break;
                }
                case WARN: {
                    log.warn((CharSequence)ValidationHelper.getDetailMessage(violation, baseDirectory));
                    if (violation.getThrowable() != null) {
                        log.debug(violation.getThrowable());
                    }
                    ++this.noOfEmittedValidationMessagesWithLevelWarn;
                    buildContextSeverity = 1;
                    break;
                }
                case INFO: {
                    log.info((CharSequence)ValidationHelper.getDetailMessage(violation, baseDirectory));
                    buildContextSeverity = -1;
                    break;
                }
                default: {
                    log.debug((CharSequence)ValidationHelper.getDetailMessage(violation, baseDirectory));
                    buildContextSeverity = -1;
                }
            }
            if (buildContextSeverity <= 0 || buildContext instanceof DefaultBuildContext) continue;
            File file = violation.getAbsoluteFilePath() != null ? violation.getAbsoluteFilePath().toFile() : baseDirectory.toFile();
            buildContext.addMessage(file, violation.getLine(), violation.getColumn(), ValidationHelper.getMessage(violation), buildContextSeverity, violation.getThrowable());
        }
    }

    private static String getMessage(ValidationViolation violation) {
        StringBuilder message = new StringBuilder();
        if (violation.getValidatorId() != null) {
            message.append(violation.getValidatorId()).append(": ");
        }
        message.append(violation.getMessage());
        return message.toString();
    }

    public void printUsedValidators(Log log, ValidationExecutor executor, ValidationContext context, boolean printUnusedValidators) {
        Map unusedValidatorsById;
        String packageType = context.getProperties().getPackageType() != null ? context.getProperties().getPackageType().toString() : "unknown";
        log.info((CharSequence)("Using " + executor.getAllValidatorsById().entrySet().size() + " validators for package of type " + packageType + ": " + ValidationHelper.getValidatorNames(executor, ", ")));
        if (printUnusedValidators && !(unusedValidatorsById = executor.getUnusedValidatorsById()).isEmpty()) {
            log.warn((CharSequence)("There are unused validators among those which are not executed: " + StringUtils.join(unusedValidatorsById.keySet(), (String)".")));
        }
    }

    private static String getDetailMessage(ValidationViolation violation, Path baseDirectory) {
        StringBuilder message = new StringBuilder("ValidationViolation: ");
        message.append("\"").append(ValidationHelper.getMessage(violation)).append("\"");
        if (violation.getFilePath() != null) {
            message.append(", filePath=").append(baseDirectory.relativize(violation.getAbsoluteFilePath()));
        }
        if (violation.getNodePath() != null) {
            message.append(", nodePath=").append(violation.getNodePath());
        }
        if (violation.getLine() > 0) {
            message.append(", line=").append(violation.getLine());
        }
        if (violation.getColumn() > 0) {
            message.append(", column=").append(violation.getColumn());
        }
        return message.toString();
    }

    private static String getValidatorNames(ValidationExecutor executor, String separator) {
        StringBuilder validatorNames = new StringBuilder();
        boolean isFirstItem = true;
        for (Map.Entry validatorById : executor.getAllValidatorsById().entrySet()) {
            if (!isFirstItem) {
                validatorNames.append(separator);
            } else {
                isFirstItem = false;
            }
            validatorNames.append((String)validatorById.getKey()).append(" (").append(((Validator)validatorById.getValue()).getClass().getName()).append(")");
        }
        return validatorNames.toString();
    }

    public void clearPreviousValidationMessages(BuildContext context, File file) {
        context.removeMessages(file);
    }

    protected void failBuildInCaseOfViolations(boolean failForWarning) throws MojoFailureException {
        if (failForWarning && (this.noOfEmittedValidationMessagesWithLevelWarn > 0 || this.noOfEmittedValidationMessagesWithLevelError > 0)) {
            throw new MojoFailureException("Found " + this.noOfEmittedValidationMessagesWithLevelWarn + this.noOfEmittedValidationMessagesWithLevelError + " violation(s) (either ERROR or WARN). Check above warnings/errors for details");
        }
        if (this.noOfEmittedValidationMessagesWithLevelError > 0) {
            throw new MojoFailureException("Found " + this.noOfEmittedValidationMessagesWithLevelError + " violation(s) (with severity=ERROR). Check above errors for details");
        }
    }
}

