/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import org.apache.jackrabbit.filevault.maven.packaging.IncludeExcludeList;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;

public class Filter {
    static final String INDENT = "    ";
    private String root;
    private ImportMode mode = ImportMode.REPLACE;
    private boolean cleanupType;
    private final IncludeExcludeList includes = new IncludeExcludeList();
    private final IncludeExcludeList excludes = new IncludeExcludeList();

    public Filter() {
    }

    public Filter(String root) {
        this.setRoot(root);
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    public void setMode(String mode) {
        if (mode != null) {
            this.mode = ImportMode.valueOf((String)mode.toUpperCase());
        }
    }

    public ImportMode getMode() {
        return this.mode;
    }

    public boolean isCleanupType() {
        return this.cleanupType;
    }

    public void setType(String type) {
        this.cleanupType = "cleanup".equals(type);
    }

    public PathFilterSet toPathFilterSet() {
        PathFilterSet set = new PathFilterSet();
        set.setRoot(this.root);
        set.setImportMode(this.mode);
        if (this.cleanupType) {
            set.setType("cleanup");
        }
        for (String pattern : this.includes) {
            set.addInclude((org.apache.jackrabbit.vault.fs.api.Filter)new DefaultPathFilter(pattern));
        }
        for (String pattern : this.excludes) {
            set.addExclude((org.apache.jackrabbit.vault.fs.api.Filter)new DefaultPathFilter(pattern));
        }
        return set;
    }
}

