/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.nodemanagement.impl;

import java.util.Collection;
import java.util.List;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.ocm.mapper.model.BeanDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.ChildNodeDefDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.FieldDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.MappingDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.PropertyDefDescriptor;
import org.apache.jackrabbit.ocm.nodemanagement.NodeTypeManager;
import org.apache.jackrabbit.ocm.nodemanagement.exception.NamespaceCreationException;
import org.apache.jackrabbit.ocm.nodemanagement.exception.NodeTypeCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeManagerImpl
implements NodeTypeManager {
    private static Logger log = LoggerFactory.getLogger(NodeTypeManagerImpl.class);

    public void createNamespace(Session session, String namespace, String namespaceUri) throws NamespaceCreationException {
        if (session != null) {
            try {
                session.getWorkspace().getNamespaceRegistry().registerNamespace(namespace, namespaceUri);
                log.info("Namespace created: {" + namespaceUri + "}" + namespace);
            }
            catch (Exception e) {
                throw new NamespaceCreationException(e);
            }
        }
    }

    public void createNodeTypes(Session session, MappingDescriptor mappingDescriptor) throws NodeTypeCreationException {
        if (mappingDescriptor == null || mappingDescriptor.getClassDescriptorsByClassName().size() <= 0) {
            throw new NodeTypeCreationException("The MappingDescriptor can't be null or empty.");
        }
        Collection classDescriptorObjects = mappingDescriptor.getClassDescriptorsByClassName().values();
        ClassDescriptor[] classDescriptors = classDescriptorObjects.toArray(new ClassDescriptor[classDescriptorObjects.size()]);
        this.createNodeTypes(session, classDescriptors);
    }

    public void createNodeTypes(Session session, ClassDescriptor[] classDescriptors) throws NodeTypeCreationException {
        if (classDescriptors != null && classDescriptors.length > 0) {
            log.info("Trying to create " + classDescriptors.length + " JCR node types.");
            for (int i = 0; i < classDescriptors.length; ++i) {
                this.createSingleNodeType(session, classDescriptors[i]);
            }
        } else {
            throw new NodeTypeCreationException("The ClassDescriptor can't be null or empty.");
        }
    }

    public void createSingleNodeType(Session session, ClassDescriptor classDescriptor) throws NodeTypeCreationException {
        block16: {
            try {
                if (classDescriptor.getJcrType() != null && (classDescriptor.getJcrType().startsWith("nt:") || classDescriptor.getJcrType().startsWith("mix:"))) {
                    throw new NodeTypeCreationException("Namespace nt and mix are reserved namespaces. Please specify your own.");
                }
                if (this.checkSuperTypes(session.getWorkspace().getNodeTypeManager(), classDescriptor.getJcrSuperTypes())) {
                    javax.jcr.nodetype.NodeTypeManager ntm = session.getWorkspace().getNodeTypeManager();
                    NodeTypeTemplate ntt = ntm.createNodeTypeTemplate();
                    if (classDescriptor.getJcrType() == null) {
                        ntt.setName(classDescriptor.getClassName());
                    } else {
                        ntt.setName(classDescriptor.getJcrType());
                    }
                    ntt.setAbstract(classDescriptor.isAbstract());
                    if (classDescriptor.getJcrSuperTypes() != null && classDescriptor.getJcrSuperTypes().length() > 0) {
                        String[] superTypesArray = classDescriptor.getJcrSuperTypes().split(",");
                        for (String s : classDescriptor.getJcrMixinTypes()) {
                            System.out.println(s);
                        }
                        ntt.setDeclaredSuperTypeNames(superTypesArray);
                    }
                    ntt.setMixin(false);
                    ntt.setQueryable(true);
                    ntt.setOrderableChildNodes(true);
                    List nodeDefinitionTemplates = ntt.getNodeDefinitionTemplates();
                    List propertyDefinitionTemplates = ntt.getPropertyDefinitionTemplates();
                    if (classDescriptor.getFieldDescriptors() != null) {
                        NodeDefinitionTemplate ndt;
                        PropertyDefinitionTemplate pdt;
                        for (FieldDescriptor field : classDescriptor.getFieldDescriptors()) {
                            if (field.isPath()) continue;
                            PropertyDefinitionTemplate pdt2 = this.getPropertyDefinition(ntm, session.getValueFactory(), field);
                            propertyDefinitionTemplates.add(pdt2);
                        }
                        if (classDescriptor.getBeanDescriptors() != null) {
                            for (ChildNodeDefDescriptor field : classDescriptor.getBeanDescriptors()) {
                                if (this.isPropertyType(((BeanDescriptor)field).getJcrType())) {
                                    pdt = this.getPropertyDefinition(ntm, session.getValueFactory(), (PropertyDefDescriptor)((Object)field));
                                    propertyDefinitionTemplates.add(pdt);
                                    continue;
                                }
                                ndt = this.getNodeDefinition(ntm, session.getValueFactory(), field);
                                nodeDefinitionTemplates.add(ndt);
                            }
                        }
                        if (classDescriptor.getCollectionDescriptors() != null) {
                            for (ChildNodeDefDescriptor field : classDescriptor.getCollectionDescriptors()) {
                                if (this.isPropertyType(((CollectionDescriptor)field).getJcrType())) {
                                    pdt = this.getPropertyDefinition(ntm, session.getValueFactory(), (PropertyDefDescriptor)((Object)field));
                                    propertyDefinitionTemplates.add(pdt);
                                    continue;
                                }
                                ndt = this.getNodeDefinition(ntm, session.getValueFactory(), field);
                                nodeDefinitionTemplates.add(ndt);
                            }
                        }
                        ntm.registerNodeType((NodeTypeDefinition)ntt, false);
                        log.info("Registered JCR node type '" + ntt.getName() + "' for class '" + classDescriptor.getClassName() + "'");
                    }
                    break block16;
                }
                throw new NodeTypeCreationException("JCR supertypes could not be resolved.");
            }
            catch (Exception e) {
                log.error("Could not create node types from class descriptor.", (Throwable)e);
                throw new NodeTypeCreationException(e);
            }
        }
    }

    private NodeDefinitionTemplate getNodeDefinition(javax.jcr.nodetype.NodeTypeManager ntm, ValueFactory valueFactory, ChildNodeDefDescriptor field) throws RepositoryException {
        NodeDefinitionTemplate ndt = ntm.createNodeDefinitionTemplate();
        if (field.getJcrName() != null) {
            ndt.setName(field.getJcrName());
        } else {
            ndt.setName("*");
        }
        int onParentVersion = 5;
        if (field.getJcrOnParentVersion() != null && field.getJcrOnParentVersion().length() > 0) {
            onParentVersion = OnParentVersionAction.valueFromName((String)field.getJcrOnParentVersion());
        }
        ndt.setOnParentVersion(onParentVersion);
        ndt.setSameNameSiblings(field.isJcrSameNameSiblings());
        ndt.setAutoCreated(field.isJcrAutoCreated());
        ndt.setDefaultPrimaryTypeName(field.getDefaultPrimaryType());
        ndt.setMandatory(field.isJcrMandatory());
        ndt.setProtected(field.isJcrProtected());
        ndt.setRequiredPrimaryTypeNames(this.getJcrSuperTypes(field.getJcrType()));
        return ndt;
    }

    private PropertyDefinitionTemplate getPropertyDefinition(javax.jcr.nodetype.NodeTypeManager ntm, ValueFactory valueFactory, PropertyDefDescriptor field) throws RepositoryException {
        PropertyDefinitionTemplate pdt = ntm.createPropertyDefinitionTemplate();
        if (field.getJcrName() != null) {
            pdt.setName(field.getJcrName());
        } else {
            pdt.setName(field.getFieldName());
        }
        if (field.getJcrType() != null) {
            try {
                pdt.setRequiredType(PropertyType.valueFromName((String)field.getJcrType()));
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid property type '{}' for '{}'. Set default to String type", (Object)field.getJcrType(), (Object)field.getJcrName());
                pdt.setRequiredType(1);
            }
        } else {
            log.info("No property type set for {}. Setting 'String' type.", (Object)field.getJcrName());
            pdt.setRequiredType(1);
        }
        int onParentVersion = 5;
        if (field.getJcrOnParentVersion() != null && field.getJcrOnParentVersion().length() > 0) {
            onParentVersion = OnParentVersionAction.valueFromName((String)field.getJcrOnParentVersion());
        }
        pdt.setOnParentVersion(onParentVersion);
        pdt.setAutoCreated(field.isJcrAutoCreated());
        pdt.setAvailableQueryOperators(new String[0]);
        pdt.setFullTextSearchable(true);
        pdt.setMandatory(field.isJcrMandatory());
        pdt.setMultiple(field.isJcrMultiple());
        pdt.setOnParentVersion(onParentVersion);
        pdt.setProtected(field.isJcrProtected());
        pdt.setQueryOrderable(true);
        if (field instanceof FieldDescriptor) {
            FieldDescriptor f = (FieldDescriptor)field;
            if (f.getJcrDefaultValue() != null) {
                if (pdt.getRequiredType() == 1) {
                    Value[] vals = new Value[]{valueFactory.createValue(f.getJcrDefaultValue())};
                    pdt.setDefaultValues(vals);
                } else {
                    log.warn("Can only set default value for String properties. Skip for field '{}'", (Object)field.getJcrName());
                }
            }
            pdt.setValueConstraints(f.getJcrValueConstraints());
        }
        return pdt;
    }

    private boolean checkSuperTypes(javax.jcr.nodetype.NodeTypeManager ntMgr, String superTypes) {
        boolean exists = true;
        if (superTypes != null && superTypes.length() > 0) {
            String[] superTypesArray = superTypes.split(",");
            log.debug("JCR super types found: " + superTypesArray.length);
            for (int i = 0; i < superTypesArray.length; ++i) {
                try {
                    ntMgr.getNodeType(superTypesArray[i]);
                    continue;
                }
                catch (Exception e) {
                    log.error("JCR super type '" + superTypesArray[i] + "' does not exist!");
                    exists = false;
                    break;
                }
            }
        }
        return exists;
    }

    public String[] getJcrSuperTypes(String superTypes) {
        return superTypes.split(",");
    }

    private boolean isPropertyType(String type) {
        return type.equals("Binary") || type.equals("Boolean") || type.equals("Date") || type.equals("Double") || type.equals("Long") || type.equals("Name") || type.equals("Path") || type.equals("Reference") || type.equals("WeakReference") || type.equals("Decimal") || type.equals("URI") || type.equals("String");
    }
}

