/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.mapper.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.mapper.model.BeanDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.FieldDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.ImplementDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.MappingDescriptor;
import org.apache.jackrabbit.ocm.reflection.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDescriptor {
    private static final Logger log = LoggerFactory.getLogger(ClassDescriptor.class);
    private static final String NODETYPE_PER_HIERARCHY = "nodetypeperhierarchy";
    private static final String NODETYPE_PER_CONCRETECLASS = "nodetypeperconcreteclass";
    private MappingDescriptor mappingDescriptor;
    private ClassDescriptor superClassDescriptor;
    private HashSet descendantClassDescriptors = new HashSet();
    private String className;
    private String jcrType;
    private String jcrSuperTypes;
    private String[] jcrMixinTypes = new String[0];
    private FieldDescriptor idFieldDescriptor;
    private FieldDescriptor pathFieldDescriptor;
    private FieldDescriptor uuidFieldDescriptor;
    private Map fieldDescriptors = new HashMap();
    private Map beanDescriptors = new HashMap();
    private Map collectionDescriptors = new HashMap();
    private Map fieldNames = new HashMap();
    private String superClassName;
    private String extendsStrategy;
    private boolean isAbstract = false;
    private boolean hasDescendant = false;
    private boolean hasDiscriminator = true;
    private boolean isInterface = false;
    private Set interfaces = new HashSet();

    public void setAbstract(boolean flag) {
        this.isAbstract = flag;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setInterface(boolean flag) {
        this.isInterface = flag;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean hasInterfaces() {
        return this.interfaces.size() > 0;
    }

    public void setDiscriminator(boolean flag) {
        this.hasDiscriminator = flag;
    }

    public boolean hasDiscriminator() {
        return this.hasDiscriminator;
    }

    public boolean usesNodeTypePerHierarchyStrategy() {
        return NODETYPE_PER_HIERARCHY.equals(this.extendsStrategy);
    }

    public boolean usesNodeTypePerConcreteClassStrategy() {
        return NODETYPE_PER_CONCRETECLASS.equals(this.extendsStrategy);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getJcrType() {
        return this.jcrType;
    }

    public void setJcrType(String jcrType) {
        if (jcrType != null && !jcrType.equals("")) {
            this.jcrType = jcrType;
        }
    }

    public void addFieldDescriptor(FieldDescriptor fieldDescriptor) {
        fieldDescriptor.setClassDescriptor(this);
        if (fieldDescriptor.isId()) {
            this.idFieldDescriptor = fieldDescriptor;
        }
        if (fieldDescriptor.isPath()) {
            this.pathFieldDescriptor = fieldDescriptor;
        }
        if (fieldDescriptor.isUuid()) {
            this.uuidFieldDescriptor = fieldDescriptor;
        }
        this.fieldDescriptors.put(fieldDescriptor.getFieldName(), fieldDescriptor);
        this.fieldNames.put(fieldDescriptor.getFieldName(), fieldDescriptor.getJcrName());
    }

    public void addImplementDescriptor(ImplementDescriptor implementDescriptor) {
        this.interfaces.add(implementDescriptor.getInterfaceName());
    }

    public FieldDescriptor getFieldDescriptor(String fieldName) {
        return (FieldDescriptor)this.fieldDescriptors.get(fieldName);
    }

    public Collection getFieldDescriptors() {
        return this.fieldDescriptors.values();
    }

    public void addBeanDescriptor(BeanDescriptor beanDescriptor) {
        beanDescriptor.setClassDescriptor(this);
        this.beanDescriptors.put(beanDescriptor.getFieldName(), beanDescriptor);
        this.fieldNames.put(beanDescriptor.getFieldName(), beanDescriptor.getJcrName());
    }

    public BeanDescriptor getBeanDescriptor(String fieldName) {
        return (BeanDescriptor)this.beanDescriptors.get(fieldName);
    }

    public Collection getBeanDescriptors() {
        return this.beanDescriptors.values();
    }

    public void addCollectionDescriptor(CollectionDescriptor collectionDescriptor) {
        collectionDescriptor.setClassDescriptor(this);
        this.collectionDescriptors.put(collectionDescriptor.getFieldName(), collectionDescriptor);
        this.fieldNames.put(collectionDescriptor.getFieldName(), collectionDescriptor.getJcrName());
    }

    public CollectionDescriptor getCollectionDescriptor(String fieldName) {
        return (CollectionDescriptor)this.collectionDescriptors.get(fieldName);
    }

    public Collection getCollectionDescriptors() {
        return this.collectionDescriptors.values();
    }

    public FieldDescriptor getIdFieldDescriptor() {
        if (null != this.idFieldDescriptor) {
            return this.idFieldDescriptor;
        }
        if (null != this.superClassDescriptor) {
            return this.superClassDescriptor.getIdFieldDescriptor();
        }
        return null;
    }

    public FieldDescriptor getPathFieldDescriptor() {
        if (null != this.pathFieldDescriptor) {
            return this.pathFieldDescriptor;
        }
        if (null != this.superClassDescriptor) {
            return this.superClassDescriptor.getPathFieldDescriptor();
        }
        return null;
    }

    public FieldDescriptor getUuidFieldDescriptor() {
        if (null != this.uuidFieldDescriptor) {
            return this.uuidFieldDescriptor;
        }
        if (null != this.superClassDescriptor) {
            return this.superClassDescriptor.getUuidFieldDescriptor();
        }
        return null;
    }

    public boolean hasIdField() {
        return this.getIdFieldDescriptor() != null && this.getIdFieldDescriptor().isId();
    }

    public boolean hasUUIdField() {
        return this.getUuidFieldDescriptor() != null && this.getUuidFieldDescriptor().isUuid();
    }

    public String getJcrName(String fieldName) {
        String jcrName = (String)this.fieldNames.get(fieldName);
        if (this.isInterface && jcrName == null) {
            return this.getJcrNameFromDescendants(this, fieldName);
        }
        return jcrName;
    }

    private String getJcrNameFromDescendants(ClassDescriptor classDescriptor, String fieldName) {
        Iterator descendants = classDescriptor.getDescendantClassDescriptors().iterator();
        if (descendants.hasNext()) {
            ClassDescriptor descendant = (ClassDescriptor)descendants.next();
            String jcrName = (String)descendant.fieldNames.get(fieldName);
            if (jcrName != null) {
                return jcrName;
            }
            return this.getJcrNameFromDescendants(descendant, fieldName);
        }
        return null;
    }

    public Map getFieldNames() {
        return this.fieldNames;
    }

    public String getJcrSuperTypes() {
        return this.jcrSuperTypes;
    }

    public void setJcrSuperTypes(String superTypes) {
        if (superTypes != null && !superTypes.equals("")) {
            this.jcrSuperTypes = superTypes;
        }
    }

    public String[] getJcrMixinTypes() {
        return this.jcrMixinTypes;
    }

    public void setJcrMixinTypes(String[] mixinTypes) {
        if (null != mixinTypes && mixinTypes.length == 1) {
            this.jcrMixinTypes = mixinTypes[0].split(" *, *");
        }
    }

    public void setJcrMixinTypes(String mixinTypes) {
        if (mixinTypes != null && !mixinTypes.equals("")) {
            this.jcrMixinTypes = mixinTypes.split(" *, *");
        }
    }

    public MappingDescriptor getMappingDescriptor() {
        return this.mappingDescriptor;
    }

    public void setMappingDescriptor(MappingDescriptor mappingDescriptor) {
        this.mappingDescriptor = mappingDescriptor;
    }

    public void afterPropertiesSet() {
        this.validateClassName();
        this.lookupSuperDescriptor();
        this.lookupInheritanceSettings();
    }

    private void validateClassName() {
        try {
            ReflectionUtils.forName(this.className);
        }
        catch (JcrMappingException e) {
            throw new JcrMappingException("Class used in descriptor not found : " + this.className);
        }
    }

    private void lookupSuperDescriptor() {
        if (null != this.superClassDescriptor) {
            this.hasDiscriminator = this.superClassDescriptor.hasDiscriminator();
            if (this.jcrMixinTypes == null || this.jcrMixinTypes.length == 0) {
                this.jcrMixinTypes = this.superClassDescriptor.jcrMixinTypes;
            }
            if (!this.isInterface) {
                this.fieldDescriptors = this.mergeFields(this.fieldDescriptors, this.superClassDescriptor.getFieldDescriptors());
                this.beanDescriptors = this.mergeBeans(this.beanDescriptors, this.superClassDescriptor.getBeanDescriptors());
                this.collectionDescriptors = this.mergeCollections(this.collectionDescriptors, this.superClassDescriptor.getCollectionDescriptors());
                this.fieldNames.putAll(this.superClassDescriptor.getFieldNames());
            }
        }
    }

    private void lookupInheritanceSettings() {
        if (null != this.superClassDescriptor || this.hasDescendants() || this.hasInterfaces()) {
            this.extendsStrategy = this.hasDiscriminator() ? NODETYPE_PER_HIERARCHY : NODETYPE_PER_CONCRETECLASS;
        }
    }

    public String getExtend() {
        return this.superClassName;
    }

    public void setExtend(String className) {
        if (className != null && className.length() == 0) {
            className = null;
        }
        this.superClassName = className;
    }

    public ClassDescriptor getSuperClassDescriptor() {
        return this.superClassDescriptor;
    }

    public Collection getDescendantClassDescriptors() {
        return this.descendantClassDescriptors;
    }

    public ClassDescriptor getDescendantClassDescriptor(String nodeType) {
        for (ClassDescriptor descendantClassDescriptor : this.descendantClassDescriptors) {
            ClassDescriptor classDescriptor;
            if (nodeType.equals(descendantClassDescriptor.getJcrType())) {
                return descendantClassDescriptor;
            }
            if (!descendantClassDescriptor.hasDescendants() || (classDescriptor = descendantClassDescriptor.getDescendantClassDescriptor(nodeType)) == null) continue;
            return classDescriptor;
        }
        return null;
    }

    public void addDescendantClassDescriptor(ClassDescriptor classDescriptor) {
        this.descendantClassDescriptors.add(classDescriptor);
        this.hasDescendant = true;
    }

    public boolean hasDescendants() {
        return this.hasDescendant;
    }

    public void setSuperClassDescriptor(ClassDescriptor superClassDescriptor) {
        this.superClassDescriptor = superClassDescriptor;
        superClassDescriptor.addDescendantClassDescriptor(this);
    }

    public Set getImplements() {
        return this.interfaces;
    }

    public void setImplements(Set interfaces) {
        this.interfaces = interfaces;
    }

    private Map mergeFields(Map existing, Collection superSource) {
        if (null == superSource) {
            return existing;
        }
        HashMap<String, FieldDescriptor> merged = new HashMap<String, FieldDescriptor>(existing);
        for (FieldDescriptor fieldDescriptor : superSource) {
            if (merged.containsKey(fieldDescriptor.getFieldName())) continue;
            merged.put(fieldDescriptor.getFieldName(), fieldDescriptor);
        }
        return merged;
    }

    private Map mergeBeans(Map existing, Collection superSource) {
        if (null == superSource) {
            return existing;
        }
        HashMap<String, BeanDescriptor> merged = new HashMap<String, BeanDescriptor>(existing);
        for (BeanDescriptor beanDescriptor : superSource) {
            if (merged.containsKey(beanDescriptor.getFieldName())) continue;
            merged.put(beanDescriptor.getFieldName(), beanDescriptor);
        }
        return merged;
    }

    private Map mergeCollections(Map existing, Collection superSource) {
        if (null == superSource) {
            return existing;
        }
        HashMap<String, CollectionDescriptor> merged = new HashMap<String, CollectionDescriptor>(existing);
        for (CollectionDescriptor collectionDescriptor : superSource) {
            if (merged.containsKey(collectionDescriptor.getFieldName())) continue;
            merged.put(collectionDescriptor.getFieldName(), collectionDescriptor);
        }
        return merged;
    }

    public String toString() {
        return "Class Descriptor : " + this.getClassName();
    }
}

