/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.collectionconverter.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableCollection;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableMap;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjects;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjectsUtil;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.AbstractCollectionConverterImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;

public class ResidualNodesCollectionConverterImpl
extends AbstractCollectionConverterImpl {
    public ResidualNodesCollectionConverterImpl(Map atomicTypeConverters, ObjectConverter objectConverter, Mapper mapper) {
        super(atomicTypeConverters, objectConverter, mapper);
    }

    protected void doInsertCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) {
        if (!(objects instanceof ManageableMap)) {
            return;
        }
        Map map = (Map)objects.getObjects();
        for (Map.Entry entry : map.entrySet()) {
            String name = String.valueOf(entry.getKey());
            this.objectConverter.insert(session, parentNode, name, entry.getValue());
        }
    }

    protected void doUpdateCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        if (!(objects instanceof ManageableMap)) {
            NodeIterator ni = parentNode.getNodes(jcrName);
            while (ni.hasNext()) {
                ni.nextNode().remove();
            }
            return;
        }
        Map map = (Map)objects.getObjects();
        HashSet<String> updatedItems = new HashSet<String>();
        for (Map.Entry entry : map.entrySet()) {
            String elementJcrName = String.valueOf(entry.getKey());
            Object item = entry.getValue();
            if (parentNode.hasNode(elementJcrName)) {
                this.objectConverter.update(session, parentNode, elementJcrName, item);
            } else {
                this.objectConverter.insert(session, parentNode, elementJcrName, item);
            }
            updatedItems.add(elementJcrName);
        }
        NodeIterator nodeIterator = parentNode.getNodes(jcrName);
        ArrayList<Node> removeNodes = new ArrayList<Node>();
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            if (updatedItems.contains(child.getName())) continue;
            removeNodes.add(child);
        }
        for (int i = 0; i < removeNodes.size(); ++i) {
            ((Node)removeNodes.get(i)).remove();
        }
    }

    protected ManageableObjects doGetCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        try {
            String jcrName = this.getCollectionJcrName(collectionDescriptor);
            NodeIterator ni = parentNode.getNodes(jcrName);
            if (!ni.hasNext()) {
                return null;
            }
            ManageableObjects objects = ManageableObjectsUtil.getManageableObjects(collectionFieldClass);
            while (ni.hasNext()) {
                String name;
                Node node = ni.nextNode();
                if (node.getDefinition().isProtected()) continue;
                Object item = this.objectConverter.getObject(session, node.getPath());
                if (objects instanceof Map) {
                    name = node.getName();
                    ((Map)((Object)objects)).put(name, item);
                    continue;
                }
                if (objects instanceof ManageableCollection) {
                    ((ManageableCollection)objects).addObject(item);
                    continue;
                }
                name = node.getName();
                ((ManageableMap)objects).addObject(name, item);
            }
            return objects;
        }
        catch (ValueFormatException vfe) {
            throw new ObjectContentManagerException("Cannot get the collection field : " + collectionDescriptor.getFieldName() + "for class " + collectionDescriptor.getClassDescriptor().getClassName(), vfe);
        }
    }

    protected boolean doIsNull(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        return parentNode == null || !parentNode.getNodes(jcrName).hasNext();
    }
}

