/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.beanconverter.impl;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.exception.RepositoryException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverterProvider;
import org.apache.jackrabbit.ocm.manager.beanconverter.BeanConverter;
import org.apache.jackrabbit.ocm.manager.beanconverter.impl.AbstractBeanConverterImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.BeanDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanConverterImpl
extends AbstractBeanConverterImpl
implements BeanConverter {
    private static final Logger log = LoggerFactory.getLogger(DefaultBeanConverterImpl.class);

    public DefaultBeanConverterImpl(Mapper mapper, ObjectConverter objectConverter, AtomicTypeConverterProvider atomicTypeConverterProvider) {
        super(mapper, objectConverter, atomicTypeConverterProvider);
    }

    public void insert(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
        this.objectConverter.insert(session, parentNode, beanDescriptor.getJcrName(), object);
    }

    public void update(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
        try {
            String jcrNodeName = beanDescriptor.getJcrName();
            if (parentNode.hasNode(jcrNodeName)) {
                this.objectConverter.update(session, parentNode, beanDescriptor.getJcrName(), object);
            } else {
                this.objectConverter.insert(session, parentNode, beanDescriptor.getJcrName(), object);
            }
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public Object getObject(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Class beanClass, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
        return this.objectConverter.getObject(session, beanClass, this.getPath(session, beanDescriptor, parentNode));
    }

    public void remove(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
        try {
            if (parentNode.hasNode(beanDescriptor.getJcrName())) {
                parentNode.getNode(beanDescriptor.getJcrName()).remove();
            }
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }
}

